/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.autocomplete;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.javascript.JsUtils;
import org.odlabs.wiquery.ui.autocomplete.Autocomplete;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteAjaxComponent;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteJson;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteSource;
import org.odlabs.wiquery.ui.autocomplete.WiQueryAutocompleteJavascriptResourceReference;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutocompleteComponent<T>
extends FormComponentPanel<T> {
    private boolean autoUpdate = false;
    private static final long serialVersionUID = -3377109382248062940L;
    public static final JavascriptResourceReference WIQUERY_AUTOCOMPLETE_JS = new JavascriptResourceReference(AutocompleteAjaxComponent.class, "wiquery-autocomplete.js");
    private final Autocomplete<String> autocompleteField;
    private final HiddenField<String> autocompleteHidden;
    private static final String NOT_ENTERED = "NOT_ENTERED";
    private IChoiceRenderer<? super T> choiceRenderer;
    private AbstractDefaultAjaxBehavior updateAjax;

    public AbstractAutocompleteComponent(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupPlaceholderTag(true);
        this.autocompleteHidden = new HiddenField("autocompleteHidden", (IModel)new Model<String>(NOT_ENTERED){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Object modelObject = AbstractAutocompleteComponent.this.getModelObject();
                if (modelObject != null) {
                    return (String)((Object)super.getObject());
                }
                return null;
            }
        });
        this.autocompleteHidden.setOutputMarkupId(true);
        this.add(new Component[]{this.autocompleteHidden});
        this.autocompleteField = new InnerAutocomplete<String>("autocompleteField", new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Object modelObject = AbstractAutocompleteComponent.this.getModelObject();
                if (modelObject != null) {
                    Object objectValue = AbstractAutocompleteComponent.this.choiceRenderer.getDisplayValue(modelObject);
                    Class<?> objectClass = objectValue == null ? null : objectValue.getClass();
                    String displayValue = "";
                    if (objectClass != null && objectClass != String.class) {
                        IConverter converter = AbstractAutocompleteComponent.this.getConverter(objectClass);
                        displayValue = converter.convertToString(objectValue, AbstractAutocompleteComponent.this.getLocale());
                    } else if (objectValue != null) {
                        displayValue = objectValue.toString();
                    }
                    return displayValue;
                }
                return null;
            }

            public void setObject(String object) {
            }

            public void detach() {
            }
        });
        this.add(new Component[]{this.autocompleteField});
        this.updateAjax = new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                String hiddenInput = AbstractAutocompleteComponent.this.autocompleteHidden.getInput();
                String fieldInput = AbstractAutocompleteComponent.this.autocompleteField.getInput();
                AbstractAutocompleteComponent.this.autocompleteHidden.setConvertedInput((Object)hiddenInput);
                AbstractAutocompleteComponent.this.autocompleteField.setConvertedInput(fieldInput);
                AbstractAutocompleteComponent.this.validate();
                if (AbstractAutocompleteComponent.this.isValid()) {
                    AbstractAutocompleteComponent.this.updateModel();
                    AbstractAutocompleteComponent.this.onUpdate(target);
                }
            }
        };
        this.add(new IBehavior[]{this.updateAjax});
    }

    public AbstractAutocompleteComponent(String id, IModel<T> model, IChoiceRenderer<? super T> renderer) {
        this(id, model);
        this.setChoiceRenderer(renderer);
    }

    protected void onUpdate(AjaxRequestTarget target) {
    }

    protected final void convertInput() {
        String valueId = (String)this.autocompleteHidden.getConvertedInput();
        String input = (String)this.autocompleteField.getConvertedInput();
        Object object = this.getModelObject();
        IChoiceRenderer<T> renderer = this.getChoiceRenderer();
        if (NOT_ENTERED.equals(valueId)) {
            valueId = null;
        }
        if (valueId == null && Strings.isEmpty((CharSequence)input)) {
            this.setConvertedInput(null);
        } else if (valueId == null) {
            this.setConvertedInput(this.getValueOnSearchFail(input));
        } else if (object == null || input.compareTo((String)renderer.getDisplayValue(object)) != 0) {
            List<T> choices = this.getChoices();
            boolean found = false;
            for (int index = 0; index < choices.size(); ++index) {
                T choice = choices.get(index);
                String idValue = renderer.getIdValue(choice, index + 1);
                if (!idValue.equals(valueId)) continue;
                this.setConvertedInput(choice);
                found = true;
                break;
            }
            if (!found) {
                if (valueId.equals(NOT_ENTERED)) {
                    this.setConvertedInput(this.getModelObject());
                } else {
                    this.setConvertedInput(this.getValueOnSearchFail(input));
                }
            }
        } else {
            this.setConvertedInput(object);
        }
    }

    protected abstract List<? extends T> getChoices();

    public Autocomplete<String> getAutocompleteField() {
        return this.autocompleteField;
    }

    public HiddenField<String> getAutocompleteHidden() {
        return this.autocompleteHidden;
    }

    public abstract T getValueOnSearchFail(String var1);

    protected AutocompleteJson newAutocompleteJson(int id, T obj) {
        boolean thisOneSelected = obj.equals(this.getModelObject());
        Object objectValue = this.getChoiceRenderer().getDisplayValue(obj);
        Class<?> objectClass = objectValue == null ? null : objectValue.getClass();
        String displayValue = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter converter = this.getConverter(objectClass);
            displayValue = converter.convertToString(objectValue, this.getLocale());
        } else if (objectValue != null) {
            displayValue = objectValue.toString();
        }
        String idValue = this.getChoiceRenderer().getIdValue(obj, id);
        if (thisOneSelected) {
            this.autocompleteHidden.setModelObject((Object)idValue);
        }
        return new AutocompleteJson(idValue, displayValue);
    }

    protected void onBeforeRenderAutocomplete(Autocomplete<?> autocomplete) {
    }

    public void setChoiceRenderer(IChoiceRenderer<? super T> choiceRenderer) {
        this.choiceRenderer = choiceRenderer;
    }

    public IChoiceRenderer<? super T> getChoiceRenderer() {
        if (this.choiceRenderer == null) {
            this.choiceRenderer = new ChoiceRenderer();
        }
        return this.choiceRenderer;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerAutocomplete<E>
    extends Autocomplete<E> {
        private static final long serialVersionUID = -6129719872925080990L;

        public InnerAutocomplete(String id, IModel<E> model) {
            super(id, model);
        }

        @Override
        public void contribute(WiQueryResourceManager wiQueryResourceManager) {
            super.contribute(wiQueryResourceManager);
            wiQueryResourceManager.addJavaScriptResource((ResourceReference)WiQueryAutocompleteJavascriptResourceReference.get());
        }

        protected void onBeforeRender() {
            AbstractAutocompleteComponent.this.onBeforeRenderAutocomplete(this);
            super.onBeforeRender();
        }

        @Override
        public Autocomplete<E> setCloseEvent(JsScopeUiEvent close) {
            throw new WicketRuntimeException("You can't define the close event");
        }

        @Override
        public Autocomplete<E> setSelectEvent(JsScopeUiEvent select) {
            throw new WicketRuntimeException("You can't define the select event");
        }

        @Override
        public Autocomplete<E> setChangeEvent(JsScopeUiEvent select) {
            throw new WicketRuntimeException("You can't define the change event");
        }

        @Override
        public Autocomplete<E> setSource(AutocompleteSource source) {
            throw new WicketRuntimeException("You can't define the source");
        }

        @Override
        public JsStatement statement() {
            StringBuilder js = new StringBuilder();
            js.append("$.ui.autocomplete.wiquery.changeEvent(event, ui,").append(JsUtils.quotes(AbstractAutocompleteComponent.this.autocompleteHidden.getMarkupId()));
            if (AbstractAutocompleteComponent.this.isAutoUpdate()) {
                js.append(",'").append(AbstractAutocompleteComponent.this.updateAjax.getCallbackUrl(true)).append("'");
            }
            js.append(");");
            super.setChangeEvent(JsScopeUiEvent.quickScope(js.toString()));
            super.setSelectEvent(JsScopeUiEvent.quickScope(js.append("$(event.target).blur();").toString()));
            JsStatement jsStatement = super.statement();
            return jsStatement;
        }
    }
}

