/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.autocomplete;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.javascript.JsUtils;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteJavascriptResourceReference;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteSource;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.position.PositionJavascriptResourceReference;
import org.odlabs.wiquery.ui.position.PositionOptions;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WiQueryUIPlugin
public class Autocomplete<T>
extends TextField<T>
implements IWiQueryPlugin {
    private static final long serialVersionUID = -28740287216028869L;
    private Options options = new Options((Component)this);

    public Autocomplete(String id) {
        super(id);
    }

    public Autocomplete(String id, IModel<T> model) {
        super(id, model);
    }

    protected void detachModel() {
        super.detachModel();
        this.options.detach();
    }

    @Override
    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)PositionJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)AutocompleteJavascriptResourceReference.get());
    }

    protected Options getOptions() {
        return this.options;
    }

    @Override
    public JsStatement statement() {
        return new JsQuery((Component)this).$().chain("autocomplete", this.options.getJavaScriptOptions());
    }

    public Autocomplete<T> setAppendTo(String appendTo) {
        this.options.putLiteral("appendTo", appendTo);
        return this;
    }

    public String getAppendTo() {
        String appendTo = this.options.getLiteral("appendTo");
        return appendTo == null ? "body" : appendTo;
    }

    public Autocomplete<T> setDelay(int delay) {
        this.options.put("delay", delay);
        return this;
    }

    public int getDelay() {
        if (this.options.containsKey("delay")) {
            return this.options.getInt("delay");
        }
        return 300;
    }

    public Autocomplete<T> setMinLength(int minLength) {
        this.options.put("minLength", minLength);
        return this;
    }

    public int getMinLength() {
        if (this.options.containsKey("minLength")) {
            return this.options.getInt("minLength");
        }
        return 1;
    }

    public Autocomplete<T> setPosition(PositionOptions position) {
        this.options.put("position", position);
        return this;
    }

    public PositionOptions getPosition() {
        IComplexOption position = this.options.getComplexOption("position");
        if (position != null && position instanceof PositionOptions) {
            return (PositionOptions)position;
        }
        PositionOptions pos = new PositionOptions();
        pos.setAt(PositionOptions.Position.LEFT_BOTTOM);
        pos.setCollision(PositionOptions.Collision.NONE);
        pos.setMy(PositionOptions.Position.LEFT_TOP);
        return pos;
    }

    public Autocomplete<T> setSource(AutocompleteSource source) {
        this.options.put("source", source);
        return this;
    }

    public AutocompleteSource getSource() {
        IComplexOption source = this.options.getComplexOption("source");
        if (source instanceof AutocompleteSource) {
            return (AutocompleteSource)source;
        }
        return null;
    }

    public Autocomplete<T> setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public Autocomplete<T> setChangeEvent(JsScopeUiEvent change) {
        this.options.put("change", change);
        return this;
    }

    public Autocomplete<T> setCloseEvent(JsScopeUiEvent close) {
        this.options.put("close", close);
        return this;
    }

    public Autocomplete<T> setFocusEvent(JsScopeUiEvent focus) {
        this.options.put("focus", focus);
        return this;
    }

    public Autocomplete<T> setOpenEvent(JsScopeUiEvent open) {
        this.options.put("open", open);
        return this;
    }

    public Autocomplete<T> setSearchEvent(JsScopeUiEvent search) {
        this.options.put("search", search);
        return this;
    }

    public Autocomplete<T> setSelectEvent(JsScopeUiEvent select) {
        this.options.put("select", select);
        return this;
    }

    public JsStatement close() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'close'");
    }

    public void close(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.close().render().toString());
    }

    public JsStatement destroy() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement search() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'search'");
    }

    public void search(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.search().render().toString());
    }

    public JsStatement search(String value) {
        return new JsQuery((Component)this).$().chain("autocomplete", "'search'", JsUtils.quotes(value));
    }

    public void search(AjaxRequestTarget ajaxRequestTarget, String value) {
        ajaxRequestTarget.appendJavascript(this.search(value).render().toString());
    }

    public JsStatement widget() {
        return new JsQuery((Component)this).$().chain("autocomplete", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }
}

