/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.autocomplete;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.target.basic.StringRequestTarget;
import org.apache.wicket.util.string.Strings;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.odlabs.wiquery.ui.autocomplete.AbstractAutocompleteComponent;
import org.odlabs.wiquery.ui.autocomplete.Autocomplete;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteJson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutocompleteAjaxComponent<T>
extends AbstractAutocompleteComponent<T> {
    private String term;
    private static final long serialVersionUID = -3377109382248062940L;
    private final InnerAutocompleteAjaxBehavior innerAutcompleteAjaxBehavior = new InnerAutocompleteAjaxBehavior();

    public AutocompleteAjaxComponent(String id, IModel<T> model) {
        super(id, model);
        this.add(new IBehavior[]{this.innerAutcompleteAjaxBehavior});
    }

    public AutocompleteAjaxComponent(String id, IModel<T> model, IChoiceRenderer<? super T> choiceRenderer) {
        super(id, model, choiceRenderer);
        this.add(new IBehavior[]{this.innerAutcompleteAjaxBehavior});
    }

    public abstract List<T> getValues(String var1);

    @Override
    protected List<? extends T> getChoices() {
        return this.getValues(this.term);
    }

    @Override
    protected void onBeforeRenderAutocomplete(Autocomplete<?> autocomplete) {
        Object defaultValue = this.getModelObject();
        if (defaultValue != null) {
            AutocompleteJson value = null;
            value = this.newAutocompleteJson(0, defaultValue);
            autocomplete.setDefaultModelObject(value.getLabel());
            this.getAutocompleteHidden().setModelObject((Object)value.getValueId());
        }
        autocomplete.getOptions().putLiteral("source", this.innerAutcompleteAjaxBehavior.getCallbackUrl().toString());
    }

    private class InnerAutocompleteAjaxBehavior
    extends AbstractAjaxBehavior {
        private static final long serialVersionUID = -5411632961744455568L;

        private InnerAutocompleteAjaxBehavior() {
        }

        public void onRequest() {
            AutocompleteAjaxComponent.this.term = this.getComponent().getRequest().getParameter("term");
            if (!Strings.isEmpty((CharSequence)AutocompleteAjaxComponent.this.term)) {
                StringWriter sw = new StringWriter();
                try {
                    JsonGenerator gen = new JsonFactory().createJsonGenerator((Writer)sw);
                    AutocompleteJson value = null;
                    Integer index = 0;
                    ArrayList<AutocompleteJson> json = new ArrayList<AutocompleteJson>();
                    for (Object obj : AutocompleteAjaxComponent.this.getValues(AutocompleteAjaxComponent.this.term)) {
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                        value = AutocompleteAjaxComponent.this.newAutocompleteJson(index, obj);
                        json.add(value);
                    }
                    new ObjectMapper().writeValue(gen, json);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                RequestCycle.get().setRequestTarget((IRequestTarget)new StringRequestTarget("application/json", "utf-8", sw.toString()));
            }
        }
    }
}

