/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.autocomplete;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.odlabs.wiquery.ui.autocomplete.AbstractAutocompleteComponent;
import org.odlabs.wiquery.ui.autocomplete.Autocomplete;
import org.odlabs.wiquery.ui.autocomplete.AutocompleteJson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutocompleteComponent<T>
extends AbstractAutocompleteComponent<T> {
    private static final long serialVersionUID = -3377109382248062940L;
    private final IModel<? extends List<? extends T>> list;

    public AutocompleteComponent(String id, IModel<T> model, IModel<? extends List<? extends T>> list) {
        super(id, model);
        this.list = list;
    }

    public AutocompleteComponent(String id, IModel<T> model, IModel<? extends List<? extends T>> list, IChoiceRenderer<? super T> choiceRenderer) {
        super(id, model, choiceRenderer);
        this.list = list;
    }

    @Override
    protected void onBeforeRenderAutocomplete(Autocomplete<?> autocomplete) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createJsonGenerator((Writer)sw);
            ArrayList<AutocompleteJson> json = new ArrayList<AutocompleteJson>();
            Object defaultValue = this.getModelObject();
            AutocompleteJson value = null;
            Integer index = 0;
            for (Object obj : (List)this.list.getObject()) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                value = this.newAutocompleteJson(index, obj);
                json.add(value);
                if (!obj.equals(defaultValue)) continue;
                autocomplete.setDefaultModelObject(value.getLabel());
                this.getAutocompleteHidden().setModelObject((Object)value.getValueId());
            }
            new ObjectMapper().writeValue(gen, json);
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        autocomplete.getOptions().put("source", sw.toString());
    }

    @Override
    protected List<? extends T> getChoices() {
        return (List)this.list.getObject();
    }

    protected void onDetach() {
        super.onDetach();
        if (this.list != null) {
            this.list.detach();
        }
    }
}

