/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.button;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.button.ButtonIcon;
import org.odlabs.wiquery.ui.button.ButtonJavascriptResourceReference;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.themes.UiIcon;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WiQueryUIPlugin
public class ButtonBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = -4079980500720298690L;
    private Options options = new Options();

    @Override
    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    @Override
    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ButtonJavascriptResourceReference.get());
    }

    protected Options getOptions() {
        return this.options;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        String tagname = tag.getName();
        if (!(tagname.equalsIgnoreCase("input") || tagname.equalsIgnoreCase("button") || tagname.equalsIgnoreCase("submit") || tagname.equalsIgnoreCase("reset") || tagname.equalsIgnoreCase("a"))) {
            throw new WicketRuntimeException("Component " + component.getId() + " must be applied to a tag of type 'input', 'button' or 'a', not " + tag.toUserDebugString());
        }
        super.onComponentTag(component, tag);
    }

    @Override
    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("button", this.options.getJavaScriptOptions());
    }

    public ButtonBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public Boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return null;
    }

    public ButtonBehavior setText(boolean text) {
        this.options.put("text", text);
        return this;
    }

    public boolean isText() {
        if (this.options.containsKey("text")) {
            return this.options.getBoolean("text");
        }
        return true;
    }

    public ButtonBehavior setIcons(ButtonIcon icons) {
        this.options.put("icons", icons);
        return this;
    }

    public ButtonBehavior setIcons(UiIcon primary, UiIcon secondary) {
        this.options.put("icons", new ButtonIcon(primary, secondary));
        return this;
    }

    public ButtonIcon getIcons() {
        return (ButtonIcon)this.options.getComplexOption("icons");
    }

    public ButtonBehavior setLabel(String label) {
        this.options.putLiteral("label", label);
        return this;
    }

    public ButtonBehavior setLabel(IModel<String> label) {
        this.options.putLiteral("label", label);
        return this;
    }

    public String getLabel() {
        return this.options.getLiteral("label");
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("button", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("button", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("button", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("button", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }
}

