/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.button;

import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.LiteralOption;
import org.odlabs.wiquery.ui.themes.UiIcon;

public class ButtonIcon
implements IComplexOption {
    private static final long serialVersionUID = 4723376695783554832L;
    private String primary;
    private String secondary;

    public ButtonIcon(String primary, String secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public ButtonIcon(UiIcon primary, UiIcon secondary) {
        if (primary == null) {
            throw new IllegalArgumentException("Primary UI icon should be non-null");
        }
        this.primary = primary.getCssClass();
        if (secondary != null) {
            this.secondary = secondary.getCssClass();
        }
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public CharSequence getJavascriptOption() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        if (this.primary != null && this.secondary != null) {
            buffer.append("primary: " + new LiteralOption(this.primary));
            buffer.append(", secondary: " + new LiteralOption(this.secondary));
        } else if (this.primary != null) {
            buffer.append("primary: " + new LiteralOption(this.primary));
        } else if (this.primary != null) {
            buffer.append("secondary: " + new LiteralOption(this.secondary));
        }
        buffer.append("}");
        return buffer;
    }

    public void setHeaderClass(String primary) {
        this.primary = primary;
    }

    public void setHeaderSelectedClass(String secondary) {
        this.secondary = secondary;
    }
}

