/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.datepicker;

import java.util.Date;
import org.odlabs.wiquery.core.javascript.helper.DateHelper;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.LiteralOption;

public class DateOption
implements IComplexOption {
    private static final long serialVersionUID = 3404088696595137949L;
    private Date dateParam;
    private Short shortParam;
    private String literalParam;

    public DateOption(Short shortParam) {
        this(shortParam, null, null);
    }

    public DateOption(String literalParam) {
        this(null, literalParam, null);
    }

    public DateOption(Date dateParam) {
        this(null, null, dateParam);
    }

    private DateOption(Short shortParam, String literalParam, Date dateParam) {
        this.setParam(shortParam, literalParam, dateParam);
    }

    public Date getDateParam() {
        return this.dateParam;
    }

    public String getLiteralParam() {
        return this.literalParam;
    }

    public Short getShortParam() {
        return this.shortParam;
    }

    public CharSequence getJavascriptOption() {
        if (this.shortParam == null && this.literalParam == null && this.dateParam == null) {
            throw new IllegalArgumentException("The DateOption must have one not null parameter");
        }
        CharSequence sequence = null;
        if (this.shortParam != null) {
            sequence = this.shortParam.toString();
        } else if (this.literalParam != null) {
            sequence = new LiteralOption(this.literalParam).toString();
        } else if (this.dateParam != null) {
            sequence = DateHelper.getJSDate(this.dateParam);
        } else {
            throw new IllegalArgumentException("The DateOption must have one not null parameter");
        }
        return sequence;
    }

    public void setDateParam(Date dateParam) {
        this.setParam(null, null, dateParam);
    }

    public void setLiteralParam(String literalParam) {
        this.setParam(null, literalParam, null);
    }

    public void setShortParam(Short shortParam) {
        this.setParam(shortParam, null, null);
    }

    private void setParam(Short shortParam, String literalParam, Date dateParam) {
        this.shortParam = shortParam;
        this.literalParam = literalParam;
        this.dateParam = dateParam;
    }
}

