/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.datepicker;

import java.util.Locale;
import org.odlabs.wiquery.core.commons.WiQueryJavaScriptResourceReference;

public class DatePickerLanguageResourceReference
extends WiQueryJavaScriptResourceReference {
    private static final long serialVersionUID = 5955164494361831059L;

    protected DatePickerLanguageResourceReference(Locale locale, String filename) {
        super(DatePickerLanguageResourceReference.class, filename);
    }

    public static DatePickerLanguageResourceReference get(Locale locale) {
        DatePickerLanguages dpl = DatePickerLanguages.getDatePickerLanguages(locale);
        if (dpl != null) {
            return new DatePickerLanguageResourceReference(locale, DatePickerLanguages.getJsFileName(dpl));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatePickerLanguages {
        AFRIKAANS("af"),
        ALGERIAN("ar", "DZ"),
        ARABIC("ar"),
        AZERBAIJANI("az"),
        BULGARIAN("bg"),
        BOSNIAN("bs"),
        CATALAN("ca"),
        CZECH("cs"),
        DANISH("da"),
        GERMAN(Locale.GERMAN),
        GREEK("el"),
        AUSTRALIAN("en", "AU"),
        UNITED_KINGDOM(Locale.UK),
        NEW_ZEALAND("en", "NZ"),
        ESPERANTO("eo"),
        SPANISH("es"),
        ESTONIAN("et"),
        EUSKARAKO("eu"),
        PERSIAN("fa"),
        FINNISH("fi"),
        FAROESE("fo"),
        SWISS("fr", "CH"),
        FRENCH(Locale.FRENCH),
        GALICIAN("gl"),
        HEBREW("he"),
        CROATIAN("hr"),
        HUNGARIAN("hu"),
        ARMENIAN("hy"),
        INDONESIAN("id"),
        ICELANDIC("is"),
        ITALIAN(Locale.ITALIAN),
        JAPANESE(Locale.JAPANESE),
        KOREAN(Locale.KOREAN),
        KAZAKH("kz"),
        LITHUANIAN("lt"),
        LATVIAN("lv"),
        MALAYALAM("ml"),
        MALAYSIAN("ms"),
        DUTCH("nl"),
        NORVEGIAN("no"),
        POLISH("pl"),
        BRAZILIAN("pt", "BR"),
        PORTUGUESE("pt"),
        ROMANSH("rm"),
        ROMANIAN("ro"),
        RUSSIAN("ru"),
        SLOVAK("sk"),
        SLOVENIAN("sl"),
        ALBANIAN("sq"),
        SERBIA("sr", "SR"),
        SERBIAN("sr"),
        SWEDISH("sv"),
        TAMIL("ta"),
        THAI("th"),
        TAJIKISTAN("tj"),
        TURKISH("tr"),
        UKRAINIAN("uk"),
        VIETNAMESE("vi"),
        SIMPLIFIED_CHINESE(Locale.SIMPLIFIED_CHINESE),
        CHINESE("zh", "HK"),
        TRADITIONAL_CHINESE(Locale.TRADITIONAL_CHINESE);

        private final Locale locale;

        private DatePickerLanguages(Locale locale) {
            this.locale = locale;
        }

        private DatePickerLanguages(String language) {
            this.locale = new Locale(language);
        }

        private DatePickerLanguages(String language, String country) {
            this.locale = new Locale(language, country);
        }

        private DatePickerLanguages(String language, String country, String variant) {
            this.locale = new Locale(language, country, variant);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public static DatePickerLanguages getDatePickerLanguages(Locale locale) {
            if (locale == null) {
                return null;
            }
            Locale tmpLocale = null;
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            String empty = "";
            country = country == null || country.trim().length() <= 0 ? null : country;
            String string = variant = variant == null || variant.trim().length() <= 0 ? null : variant;
            if (variant != null) {
                for (DatePickerLanguages l : DatePickerLanguages.values()) {
                    tmpLocale = l.getLocale();
                    if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(country) || !tmpLocale.getVariant().equals(variant)) continue;
                    return l;
                }
            }
            if (country != null) {
                for (DatePickerLanguages l : DatePickerLanguages.values()) {
                    tmpLocale = l.getLocale();
                    if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(country) || !tmpLocale.getVariant().equals(empty)) continue;
                    return l;
                }
            }
            for (DatePickerLanguages l : DatePickerLanguages.values()) {
                tmpLocale = l.getLocale();
                if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(empty) || !tmpLocale.getVariant().equals(empty)) continue;
                return l;
            }
            return null;
        }

        public static String getJsFileName(DatePickerLanguages dpl) {
            if (dpl == null) {
                return null;
            }
            Locale locale = dpl.getLocale();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            StringBuffer js = new StringBuffer();
            js.append("i18n/jquery.ui.datepicker-");
            js.append(locale.getLanguage());
            if (country != null && country.trim().length() > 0) {
                js.append("-" + country);
                if (variant != null && variant.trim().length() > 0) {
                    js.append("-" + variant);
                }
            }
            js.append(".js");
            return js.toString();
        }
    }
}

