/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.datepicker;

import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.LiteralOption;

public class DatePickerYearRange
implements IComplexOption {
    private static final long serialVersionUID = 1L;
    private Short yearFrom;
    private Short yearTo;
    private DatePickerYearRangeControl controlTo;
    private DatePickerYearRangeControl controlFrom;

    public DatePickerYearRange(short yearFrom, short yearTo) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = DatePickerYearRangeControl.ABSOLUTE;
        this.controlFrom = DatePickerYearRangeControl.ABSOLUTE;
    }

    public DatePickerYearRange(short yearFrom, short yearTo, DatePickerYearRangeControl controlFrom, DatePickerYearRangeControl controlTo) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = controlTo == null ? DatePickerYearRangeControl.ABSOLUTE : controlTo;
        this.controlFrom = controlFrom == null ? DatePickerYearRangeControl.ABSOLUTE : controlFrom;
    }

    public DatePickerYearRange(short yearFrom, short yearTo, boolean yearRelativeToToday) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = yearRelativeToToday ? DatePickerYearRangeControl.RELATIVE_TODAY : DatePickerYearRangeControl.RELATIVE_SELECTED_YEAR;
        this.controlFrom = yearRelativeToToday ? DatePickerYearRangeControl.RELATIVE_TODAY : DatePickerYearRangeControl.RELATIVE_SELECTED_YEAR;
    }

    public CharSequence getJavascriptOption() {
        if (this.yearFrom == null || this.yearTo == null || this.controlTo == null || this.controlFrom == null) {
            throw new IllegalArgumentException("The DatePickerYearRange needs all arguments !!");
        }
        return new LiteralOption(this.generateRangeFormat(this.yearFrom, this.controlFrom) + ":" + this.generateRangeFormat(this.yearTo, this.controlTo)).toString();
    }

    private String generateRangeFormat(Short value, DatePickerYearRangeControl control) {
        String preStr;
        if (control == DatePickerYearRangeControl.ABSOLUTE) {
            return value.toString();
        }
        String string = preStr = value > 0 ? "+" : "";
        if (control == DatePickerYearRangeControl.RELATIVE_SELECTED_YEAR) {
            preStr = "c" + preStr;
        }
        return preStr + value.toString();
    }

    public void setAbsoluteRange(short yearFrom, short yearTo) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = DatePickerYearRangeControl.ABSOLUTE;
        this.controlFrom = DatePickerYearRangeControl.ABSOLUTE;
    }

    public void setRelativeRange(short yearFrom, short yearTo, boolean yearRelativeToToday) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = yearRelativeToToday ? DatePickerYearRangeControl.RELATIVE_TODAY : DatePickerYearRangeControl.RELATIVE_SELECTED_YEAR;
        this.controlFrom = yearRelativeToToday ? DatePickerYearRangeControl.RELATIVE_TODAY : DatePickerYearRangeControl.RELATIVE_SELECTED_YEAR;
    }

    public void setRange(short yearFrom, short yearTo, DatePickerYearRangeControl controlFrom, DatePickerYearRangeControl controlTo) {
        this.yearFrom = yearFrom;
        this.yearTo = yearTo;
        this.controlTo = controlTo == null ? DatePickerYearRangeControl.ABSOLUTE : controlTo;
        this.controlFrom = controlFrom == null ? DatePickerYearRangeControl.ABSOLUTE : controlFrom;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatePickerYearRangeControl {
        ABSOLUTE,
        RELATIVE_SELECTED_YEAR,
        RELATIVE_TODAY;

    }
}

