/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.dialog;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ListItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.button.ButtonJavascriptResourceReference;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.dialog.DialogButton;
import org.odlabs.wiquery.ui.dialog.DialogJavaScriptResourceReference;
import org.odlabs.wiquery.ui.draggable.DraggableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.position.PositionJavascriptResourceReference;
import org.odlabs.wiquery.ui.resizable.ResizableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WiQueryUIPlugin
public class Dialog
extends WebMarkupContainer
implements IWiQueryPlugin {
    private static final long serialVersionUID = 1L;
    private Options options = new Options((Component)this);

    public Dialog(String id) {
        super(id);
        this.setAutoOpen(false);
        this.setPosition(WindowPosition.CENTER);
    }

    protected void detachModel() {
        super.detachModel();
        this.options.detach();
    }

    @Override
    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)PositionJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DialogJavaScriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ButtonJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DraggableJavaScriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ResizableJavaScriptResourceReference.get());
    }

    @Override
    public JsStatement statement() {
        return new JsQuery((Component)this).$().chain("dialog", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    public JsStatement open() {
        return new JsQuery((Component)this).$().chain("dialog", "'open'");
    }

    public JsStatement close() {
        return new JsQuery((Component)this).$().chain("dialog", "'close'");
    }

    public void open(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.open().render().toString());
    }

    public void close(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.close().render().toString());
    }

    public Dialog setAutoOpen(boolean autoOpen) {
        this.options.put("autoOpen", autoOpen);
        return this;
    }

    public Dialog setModal(boolean modal) {
        this.options.put("modal", modal);
        return this;
    }

    public Dialog setOverlayRatio(float ratio) {
        this.options.put("overlay", "{opacity: " + ratio + ", background: 'black'}");
        return this;
    }

    public boolean isAutoOpen() {
        if (this.options.containsKey("autoOpen")) {
            return this.options.getBoolean("autoOpen");
        }
        return true;
    }

    public boolean isModal() {
        if (this.options.containsKey("modal")) {
            return this.options.getBoolean("modal");
        }
        return false;
    }

    public Dialog setWidth(int width) {
        this.options.put("width", width);
        return this;
    }

    public int getWidth() {
        if (this.options.containsKey("width")) {
            return this.options.getInt("width");
        }
        return 300;
    }

    public Dialog setHeight(int height) {
        this.options.put("height", height);
        return this;
    }

    public int getHeight() {
        if (this.options.containsKey("height")) {
            return this.options.getInt("height");
        }
        return 0;
    }

    public Dialog setPosition(WindowPosition windowPosition) {
        this.options.putLiteral("position", windowPosition.name().toLowerCase());
        return this;
    }

    public WindowPosition getPosition() {
        String literal = this.options.getLiteral("position");
        return literal == null ? WindowPosition.CENTER : WindowPosition.valueOf(literal.toUpperCase());
    }

    public Dialog setCloseText(String closeText) {
        this.options.putLiteral("closeText", closeText);
        return this;
    }

    public String getCloseText() {
        String closeText = this.options.getLiteral("closeText");
        return closeText == null ? "close" : closeText;
    }

    public Dialog setCssClass(String cssClass) {
        this.options.putLiteral("dialogClass", cssClass);
        return this;
    }

    public String getCssClass() {
        String dialogClass = this.options.getLiteral("dialogClass");
        return dialogClass == null ? "*" : dialogClass;
    }

    public Dialog setHideEffect(String hideEffect) {
        this.options.putLiteral("hide", hideEffect);
        return this;
    }

    public String getHideEffect() {
        return this.options.getLiteral("hide");
    }

    public Dialog setShowEffect(String hideEffect) {
        this.options.putLiteral("show", hideEffect);
        return this;
    }

    public String getShowEffect() {
        return this.options.getLiteral("show");
    }

    public Dialog setMaxHeight(int maxHeight) {
        this.options.put("maxHeight", maxHeight);
        return this;
    }

    public int getMaxHeight() {
        if (this.options.containsKey("maxHeight")) {
            return this.options.getInt("maxHeight");
        }
        return 0;
    }

    public Dialog setMaxWidth(int maxWidth) {
        this.options.put("maxWidth", maxWidth);
        return this;
    }

    public int getMaxWidth() {
        if (this.options.containsKey("maxWidth")) {
            return this.options.getInt("maxWidth");
        }
        return 0;
    }

    public Dialog setMinHeight(int minHeight) {
        this.options.put("minHeight", minHeight);
        return this;
    }

    public int getMinHeight() {
        if (this.options.containsKey("minHeight")) {
            return this.options.getInt("minHeight");
        }
        return 150;
    }

    public Dialog setMinWidth(int minWidth) {
        this.options.put("minWidth", minWidth);
        return this;
    }

    public int getMinWidth() {
        if (this.options.containsKey("minWidth")) {
            return this.options.getInt("minWidth");
        }
        return 150;
    }

    public Dialog setResizable(boolean resizable) {
        this.options.put("resizable", resizable);
        return this;
    }

    public boolean isResizable() {
        if (this.options.containsKey("resizable")) {
            return this.options.getBoolean("resizable");
        }
        return true;
    }

    public Dialog setTitle(String title) {
        this.options.putLiteral("title", title);
        return this;
    }

    public Dialog setTitle(IModel<String> title) {
        this.options.putLiteral("title", title);
        return this;
    }

    public String getTitle() {
        if (this.options.containsKey("title")) {
            return this.options.getLiteral("title");
        }
        return "";
    }

    public Dialog setCloseOnEscape(boolean closeOnEscape) {
        this.options.put("closeOnEscape", closeOnEscape);
        return this;
    }

    public boolean isCloseOnEscape() {
        if (this.options.containsKey("closeOnEscape")) {
            return this.options.getBoolean("closeOnEscape");
        }
        return true;
    }

    public Dialog setBgiframe(boolean bgiframe) {
        this.options.put("bgiframe", bgiframe);
        return this;
    }

    public boolean isBgiframe() {
        if (this.options.containsKey("bgiframe")) {
            return this.options.getBoolean("bgiframe");
        }
        return false;
    }

    public Dialog setDialogClass(String dialogClass) {
        this.options.putLiteral("dialogClass", dialogClass);
        return this;
    }

    public String getDialogClass() {
        if (this.options.containsKey("dialogClass")) {
            return this.options.getLiteral("dialogClass");
        }
        return "";
    }

    public Dialog setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public Dialog setDraggable(boolean draggable) {
        this.options.put("draggable", draggable);
        return this;
    }

    public boolean isDraggable() {
        if (this.options.containsKey("draggable")) {
            return this.options.getBoolean("draggable");
        }
        return true;
    }

    @Deprecated
    public boolean isDraggrable() {
        if (this.options.containsKey("draggable")) {
            return this.options.getBoolean("draggable");
        }
        return true;
    }

    public Dialog setStack(boolean stack) {
        this.options.put("stack", stack);
        return this;
    }

    public boolean isStack() {
        if (this.options.containsKey("stack")) {
            return this.options.getBoolean("stack");
        }
        return true;
    }

    public Dialog setZIndex(int zIndex) {
        this.options.put("zIndex", zIndex);
        return this;
    }

    public int getZIndex() {
        if (this.options.containsKey("zIndex")) {
            return this.options.getInt("zIndex");
        }
        return 1000;
    }

    public Dialog setButtons(ListItemOptions<DialogButton> buttons) {
        this.options.put("buttons", buttons);
        return this;
    }

    public ListItemOptions<DialogButton> getButtons() {
        if (this.options.containsKey("buttons")) {
            return (ListItemOptions)this.options.getListItemOptions("buttons");
        }
        return null;
    }

    @Deprecated
    public Dialog setBeforeCloseEvent(JsScopeUiEvent beforeclose) {
        this.options.put("beforeClose", beforeclose);
        return this;
    }

    public Dialog setCloseEvent(JsScopeUiEvent close) {
        this.options.put("close", close);
        return this;
    }

    public Dialog setDragEvent(JsScopeUiEvent drag) {
        this.options.put("drag", drag);
        return this;
    }

    public Dialog setDragStartEvent(JsScopeUiEvent dragStart) {
        this.options.put("dragStart", dragStart);
        return this;
    }

    public Dialog setDragStopEvent(JsScopeUiEvent dragStop) {
        this.options.put("dragStop", dragStop);
        return this;
    }

    public Dialog setFocusEvent(JsScopeUiEvent focus) {
        this.options.put("focus", focus);
        return this;
    }

    public Dialog setOpenEvent(JsScopeUiEvent open) {
        this.options.put("open", open);
        return this;
    }

    public Dialog setResizeEvent(JsScopeUiEvent resize) {
        this.options.put("resize", resize);
        return this;
    }

    public Dialog setResizeStartEvent(JsScopeUiEvent resizeStart) {
        this.options.put("resizeStart", resizeStart);
        return this;
    }

    public Dialog setResizeStopEvent(JsScopeUiEvent resizeStop) {
        this.options.put("resizeStop", resizeStop);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery((Component)this).$().chain("dialog", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery((Component)this).$().chain("dialog", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery((Component)this).$().chain("dialog", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement isOpen() {
        return new JsQuery((Component)this).$().chain("dialog", "'isOpen'");
    }

    public JsStatement moveToTop() {
        return new JsQuery((Component)this).$().chain("dialog", "'moveToTop'");
    }

    public void moveToTop(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.moveToTop().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery((Component)this).$().chain("dialog", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowPosition {
        TOP,
        BOTTOM,
        CENTER,
        LEFT,
        RIGHT;

    }
}

