/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.dialog.util;

import java.util.Locale;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.javascript.JsUtils;
import org.odlabs.wiquery.ui.button.ButtonJavascriptResourceReference;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.dialog.DialogJavaScriptResourceReference;
import org.odlabs.wiquery.ui.dialog.util.WaitDialogStatements;
import org.odlabs.wiquery.ui.draggable.DraggableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.position.PositionJavascriptResourceReference;
import org.odlabs.wiquery.ui.resizable.ResizableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class DialogUtilsBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 2337318416689834710L;
    private static final ResourceReference CANCEL_IMG = new ResourceReference(DialogUtilsBehavior.class, "cancel.png");
    private static final ResourceReference QUESTION_IMG = new ResourceReference(DialogUtilsBehavior.class, "questionmark.png");
    private static final ResourceReference WAIT_IMG = new ResourceReference(DialogUtilsBehavior.class, "wait.gif");
    private static final ResourceReference WARNING_IMG = new ResourceReference(DialogUtilsBehavior.class, "warning.png");
    public static final JavascriptResourceReference WIQUERY_DIALOG_JS = new JavascriptResourceReference(DialogUtilsBehavior.class, "wiquery-dialog.js");

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        super.contribute(wiQueryResourceManager);
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)PositionJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DialogJavaScriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ButtonJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DraggableJavaScriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ResizableJavaScriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WIQUERY_DIALOG_JS);
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DialogUtilsLanguages.getDialogUtilsResource(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())));
    }

    public JsStatement errorDialog(String message) {
        JsStatement statement = new JsStatement();
        statement.append("$.ui.dialog.wiquery.errorDialog(");
        statement.append("" + Session.get().nextSequenceValue() + ", ");
        statement.append(DialogUtilsLanguages.getDialogUtilsLiteral(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())) + ", ");
        statement.append(JsUtils.doubleQuotes(message, true) + ", ");
        statement.append(JsUtils.quotes(RequestCycle.get().urlFor(CANCEL_IMG)) + ")");
        return statement;
    }

    public Locale getLocale() {
        Locale l = this.getComponent() == null ? null : this.getComponent().getLocale();
        return l == null ? Locale.ENGLISH : l;
    }

    public JsStatement questionDialog(String message) {
        JsStatement statement = new JsStatement();
        statement.append("$.ui.dialog.wiquery.questionDialog(");
        statement.append("" + Session.get().nextSequenceValue() + ", ");
        statement.append(DialogUtilsLanguages.getDialogUtilsLiteral(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())) + ", ");
        statement.append(JsUtils.doubleQuotes(message, true) + ", ");
        statement.append(JsUtils.quotes(RequestCycle.get().urlFor(QUESTION_IMG)) + ")");
        return statement;
    }

    public JsStatement simpleDialog(String title, String message) {
        JsStatement statement = new JsStatement();
        statement.append("$.ui.dialog.wiquery.simpleDialog(");
        statement.append("" + Session.get().nextSequenceValue() + ", ");
        statement.append(DialogUtilsLanguages.getDialogUtilsLiteral(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())) + ", ");
        statement.append(JsUtils.quotes(title, true) + ", ");
        statement.append(JsUtils.doubleQuotes(message, true) + ")");
        return statement;
    }

    public JsStatement statement() {
        return new JsStatement();
    }

    public WaitDialogStatements waitDialog() {
        Integer id = Session.get().nextSequenceValue();
        JsStatement statement = new JsStatement();
        statement.append("$.ui.dialog.wiquery.waitDialog(");
        statement.append(id.toString() + ", ");
        statement.append(DialogUtilsLanguages.getDialogUtilsLiteral(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())) + ", ");
        statement.append(JsUtils.quotes(RequestCycle.get().urlFor(WAIT_IMG)) + ")");
        WaitDialogStatements wait = new WaitDialogStatements();
        wait.setOpen(statement);
        wait.setClose(new JsStatement().$(null, "#dialog" + id).chain("dialog", JsUtils.quotes("close")));
        return wait;
    }

    public JsStatement warningDialog(String message) {
        JsStatement statement = new JsStatement();
        statement.append("$.ui.dialog.wiquery.warningDialog(");
        statement.append("" + Session.get().nextSequenceValue() + ", ");
        statement.append(DialogUtilsLanguages.getDialogUtilsLiteral(DialogUtilsLanguages.getDialogUtilsLanguages(this.getLocale())) + ", ");
        statement.append(JsUtils.doubleQuotes(message, true) + ", ");
        statement.append(JsUtils.quotes(RequestCycle.get().urlFor(WARNING_IMG)) + ")");
        return statement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialogUtilsLanguages {
        ALBANIAN("sq"),
        ARABIC("ar"),
        BELARUSIAN("be"),
        BULGARIAN("bg"),
        CATALAN("ca"),
        CROATIAN("hr"),
        DANISH("da"),
        DEUTSCH(Locale.GERMAN),
        ENGLISH(Locale.ENGLISH),
        ESTONIAN("et"),
        FINNISH("fi"),
        FRENCH(Locale.FRENCH),
        GREEK("el"),
        HEBREW("iw"),
        HINDI("hi", "IN"),
        HUNGARIAN("hu"),
        ICELANDIC("is"),
        INDONESIAN("in"),
        ITALIAN("it"),
        JAPANESE("ja"),
        KOREAN(Locale.KOREAN),
        LITHUANIAN("lt"),
        NORVEGIAN("no"),
        POLISH("pl"),
        PORTUGUESE("pt"),
        ROUMANIAN("ro"),
        RUSSIAN("ru"),
        SERBIAN("sr"),
        SIMPLIFIED_CHINESE(Locale.SIMPLIFIED_CHINESE),
        SLOVAK("sk"),
        SLOVENIAN("sl"),
        SPANISH("es"),
        SWEDISH("sv"),
        THAI("th"),
        TRADITIONAL_CHINESE(Locale.TRADITIONAL_CHINESE),
        TURKISH("tr"),
        UKRAINIAN("uk"),
        VIETNAMESE("vi");

        private final Locale locale;

        public static DialogUtilsLanguages getDialogUtilsLanguages(Locale locale) {
            if (locale == null) {
                return ENGLISH;
            }
            Locale tmpLocale = null;
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            String empty = "";
            country = country == null || country.trim().length() <= 0 ? null : country;
            String string = variant = variant == null || variant.trim().length() <= 0 ? null : variant;
            if (variant != null) {
                for (DialogUtilsLanguages l : DialogUtilsLanguages.values()) {
                    tmpLocale = l.getLocale();
                    if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(country) || !tmpLocale.getVariant().equals(variant)) continue;
                    return l;
                }
            }
            if (country != null) {
                for (DialogUtilsLanguages l : DialogUtilsLanguages.values()) {
                    tmpLocale = l.getLocale();
                    if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(country) || !tmpLocale.getVariant().equals(empty)) continue;
                    return l;
                }
            }
            for (DialogUtilsLanguages l : DialogUtilsLanguages.values()) {
                tmpLocale = l.getLocale();
                if (!tmpLocale.getLanguage().equals(language) || !tmpLocale.getCountry().equals(empty) || !tmpLocale.getVariant().equals(empty)) continue;
                return l;
            }
            return ENGLISH;
        }

        public static CharSequence getDialogUtilsLiteral(DialogUtilsLanguages language) {
            Locale locale = language.getLocale();
            StringBuffer buffer = new StringBuffer();
            buffer.append(locale.getLanguage());
            if (locale.getCountry() != null && !locale.getCountry().equals("")) {
                buffer.append("_" + locale.getCountry());
                if (locale.getVariant() != null && !locale.getVariant().equals("")) {
                    buffer.append("_" + locale.getVariant());
                }
            }
            return JsUtils.quotes(buffer);
        }

        public static JavascriptResourceReference getDialogUtilsResource(DialogUtilsLanguages language) {
            Locale locale = language.getLocale();
            StringBuffer buffer = new StringBuffer();
            buffer.append("wiquery-dialog_");
            buffer.append(locale.getLanguage());
            if (locale.getCountry() != null && !locale.getCountry().equals("")) {
                buffer.append("_" + locale.getCountry());
                if (locale.getVariant() != null && !locale.getVariant().equals("")) {
                    buffer.append("_" + locale.getVariant());
                }
            }
            buffer.append(".js");
            return new JavascriptResourceReference(DialogUtilsBehavior.class, "i18n/" + buffer);
        }

        private DialogUtilsLanguages(Locale locale) {
            this.locale = locale;
        }

        private DialogUtilsLanguages(String language) {
            this.locale = new Locale(language);
        }

        private DialogUtilsLanguages(String language, String country) {
            this.locale = new Locale(language, country);
        }

        private DialogUtilsLanguages(String language, String country, String variant) {
            this.locale = new Locale(language, country, variant);
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

