/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.draggable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsScope;
import org.odlabs.wiquery.core.javascript.JsScopeContext;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.ListItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.draggable.DraggableBehavior;
import org.odlabs.wiquery.ui.draggable.DraggableContainment;
import org.odlabs.wiquery.ui.draggable.DraggableCursorAt;
import org.odlabs.wiquery.ui.draggable.DraggableHelper;
import org.odlabs.wiquery.ui.draggable.DraggableIframeFix;
import org.odlabs.wiquery.ui.draggable.DraggableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.draggable.DraggableRevert;
import org.odlabs.wiquery.ui.draggable.DraggableSnap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DraggableAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 3L;
    public static final JavascriptResourceReference wiQueryDraggableJs = new JavascriptResourceReference(DraggableJavaScriptResourceReference.class, "wiquery-draggable.js");
    protected static final String DRAG_TYPE = "dragType";
    protected static final String DRAG_STATUS = "dragStatus";
    private InnerDraggableBehavior draggableBehavior;
    private boolean enableAjaxOnInvalid;
    private Set<DraggableEvent> callbacks;

    public DraggableAjaxBehavior() {
        this(true, DraggableEvent.values());
    }

    public DraggableAjaxBehavior(boolean enableAjaxOnInvalid) {
        this(enableAjaxOnInvalid, DraggableEvent.values());
    }

    public DraggableAjaxBehavior(boolean enableAjaxOnInvalid, DraggableEvent ... callbacks) {
        this.enableAjaxOnInvalid = enableAjaxOnInvalid;
        this.draggableBehavior = new InnerDraggableBehavior();
        this.callbacks = new HashSet<DraggableEvent>(Arrays.asList(callbacks));
    }

    public DraggableAjaxBehavior(DraggableEvent ... callbacks) {
        this(true, callbacks);
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
    }

    public DraggableBehavior getDraggableBehavior() {
        return this.draggableBehavior;
    }

    protected void onBind() {
        this.getComponent().add(new IBehavior[]{this.draggableBehavior});
    }

    public final void onDrag(AjaxRequestTarget target) {
        Request request = this.getComponent().getRequest();
        DraggableEvent dragEvent = DraggableEvent.valueOf(request.getParameter(DRAG_TYPE).toUpperCase());
        switch (dragEvent) {
            case DRAG: {
                this.onDrag(this.getComponent(), target);
                break;
            }
            case START: {
                this.onStart(this.getComponent(), target);
                break;
            }
            case STOP: {
                this.onStop(this.getComponent(), target);
                if (Boolean.valueOf(request.getParameter(DRAG_STATUS)).booleanValue() && this.enableAjaxOnInvalid) {
                    this.onInvalid(this.getComponent(), target);
                    break;
                }
                this.onValid(this.getComponent(), target);
            }
        }
    }

    public abstract void onDrag(Component var1, AjaxRequestTarget var2);

    public void onInvalid(Component component, AjaxRequestTarget ajaxRequestTarget) {
    }

    public abstract void onStart(Component var1, AjaxRequestTarget var2);

    public abstract void onStop(Component var1, AjaxRequestTarget var2);

    public void onValid(Component component, AjaxRequestTarget ajaxRequestTarget) {
    }

    protected void respond(AjaxRequestTarget target) {
        this.onDrag(target);
    }

    protected JsStatement statement() {
        return this.draggableBehavior.statement();
    }

    protected CharSequence getCallbackStopEventScript(boolean onlyTargetActivePage) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&" + DRAG_TYPE + "=" + DraggableEvent.STOP.toString().toLowerCase() + "&" + DRAG_STATUS + "='+isInvalid");
    }

    protected CharSequence getCallbackScript(boolean onlyTargetActivePage, String dragType) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&" + DRAG_TYPE + "=" + dragType + "'");
    }

    public DraggableAjaxBehavior setAddClasses(boolean addClasses) {
        this.draggableBehavior.setAddClasses(addClasses);
        return this;
    }

    public boolean isAddClasses() {
        return this.draggableBehavior.isAddClasses();
    }

    public DraggableAjaxBehavior setAppendTo(String appendTo) {
        this.draggableBehavior.setAppendTo(appendTo);
        return this;
    }

    public String getAppendTo() {
        return this.draggableBehavior.getAppendTo();
    }

    public DraggableAjaxBehavior setAxis(DraggableBehavior.AxisEnum axis) {
        this.draggableBehavior.setAxis(axis);
        return this;
    }

    public DraggableBehavior.AxisEnum getAxis() {
        return this.draggableBehavior.getAxis();
    }

    public DraggableAjaxBehavior setCancel(String cancel) {
        this.draggableBehavior.setCancel(cancel);
        return this;
    }

    public String getCancel() {
        return this.draggableBehavior.getCancel();
    }

    public DraggableAjaxBehavior setConnectToSortable(String connectToSortable) {
        this.draggableBehavior.setConnectToSortable(connectToSortable);
        return this;
    }

    public String getConnectToSortable() {
        return this.draggableBehavior.getConnectToSortable();
    }

    public DraggableAjaxBehavior setContainment(DraggableContainment containment) {
        this.draggableBehavior.setContainment(containment);
        return this;
    }

    public DraggableContainment getContainment() {
        return this.draggableBehavior.getContainment();
    }

    public DraggableAjaxBehavior setCursor(String cursor) {
        this.draggableBehavior.setCursor(cursor);
        return this;
    }

    public String getCursor() {
        return this.draggableBehavior.getCursor();
    }

    public DraggableAjaxBehavior setCursorAt(ListItemOptions<DraggableCursorAt> cusorAt) {
        this.draggableBehavior.setCursorAt(cusorAt);
        return this;
    }

    public ListItemOptions<DraggableCursorAt> getCursorAtComplex() {
        return this.draggableBehavior.getCursorAtComplex();
    }

    public DraggableAjaxBehavior setDelay(int delay) {
        this.draggableBehavior.setDelay(delay);
        return this;
    }

    public int getDelay() {
        return this.draggableBehavior.getDelay();
    }

    public DraggableAjaxBehavior setDisabled(boolean disabled) {
        this.draggableBehavior.setDisabled(disabled);
        return this;
    }

    public boolean isDisabled() {
        return this.draggableBehavior.isDisabled();
    }

    public DraggableAjaxBehavior setDistance(int distance) {
        this.draggableBehavior.setDistance(distance);
        return this;
    }

    public int getDistance() {
        return this.draggableBehavior.getDistance();
    }

    public DraggableAjaxBehavior setGrid(int x, int y) {
        this.draggableBehavior.setGrid(x, y);
        return this;
    }

    public ICollectionItemOptions getGrid() {
        return this.draggableBehavior.getGrid();
    }

    public DraggableAjaxBehavior setHandle(String handle) {
        this.draggableBehavior.setHandle(handle);
        return this;
    }

    public String getHandle() {
        return this.draggableBehavior.getHandle();
    }

    public DraggableAjaxBehavior setHelper(DraggableHelper helper) {
        this.draggableBehavior.setHelper(helper);
        return this;
    }

    public DraggableHelper getHelper() {
        return this.draggableBehavior.getHelper();
    }

    public DraggableAjaxBehavior setIframeFix(DraggableIframeFix iframeFix) {
        this.draggableBehavior.setIframeFix(iframeFix);
        return this;
    }

    public DraggableIframeFix getIframeFix() {
        return this.draggableBehavior.getIframeFix();
    }

    public DraggableAjaxBehavior setOpacity(float opacity) {
        this.draggableBehavior.setOpacity(opacity);
        return this;
    }

    public float getOpacity() {
        return this.draggableBehavior.getOpacity();
    }

    public DraggableAjaxBehavior setRefreshPositions(boolean refreshPositions) {
        this.draggableBehavior.setRefreshPositions(refreshPositions);
        return this;
    }

    public boolean isRefreshPositions() {
        return this.draggableBehavior.isRefreshPositions();
    }

    public DraggableAjaxBehavior setRevert(DraggableRevert revert) {
        this.draggableBehavior.setRevert(revert);
        return this;
    }

    public DraggableRevert getRevert() {
        return this.draggableBehavior.getRevert();
    }

    public DraggableAjaxBehavior setRevertDuration(int revertDuration) {
        this.draggableBehavior.setRevertDuration(revertDuration);
        return this;
    }

    public int getRevertDuration() {
        return this.draggableBehavior.getRevertDuration();
    }

    public DraggableAjaxBehavior setScope(String scope) {
        this.draggableBehavior.setScope(scope);
        return this;
    }

    public String getScope() {
        return this.draggableBehavior.getScope();
    }

    public DraggableAjaxBehavior setScroll(boolean scroll) {
        this.draggableBehavior.setScroll(scroll);
        return this;
    }

    public boolean isScroll() {
        return this.draggableBehavior.isScroll();
    }

    public DraggableAjaxBehavior setScrollSensitivity(int scrollSensitivity) {
        this.draggableBehavior.setScrollSensitivity(scrollSensitivity);
        return this;
    }

    public int getScrollSensitivity() {
        return this.draggableBehavior.getScrollSensitivity();
    }

    public DraggableAjaxBehavior setScrollSpeed(int scrollSpeed) {
        this.draggableBehavior.setScrollSpeed(scrollSpeed);
        return this;
    }

    public int getScrollSpeed() {
        return this.draggableBehavior.getScrollSpeed();
    }

    public DraggableAjaxBehavior setSnap(DraggableSnap snap) {
        this.draggableBehavior.setSnap(snap);
        return this;
    }

    public DraggableSnap getSnap() {
        return this.draggableBehavior.getSnap();
    }

    public DraggableAjaxBehavior setSnapMode(DraggableBehavior.SnapModeEnum snapMode) {
        this.draggableBehavior.setSnapMode(snapMode);
        return this;
    }

    public DraggableBehavior.SnapModeEnum getSnapMode() {
        return this.draggableBehavior.getSnapMode();
    }

    public DraggableAjaxBehavior setSnapTolerance(int snapTolerance) {
        this.draggableBehavior.setSnapTolerance(snapTolerance);
        return this;
    }

    public int getSnapTolerance() {
        return this.draggableBehavior.getSnapTolerance();
    }

    public DraggableAjaxBehavior setStack(String stack) {
        this.draggableBehavior.setStack(stack);
        return this;
    }

    public String getStack() {
        return this.draggableBehavior.getStack();
    }

    public DraggableAjaxBehavior setZIndex(int zIndex) {
        this.draggableBehavior.setZIndex(zIndex);
        return this;
    }

    public int getZIndex() {
        return this.draggableBehavior.getZIndex();
    }

    public JsStatement destroy() {
        return this.draggableBehavior.destroy();
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        this.draggableBehavior.destroy(ajaxRequestTarget);
    }

    public JsStatement disable() {
        return this.draggableBehavior.disable();
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        this.draggableBehavior.disable(ajaxRequestTarget);
    }

    public JsStatement enable() {
        return this.draggableBehavior.enable();
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        this.draggableBehavior.enable(ajaxRequestTarget);
    }

    public JsStatement widget() {
        return this.draggableBehavior.widget();
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        this.draggableBehavior.widget(ajaxRequestTarget);
    }

    private class InnerDraggableBehavior
    extends DraggableBehavior {
        private static final long serialVersionUID = 5587258236214715234L;

        private InnerDraggableBehavior() {
        }

        public void contribute(WiQueryResourceManager wiQueryResourceManager) {
            super.contribute(wiQueryResourceManager);
            wiQueryResourceManager.addJavaScriptResource((ResourceReference)wiQueryDraggableJs);
            DraggableAjaxBehavior.this.contribute(wiQueryResourceManager);
        }

        private Options getInnerOptions() {
            return super.getOptions();
        }

        protected Options getOptions() {
            throw new UnsupportedOperationException("You can't call this method into the DraggableAjaxBehavior");
        }

        public DraggableBehavior setDragEvent(JsScopeUiEvent drag) {
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.DRAG)) {
                throw new UnsupportedOperationException("You can't call this method into the DraggableAjaxBehavior");
            }
            return super.setDragEvent(drag);
        }

        private DraggableBehavior setInnerDragEvent(JsScopeUiEvent drag) {
            return super.setDragEvent(drag);
        }

        private DraggableBehavior setInnerStartEvent(JsScopeUiEvent start) {
            return super.setStartEvent(start);
        }

        private void setInnerStopEvent(JsScopeUiEvent drop) {
            super.setStopEvent(drop);
        }

        public DraggableBehavior setRevert(DraggableRevert revert) {
            this.getInnerOptions().put("wiRevert", revert);
            return this;
        }

        public DraggableBehavior setStartEvent(JsScopeUiEvent start) {
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.START)) {
                throw new UnsupportedOperationException("You can't call this method into the DraggableAjaxBehavior");
            }
            return super.setStartEvent(start);
        }

        public DraggableBehavior setStopEvent(JsScopeUiEvent drop) {
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.STOP)) {
                throw new UnsupportedOperationException("You can't call this method into the DraggableAjaxBehavior");
            }
            return super.setStopEvent(drop);
        }

        public JsStatement statement() {
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.STOP)) {
                DraggableAjaxBehavior.this.draggableBehavior.setInnerStopEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        StringBuffer javascript = new StringBuffer();
                        javascript.append("var isInvalid = $.ui.draggable._dragElementDroppedWasInvalid(this);");
                        if (!DraggableAjaxBehavior.this.enableAjaxOnInvalid) {
                            javascript.append("if(!isInvalid){");
                        }
                        javascript.append(DraggableAjaxBehavior.this.getCallbackStopEventScript(true));
                        if (!DraggableAjaxBehavior.this.enableAjaxOnInvalid) {
                            javascript.append("}");
                        }
                        scopeContext.append(javascript);
                    }
                });
            }
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.START)) {
                DraggableAjaxBehavior.this.draggableBehavior.setInnerStartEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        scopeContext.append(DraggableAjaxBehavior.this.getCallbackScript(true, DraggableEvent.START.toString().toLowerCase()));
                    }
                });
            }
            if (DraggableAjaxBehavior.this.callbacks.contains((Object)DraggableEvent.DRAG)) {
                DraggableAjaxBehavior.this.draggableBehavior.setInnerDragEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        scopeContext.append(DraggableAjaxBehavior.this.getCallbackScript(true, DraggableEvent.DRAG.toString().toLowerCase()));
                    }
                });
            }
            if (DraggableAjaxBehavior.this.enableAjaxOnInvalid) {
                DraggableAjaxBehavior.this.draggableBehavior.getInnerOptions().put("revert", new DraggableRevertScope((CharSequence)"return $.ui.draggable._dragElementWasDropped(this, dropped);"));
            }
            return super.statement();
        }
    }

    private class DraggableRevertScope
    extends JsScope {
        private static final long serialVersionUID = -4247629626060847839L;
        private CharSequence javascript;

        public DraggableRevertScope(CharSequence javascript) {
            super("dropped");
            this.javascript = javascript;
        }

        protected void execute(JsScopeContext scopeContext) {
            scopeContext.append(this.javascript);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DraggableEvent {
        DRAG,
        START,
        STOP;

    }
}

