/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.draggable;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ArrayItemOptions;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.IntegerItemOptions;
import org.odlabs.wiquery.core.options.ListItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.draggable.DraggableContainment;
import org.odlabs.wiquery.ui.draggable.DraggableCursorAt;
import org.odlabs.wiquery.ui.draggable.DraggableHelper;
import org.odlabs.wiquery.ui.draggable.DraggableIframeFix;
import org.odlabs.wiquery.ui.draggable.DraggableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.draggable.DraggableRevert;
import org.odlabs.wiquery.ui.draggable.DraggableSnap;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WiQueryUIPlugin
public class DraggableBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 1L;
    public static final String UI_HELPER = "ui.helper";
    public static final String UI_POSITION = "ui.position";
    public static final String UI_OFFSET = "ui.offset";
    private Options options = new Options();

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    @Override
    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    @Override
    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DraggableJavaScriptResourceReference.get());
    }

    @Override
    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("draggable", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    public DraggableBehavior setAddClasses(boolean addClasses) {
        this.options.put("addClasses", addClasses);
        return this;
    }

    public boolean isAddClasses() {
        if (this.options.containsKey("addClasses")) {
            return this.options.getBoolean("addClasses");
        }
        return true;
    }

    public DraggableBehavior setAppendTo(String appendTo) {
        this.options.putLiteral("appendTo", appendTo);
        return this;
    }

    public String getAppendTo() {
        String appendTo = this.options.getLiteral("appendTo");
        return appendTo == null ? "parent" : appendTo;
    }

    public DraggableBehavior setAxis(AxisEnum axis) {
        this.options.putLiteral("axis", axis.toString().toLowerCase());
        return this;
    }

    public AxisEnum getAxis() {
        String axis = this.options.getLiteral("axis");
        return axis == null ? null : AxisEnum.valueOf(axis.toUpperCase());
    }

    public DraggableBehavior setCancel(String cancel) {
        this.options.putLiteral("cancel", cancel);
        return this;
    }

    public String getCancel() {
        String cancel = this.options.getLiteral("cancel");
        return cancel == null ? "input,option" : cancel;
    }

    public DraggableBehavior setConnectToSortable(String connectToSortable) {
        this.options.putLiteral("connectToSortable", connectToSortable);
        return this;
    }

    public String getConnectToSortable() {
        return this.options.getLiteral("connectToSortable");
    }

    public DraggableBehavior setContainment(DraggableContainment containment) {
        this.options.put("containment", containment);
        return this;
    }

    public DraggableContainment getContainment() {
        IComplexOption containment = this.options.getComplexOption("containment");
        if (containment != null && containment instanceof DraggableContainment) {
            return (DraggableContainment)containment;
        }
        return null;
    }

    public DraggableBehavior setCursor(String cursor) {
        this.options.putLiteral("cursor", cursor);
        return this;
    }

    public String getCursor() {
        String cursor = this.options.getLiteral("cursor");
        return cursor == null ? "auto" : cursor;
    }

    @Deprecated
    public DraggableBehavior setCursorAt(CursorAtEnum cusorAt) {
        this.options.putLiteral("cusorAt", cusorAt.toString().toLowerCase().replace('_', ' '));
        return this;
    }

    public DraggableBehavior setCursorAt(ListItemOptions<DraggableCursorAt> cusorAt) {
        this.options.put("cursorAt", cusorAt);
        return this;
    }

    @Deprecated
    public CursorAtEnum getCursorAt() {
        String cursorAt = this.options.getLiteral("cursorAt");
        return cursorAt == null ? null : CursorAtEnum.valueOf(cursorAt.toUpperCase().replace(' ', '_'));
    }

    public ListItemOptions<DraggableCursorAt> getCursorAtComplex() {
        if (this.options.containsKey("cursorAt")) {
            return (ListItemOptions)this.options.getListItemOptions("cursorAt");
        }
        return null;
    }

    public DraggableBehavior setDelay(int delay) {
        this.options.put("delay", delay);
        return this;
    }

    public int getDelay() {
        if (this.options.containsKey("delay")) {
            return this.options.getInt("delay");
        }
        return 0;
    }

    public DraggableBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public DraggableBehavior setDistance(int distance) {
        this.options.put("distance", distance);
        return this;
    }

    public int getDistance() {
        if (this.options.containsKey("distance")) {
            return this.options.getInt("distance");
        }
        return 1;
    }

    public DraggableBehavior setGrid(int x, int y) {
        ArrayItemOptions<IntegerItemOptions> grids = new ArrayItemOptions<IntegerItemOptions>();
        grids.add(new IntegerItemOptions(x));
        grids.add(new IntegerItemOptions(y));
        this.options.put("grid", grids);
        return this;
    }

    public ICollectionItemOptions getGrid() {
        return this.options.getListItemOptions("grid");
    }

    public DraggableBehavior setHandle(String handle) {
        this.options.putLiteral("handle", handle);
        return this;
    }

    public String getHandle() {
        return this.options.getLiteral("handle");
    }

    public DraggableBehavior setHelper(DraggableHelper helper) {
        this.options.put("helper", helper);
        return this;
    }

    public DraggableHelper getHelper() {
        IComplexOption helper = this.options.getComplexOption("helper");
        if (helper != null && helper instanceof DraggableHelper) {
            return (DraggableHelper)helper;
        }
        return new DraggableHelper(DraggableHelper.HelperEnum.ORIGINAL);
    }

    public DraggableBehavior setIframeFix(DraggableIframeFix iframeFix) {
        this.options.put("iframeFix", iframeFix);
        return this;
    }

    public DraggableIframeFix getIframeFix() {
        IComplexOption iframeFix = this.options.getComplexOption("iframeFix");
        if (iframeFix != null && iframeFix instanceof DraggableIframeFix) {
            return (DraggableIframeFix)iframeFix;
        }
        return new DraggableIframeFix(false);
    }

    public DraggableBehavior setOpacity(float opacity) {
        this.options.put("opacity", opacity);
        return this;
    }

    public float getOpacity() {
        if (this.options.containsKey("opacity")) {
            return this.options.getFloat("opacity").floatValue();
        }
        return 0.0f;
    }

    public DraggableBehavior setRefreshPositions(boolean refreshPositions) {
        this.options.put("refreshPositions", refreshPositions);
        return this;
    }

    public boolean isRefreshPositions() {
        if (this.options.containsKey("refreshPositions")) {
            return this.options.getBoolean("refreshPositions");
        }
        return false;
    }

    public DraggableBehavior setRevert(DraggableRevert revert) {
        this.options.put("revert", revert);
        return this;
    }

    public DraggableRevert getRevert() {
        IComplexOption revert = this.options.getComplexOption("revert");
        if (revert != null && revert instanceof DraggableRevert) {
            return (DraggableRevert)revert;
        }
        return new DraggableRevert(false);
    }

    public DraggableBehavior setRevertDuration(int revertDuration) {
        this.options.put("revertDuration", revertDuration);
        return this;
    }

    public int getRevertDuration() {
        if (this.options.containsKey("revertDuration")) {
            return this.options.getInt("revertDuration");
        }
        return 500;
    }

    public DraggableBehavior setScope(String scope) {
        this.options.putLiteral("scope", scope);
        return this;
    }

    public String getScope() {
        if (this.options.containsKey("scope")) {
            return this.options.getLiteral("scope");
        }
        return "default";
    }

    public DraggableBehavior setScroll(boolean scroll) {
        this.options.put("scroll", scroll);
        return this;
    }

    public boolean isScroll() {
        if (this.options.containsKey("scroll")) {
            return this.options.getBoolean("scroll");
        }
        return true;
    }

    public DraggableBehavior setScrollSensitivity(int scrollSensitivity) {
        this.options.put("scrollSensitivity", scrollSensitivity);
        return this;
    }

    public int getScrollSensitivity() {
        if (this.options.containsKey("scrollSensitivity")) {
            return this.options.getInt("scrollSensitivity");
        }
        return 20;
    }

    public DraggableBehavior setScrollSpeed(int scrollSpeed) {
        this.options.put("scrollSpeed", scrollSpeed);
        return this;
    }

    public int getScrollSpeed() {
        if (this.options.containsKey("scrollSpeed")) {
            return this.options.getInt("scrollSpeed");
        }
        return 20;
    }

    public DraggableBehavior setSnap(DraggableSnap snap) {
        this.options.put("snap", snap);
        return this;
    }

    public DraggableSnap getSnap() {
        IComplexOption snap = this.options.getComplexOption("snap");
        if (snap != null && snap instanceof DraggableSnap) {
            return (DraggableSnap)snap;
        }
        return new DraggableSnap(false);
    }

    public DraggableBehavior setSnapMode(SnapModeEnum snapMode) {
        this.options.putLiteral("snapMode", snapMode.name().toLowerCase());
        return this;
    }

    public SnapModeEnum getSnapMode() {
        String literal = this.options.getLiteral("snapMode");
        return literal == null ? SnapModeEnum.BOTH : SnapModeEnum.valueOf(literal.toUpperCase());
    }

    public DraggableBehavior setSnapTolerance(int snapTolerance) {
        this.options.put("snapTolerance", snapTolerance);
        return this;
    }

    public int getSnapTolerance() {
        if (this.options.containsKey("snapTolerance")) {
            return this.options.getInt("snapTolerance");
        }
        return 20;
    }

    public DraggableBehavior setStack(String stack) {
        this.options.putLiteral("stack", stack);
        return this;
    }

    public String getStack() {
        return this.options.getLiteral("stack");
    }

    @Deprecated
    public String isStack() {
        return this.options.getLiteral("stack");
    }

    public DraggableBehavior setZIndex(int zIndex) {
        this.options.put("zIndex", zIndex);
        return this;
    }

    public int getZIndex() {
        if (this.options.containsKey("zIndex")) {
            return this.options.getInt("zIndex");
        }
        return 0;
    }

    public DraggableBehavior setDragEvent(JsScopeUiEvent drag) {
        this.options.put("drag", drag);
        return this;
    }

    public DraggableBehavior setStartEvent(JsScopeUiEvent start) {
        this.options.put("start", start);
        return this;
    }

    public DraggableBehavior setStopEvent(JsScopeUiEvent stop) {
        this.options.put("stop", stop);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("draggable", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("draggable", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("draggable", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("draggable", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SnapModeEnum {
        BOTH,
        INNER,
        OUTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CursorAtEnum {
        TOP,
        TOP_LEFT,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public String toString() {
            return super.toString().toLowerCase().replace('_', ' ');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisEnum {
        X,
        Y;

    }
}

