/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.droppable;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.droppable.DroppableAccept;
import org.odlabs.wiquery.ui.droppable.DroppableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

public class DroppableBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 2L;
    public static final String UI_DRAGGABLE = "ui.draggable";
    public static final String UI_HELPER = "ui.helper";
    public static final String UI_POSITION = "ui.position";
    public static final String UI_OFFSET = "ui.offset";
    private Options options = new Options();

    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)DroppableJavaScriptResourceReference.get());
    }

    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("droppable", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    public DroppableBehavior setAccept(DroppableAccept accept) {
        this.options.put("accept", accept);
        return this;
    }

    public DroppableAccept getAccept() {
        IComplexOption accept = this.options.getComplexOption("accept");
        if (accept instanceof DroppableAccept) {
            return (DroppableAccept)accept;
        }
        return new DroppableAccept("*");
    }

    public DroppableBehavior setActiveClass(String activeClass) {
        this.options.putLiteral("activeClass", activeClass);
        return this;
    }

    public String getActiveClass() {
        return this.options.getLiteral("activeClass");
    }

    public DroppableBehavior setAddClasses(boolean addClasses) {
        this.options.put("addClasses", addClasses);
        return this;
    }

    public boolean isAddClasses() {
        if (this.options.containsKey("addClasses")) {
            return this.options.getBoolean("addClasses");
        }
        return true;
    }

    public DroppableBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public DroppableBehavior setGreedy(boolean greedy) {
        this.options.put("greedy", greedy);
        return this;
    }

    public boolean isGreedy() {
        if (this.options.containsKey("greedy")) {
            return this.options.getBoolean("greedy");
        }
        return false;
    }

    public DroppableBehavior setHoverClass(String hoverClass) {
        this.options.putLiteral("hoverClass", hoverClass);
        return this;
    }

    public String getHoverClass() {
        return this.options.getLiteral("hoverClass");
    }

    public DroppableBehavior setScope(String scope) {
        this.options.putLiteral("scope", scope);
        return this;
    }

    public String getScope() {
        String scope = this.options.getLiteral("scope");
        return scope == null ? "default" : scope;
    }

    public DroppableBehavior setTolerance(ToleranceEnum tolerance) {
        this.options.putLiteral("tolerance", tolerance.toString().toLowerCase());
        return this;
    }

    public ToleranceEnum getTolerance() {
        String tolerance = this.options.getLiteral("tolerance");
        return tolerance == null ? ToleranceEnum.INTERSECT : ToleranceEnum.valueOf(tolerance.toUpperCase());
    }

    public DroppableBehavior setActivateEvent(JsScopeUiEvent activate) {
        this.options.put("activate", activate);
        return this;
    }

    public DroppableBehavior setDeactivateEvent(JsScopeUiEvent deactivate) {
        this.options.put("deactivate", deactivate);
        return this;
    }

    public DroppableBehavior setDropEvent(JsScopeUiEvent drop) {
        this.options.put("drop", drop);
        return this;
    }

    public DroppableBehavior setOutEvent(JsScopeUiEvent out) {
        this.options.put("out", out);
        return this;
    }

    public DroppableBehavior setOverEvent(JsScopeUiEvent over) {
        this.options.put("over", over);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("droppable", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("droppable", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("droppable", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("droppable", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToleranceEnum {
        FIT,
        INTERSECT,
        POINTER,
        TOUCH;

    }
}

