/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.progressbar;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.options.UiOptionsRenderer;
import org.odlabs.wiquery.ui.progressbar.ProgressBarJavaScriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class ProgressBar
extends WebMarkupContainer
implements IWiQueryPlugin {
    private static final long serialVersionUID = 8268721447610956664L;
    private Options options = new Options((Component)this);

    public ProgressBar(String id) {
        super(id);
        this.options.setRenderer(new UiOptionsRenderer("progressbar", (Component)this));
    }

    protected void detachModel() {
        super.detachModel();
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ProgressBarJavaScriptResourceReference.get());
    }

    public JsStatement statement() {
        JsStatement componentStatement = new JsQuery((Component)this).$().chain("progressbar", new CharSequence[0]);
        JsStatement wholeStatement = new JsStatement();
        wholeStatement.append(componentStatement.render());
        wholeStatement.append(this.options.getJavaScriptOptions());
        return wholeStatement;
    }

    protected Options getOptions() {
        return this.options;
    }

    public JsStatement update() {
        JsStatement wholeStatement = new JsStatement();
        wholeStatement.append(this.options.getJavaScriptOptions());
        return wholeStatement;
    }

    public ProgressBar setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public ProgressBar setValue(int value) {
        this.options.put("value", value);
        return this;
    }

    public int getValue() {
        if (this.options.containsKey("value")) {
            return this.options.getInt("value");
        }
        return 0;
    }

    public ProgressBar setChangeEvent(JsScopeUiEvent change) {
        this.options.put("change", change);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery((Component)this).$().chain("progressbar", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery((Component)this).$().chain("progressbar", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery((Component)this).$().chain("progressbar", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement value() {
        return new JsQuery((Component)this).$().chain("progressbar", "'value'");
    }

    public JsStatement value(int value) {
        return new JsQuery((Component)this).$().chain("progressbar", "'value'", Integer.toString(value));
    }

    public void value(AjaxRequestTarget ajaxRequestTarget, int value) {
        ajaxRequestTarget.appendJavascript(this.value(value).render().toString());
    }

    public JsStatement increment() {
        return this.increment(1);
    }

    public JsStatement increment(int increment) {
        JsStatement statement = new JsStatement();
        statement.append(new JsQuery((Component)this).$().chain("progressbar", "'value'", new JsQuery((Component)this).$().chain("progressbar", "'value'").render(false) + " + " + increment).render());
        return statement;
    }

    public void increment(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.increment().render().toString());
    }

    public void increment(AjaxRequestTarget ajaxRequestTarget, int increment) {
        ajaxRequestTarget.appendJavascript(this.increment(increment).render().toString());
    }

    public JsStatement decrement() {
        return this.decrement(1);
    }

    public JsStatement decrement(int decrement) {
        JsStatement statement = new JsStatement();
        statement.append(new JsQuery((Component)this).$().chain("progressbar", "'value'", new JsQuery((Component)this).$().chain("progressbar", "'value'").render(false) + " - " + decrement).render());
        return statement;
    }

    public void decrement(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.decrement().render().toString());
    }

    public void decrement(AjaxRequestTarget ajaxRequestTarget, int decrement) {
        ajaxRequestTarget.appendJavascript(this.decrement(decrement).render().toString());
    }

    public JsStatement widget() {
        return new JsQuery((Component)this).$().chain("progressbar", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }
}

