/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.resizable;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ArrayItemOptions;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.IntegerItemOptions;
import org.odlabs.wiquery.core.options.LiteralOption;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.resizable.ResizableAlsoResize;
import org.odlabs.wiquery.ui.resizable.ResizableAnimeDuration;
import org.odlabs.wiquery.ui.resizable.ResizableAspectRatio;
import org.odlabs.wiquery.ui.resizable.ResizableContainment;
import org.odlabs.wiquery.ui.resizable.ResizableHandles;
import org.odlabs.wiquery.ui.resizable.ResizableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class ResizableBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 4155106232676863150L;
    public static final String UI_HELPER = "ui.helper";
    public static final String UI_ORIGIGNALPOSITION = "ui.originalPosition";
    public static final String UI_ORIGINALSIZE = "ui.originalSize";
    public static final String UI_POSITION = "ui.position ";
    public static final String UI_SIZE = "ui.size";
    private Options options = new Options();

    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)ResizableJavaScriptResourceReference.get());
    }

    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("resizable", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    @Deprecated
    public ResizableBehavior setAlsoResize(String cssSelector) {
        this.options.putLiteral("alsoResize", cssSelector);
        return this;
    }

    @Deprecated
    public String getAlsoResize() {
        return this.options.getLiteral("alsoResize");
    }

    public ResizableBehavior setAlsoResize(ResizableAlsoResize alsoResize) {
        this.options.put("alsoResize", alsoResize);
        return this;
    }

    public ResizableAlsoResize getAlsoResizeComplex() {
        if (this.options.getComplexOption("alsoResize") instanceof ResizableAlsoResize) {
            return (ResizableAlsoResize)this.options.getComplexOption("alsoResize");
        }
        return null;
    }

    public ResizableBehavior setAnimate(boolean animate) {
        this.options.put("animate", animate);
        return this;
    }

    public boolean isAnimate() {
        if (this.options.containsKey("animate")) {
            return this.options.getBoolean("animate");
        }
        return false;
    }

    public ResizableBehavior setAnimateDuration(ResizableAnimeDuration animeDuration) {
        this.options.put("animateDuration", animeDuration);
        return this;
    }

    public ResizableAnimeDuration getAnimateDuration() {
        IComplexOption animeDuration = this.options.getComplexOption("animateDuration");
        if (animeDuration != null && animeDuration instanceof ResizableAnimeDuration) {
            return (ResizableAnimeDuration)animeDuration;
        }
        return new ResizableAnimeDuration(ResizableAnimeDuration.DurationEnum.SLOW);
    }

    public ResizableBehavior setAnimateEasing(String easing) {
        this.options.putLiteral("animateEasing", easing);
        return this;
    }

    public String getAnimateEasing() {
        String animateEasing = this.options.getLiteral("animateEasing");
        return animateEasing == null ? "swing" : animateEasing;
    }

    public ResizableBehavior setAspectRatio(ResizableAspectRatio aspectRatio) {
        this.options.put("aspectRatio", aspectRatio);
        return this;
    }

    public ResizableAspectRatio getAspectRatio() {
        IComplexOption aspectRatio = this.options.getComplexOption("aspectRatio");
        if (aspectRatio != null && aspectRatio instanceof ResizableAspectRatio) {
            return (ResizableAspectRatio)aspectRatio;
        }
        return null;
    }

    public ResizableBehavior setAutoHide(boolean autoHide) {
        this.options.put("autoHide", autoHide);
        return this;
    }

    public boolean isAutoHide() {
        if (this.options.containsKey("autoHide")) {
            return this.options.getBoolean("autoHide");
        }
        return false;
    }

    public ResizableBehavior setCancel(String cancel) {
        this.options.putLiteral("cancel", cancel);
        return this;
    }

    public String getCancel() {
        String cancel = this.options.getLiteral("cancel");
        return cancel == null ? "input,option" : cancel;
    }

    public ResizableBehavior setContainment(ResizableContainment containment) {
        this.options.put("containment", containment);
        return this;
    }

    public ResizableContainment getContainment() {
        IComplexOption containment = this.options.getComplexOption("containment");
        if (containment != null && containment instanceof ResizableContainment) {
            return (ResizableContainment)containment;
        }
        return null;
    }

    public ResizableBehavior setDelay(int delay) {
        this.options.put("delay", delay);
        return this;
    }

    public int getDelay() {
        if (this.options.containsKey("delay")) {
            return this.options.getInt("delay");
        }
        return 0;
    }

    public ResizableBehavior setDistance(int distance) {
        this.options.put("distance", distance);
        return this;
    }

    public int getDistance() {
        if (this.options.containsKey("distance")) {
            return this.options.getInt("distance");
        }
        return 1;
    }

    public ResizableBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public ResizableBehavior setGhost(boolean ghost) {
        this.options.put("ghost", ghost);
        return this;
    }

    public boolean isGhost() {
        if (this.options.containsKey("ghost")) {
            return this.options.getBoolean("ghost");
        }
        return false;
    }

    public ResizableBehavior setGrid(int x, int y) {
        ArrayItemOptions<IntegerItemOptions> grids = new ArrayItemOptions<IntegerItemOptions>();
        grids.add(new IntegerItemOptions(x));
        grids.add(new IntegerItemOptions(y));
        this.options.put("grid", grids);
        return this;
    }

    public ICollectionItemOptions getGrid() {
        return this.options.getListItemOptions("grid");
    }

    public ResizableBehavior setHandles(ResizableHandles handles) {
        this.options.put("handles", handles);
        return this;
    }

    public ResizableHandles getHandles() {
        IComplexOption handles = this.options.getComplexOption("handles");
        if (handles != null && handles instanceof ResizableHandles) {
            return (ResizableHandles)handles;
        }
        return new ResizableHandles(new LiteralOption("e,s,se"));
    }

    public ResizableBehavior setHelper(String helper) {
        this.options.putLiteral("helper", helper);
        return this;
    }

    public String getHelper() {
        return this.options.getLiteral("helper");
    }

    public ResizableBehavior setMaxHeight(int maxHeight) {
        this.options.put("maxHeight", maxHeight);
        return this;
    }

    public int getMaxHeight() {
        if (this.options.containsKey("maxHeight")) {
            return this.options.getInt("maxHeight");
        }
        return 0;
    }

    public ResizableBehavior setMaxWidth(int maxWidth) {
        this.options.put("maxWidth", maxWidth);
        return this;
    }

    public int getMaxWidth() {
        if (this.options.containsKey("maxWidth")) {
            return this.options.getInt("maxWidth");
        }
        return 0;
    }

    public ResizableBehavior setMinHeight(int minHeight) {
        this.options.put("minHeight", minHeight);
        return this;
    }

    public int getMinHeight() {
        if (this.options.containsKey("minHeight")) {
            return this.options.getInt("minHeight");
        }
        return 10;
    }

    public ResizableBehavior setMinWidth(int minWidth) {
        this.options.put("minWidth", minWidth);
        return this;
    }

    public int getMinWidth() {
        if (this.options.containsKey("minWidth")) {
            return this.options.getInt("minWidth");
        }
        return 10;
    }

    public ResizableBehavior setResizeEvent(JsScopeUiEvent resize) {
        this.options.put("resize", resize);
        return this;
    }

    public ResizableBehavior setStartEvent(JsScopeUiEvent start) {
        this.options.put("start", start);
        return this;
    }

    public ResizableBehavior setStopEvent(JsScopeUiEvent stop) {
        this.options.put("stop", stop);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("resizable", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("resizable", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("resizable", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("resizable", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }
}

