/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.selectable;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.selectable.SelectableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class SelectableBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 2L;
    private Options options = new Options();

    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)SelectableJavaScriptResourceReference.get());
    }

    public String getCancel() {
        String cancel = this.options.getLiteral("cancel");
        return cancel == null ? "input,option" : cancel;
    }

    public int getDelay() {
        if (this.options.containsKey("delay")) {
            return this.options.getInt("delay");
        }
        return 0;
    }

    public int getDistance() {
        if (this.options.containsKey("distance")) {
            return this.options.getInt("distance");
        }
        return 0;
    }

    public String getFilter() {
        String filter = this.options.getLiteral("filter");
        return filter == null ? "*" : filter;
    }

    protected Options getOptions() {
        return this.options;
    }

    public ToleranceEnum getTolerance() {
        String tolerance = this.options.getLiteral("tolerance");
        return tolerance == null ? ToleranceEnum.TOUCH : ToleranceEnum.valueOf(tolerance.toUpperCase());
    }

    public boolean isAutoRefresh() {
        if (this.options.containsKey("autoRefresh")) {
            return this.options.getBoolean("autoRefresh");
        }
        return true;
    }

    public SelectableBehavior setAutoRefresh(boolean autoRefresh) {
        this.options.put("autoRefresh", autoRefresh);
        return this;
    }

    public SelectableBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public SelectableBehavior setCancel(String cancel) {
        this.options.putLiteral("cancel", cancel);
        return this;
    }

    public SelectableBehavior setDelay(int delay) {
        this.options.put("delay", delay);
        return this;
    }

    public SelectableBehavior setDistance(int distance) {
        this.options.put("distance", distance);
        return this;
    }

    public SelectableBehavior setFilter(String filter) {
        this.options.putLiteral("filter", filter);
        return this;
    }

    public SelectableBehavior setTolerance(ToleranceEnum tolerance) {
        this.options.putLiteral("tolerance", tolerance.toString().toLowerCase());
        return this;
    }

    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("selectable", this.options.getJavaScriptOptions());
    }

    public SelectableBehavior setSelectedEvent(JsScopeUiEvent selected) {
        this.options.put("selected", selected);
        return this;
    }

    public SelectableBehavior setSelectingEvent(JsScopeUiEvent selecting) {
        this.options.put("selecting", selecting);
        return this;
    }

    public SelectableBehavior setStartEvent(JsScopeUiEvent start) {
        this.options.put("start", start);
        return this;
    }

    public SelectableBehavior setStopEvent(JsScopeUiEvent stop) {
        this.options.put("stop", stop);
        return this;
    }

    public SelectableBehavior setUnselectedEvent(JsScopeUiEvent unselected) {
        this.options.put("unselected", unselected);
        return this;
    }

    public SelectableBehavior setUnselectingEvent(JsScopeUiEvent unselecting) {
        this.options.put("unselecting", unselecting);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("selectable", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("selectable", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("selectable", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement refresh() {
        return new JsQuery(this.getComponent()).$().chain("selectable", "'refresh'");
    }

    public void refresh(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.refresh().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("selectable", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToleranceEnum {
        TOUCH,
        FIT;

    }
}

