/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.slider;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.odlabs.wiquery.core.javascript.JsScopeContext;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.slider.Slider;

public class AjaxSlider
extends Slider {
    private static final long serialVersionUID = 1L;
    private SliderAjaxBehaivior sliderContext;
    public static final String SLIDER_EVENT = "sliderEvent";
    public static final String SLIDER_VALUE = "sliderValue";
    public static final String SLIDER_VALUES = "sliderValues";
    private Map<SliderAjaxEvent, ISliderAjaxEvent> ajaxEvents = new HashMap<SliderAjaxEvent, ISliderAjaxEvent>();

    public AjaxSlider(String id, Number min, Number max) {
        super(id, min, max);
        this.sliderContext = new SliderAjaxBehaivior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                String sliderEvent = WebRequestCycle.get().getRequest().getParameter(AjaxSlider.SLIDER_EVENT);
                if (!AjaxSlider.isEmpty(sliderEvent)) {
                    int value = AjaxSlider.this.parseInteger(WebRequestCycle.get().getRequest().getParameter(AjaxSlider.SLIDER_VALUE), AjaxSlider.this.getMin().intValue());
                    int[] values = AjaxSlider.this.processValues(WebRequestCycle.get().getRequest().getParameter(AjaxSlider.SLIDER_VALUES));
                    ISliderAjaxEvent ajaxEvent = (ISliderAjaxEvent)AjaxSlider.this.ajaxEvents.get((Object)SliderAjaxEvent.valueOf(sliderEvent));
                    if (ajaxEvent != null) {
                        ajaxEvent.onEvent(target, AjaxSlider.this, value, values);
                    }
                }
            }
        };
        this.add(new IBehavior[]{this.sliderContext});
    }

    protected int[] processValues(String svalues) {
        if (AjaxSlider.isEmpty(svalues) || svalues.indexOf(44) < 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(svalues, ",");
        int size = st.countTokens();
        int[] values = new int[size];
        int i = 0;
        while (st.hasMoreTokens()) {
            values[i] = this.parseInteger(st.nextToken(), 0);
            ++i;
        }
        return values;
    }

    public Number getMin() {
        if (this.getOptions().containsKey("min")) {
            return this.getOptions().getFloat("min");
        }
        return 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private int parseInteger(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setAjaxStopEvent(ISliderAjaxEvent ajaxStopEvent) {
        this.ajaxEvents.put(SliderAjaxEvent.ajaxStopEvent, ajaxStopEvent);
        this.setStopEvent(new SliderAjaxJsScopeUiEvent(this, SliderAjaxEvent.ajaxStopEvent));
    }

    public void setAjaxSlideEvent(ISliderAjaxEvent ajaxSlideEvent) {
        this.ajaxEvents.put(SliderAjaxEvent.ajaxSlideEvent, ajaxSlideEvent);
        this.setSlideEvent(new SliderAjaxJsScopeUiEvent(this, SliderAjaxEvent.ajaxSlideEvent));
    }

    public void setAjaxStartEvent(ISliderAjaxEvent ajaxStartEvent) {
        this.ajaxEvents.put(SliderAjaxEvent.ajaxStartEvent, ajaxStartEvent);
        this.setSlideEvent(new SliderAjaxJsScopeUiEvent(this, SliderAjaxEvent.ajaxStartEvent));
    }

    public void setAjaxChangeEvent(ISliderAjaxEvent ajaxChangeEvent) {
        this.ajaxEvents.put(SliderAjaxEvent.ajaxChangeEvent, ajaxChangeEvent);
        this.setChangeEvent(new SliderAjaxJsScopeUiEvent(this, SliderAjaxEvent.ajaxChangeEvent));
    }

    private static class SliderAjaxJsScopeUiEvent
    extends JsScopeUiEvent {
        private static final long serialVersionUID = 1L;
        private SliderAjaxEvent event;
        private AjaxSlider slider;

        public SliderAjaxJsScopeUiEvent(AjaxSlider slider, SliderAjaxEvent event) {
            this.slider = slider;
            this.event = event;
        }

        protected void execute(JsScopeContext scopeContext) {
            scopeContext.append(new StringBuffer().append("var values = $(this).slider('values');").append("var url = '").append(this.slider.sliderContext.getCallbackUrl(true)).append("&").append(AjaxSlider.SLIDER_EVENT).append("=").append(this.event.name()).append("&").append(AjaxSlider.SLIDER_VALUE).append("=").append("'+").append("ui.value").append("+'&").append(AjaxSlider.SLIDER_VALUES).append("=").append("'+").append("values").append(";").append(this.slider.sliderContext.generateCallbackScript("wicketAjaxGet(url")).toString());
        }
    }

    public static interface ISliderAjaxEvent
    extends Serializable {
        public void onEvent(AjaxRequestTarget var1, AjaxSlider var2, int var3, int[] var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SliderAjaxEvent {
        ajaxStopEvent,
        ajaxStartEvent,
        ajaxSlideEvent,
        ajaxChangeEvent;

    }

    private static abstract class SliderAjaxBehaivior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public CharSequence generateCallbackScript(CharSequence partialCall) {
            return super.generateCallbackScript(partialCall);
        }
    }
}

