/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.slider;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ArrayItemOptions;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.IntegerItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.slider.SliderAnimate;
import org.odlabs.wiquery.ui.slider.SliderJavaScriptResourceReference;
import org.odlabs.wiquery.ui.slider.SliderRange;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WiQueryUIPlugin
public class Slider
extends WebMarkupContainer
implements IWiQueryPlugin {
    private static final long serialVersionUID = 3738656024036987662L;
    public static final String UI_HANDLE = "ui.handle";
    public static final String UI_VALUE = "ui.value";
    private Options options = new Options((Component)this);

    public Slider(String id, Number min, Number max) {
        super(id);
        this.setMin(min);
        this.setMax(max);
    }

    protected void detachModel() {
        super.detachModel();
        this.options.detach();
    }

    @Override
    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)SliderJavaScriptResourceReference.get());
    }

    @Override
    public JsStatement statement() {
        return new JsQuery((Component)this).$().chain("slider", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    public Slider setAnimate(boolean animate) {
        this.options.put("animate", new SliderAnimate(animate));
        return this;
    }

    public Slider setAnimate(SliderAnimate.AnimateEnum animate) {
        if (animate.equals((Object)SliderAnimate.AnimateEnum.FAST)) {
            this.options.put("animate", SliderAnimate.FAST);
        } else if (animate.equals((Object)SliderAnimate.AnimateEnum.NORMAL)) {
            this.options.put("animate", SliderAnimate.NORMAL);
        } else if (animate.equals((Object)SliderAnimate.AnimateEnum.SLOW)) {
            this.options.put("animate", SliderAnimate.SLOW);
        } else {
            this.unsetAnimate();
        }
        return this;
    }

    public Slider setAnimate(Number number) {
        if (number != null && number.doubleValue() > 0.0) {
            this.options.put("animate", new SliderAnimate(number));
        }
        return this;
    }

    public Slider unsetAnimate() {
        this.options.removeOption("animate");
        return this;
    }

    public SliderAnimate getAnimate() {
        if (this.options.getComplexOption("animate") instanceof SliderAnimate) {
            return (SliderAnimate)this.options.getComplexOption("animate");
        }
        return null;
    }

    public boolean isAnimate() {
        return this.options.getComplexOption("animate") instanceof SliderAnimate;
    }

    public Slider setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public Slider setMax(Number max) {
        this.options.put("max", max.floatValue());
        return this;
    }

    public Number getMax() {
        if (this.options.containsKey("max")) {
            return this.options.getFloat("max");
        }
        return 100;
    }

    public Slider setMin(Number min) {
        this.options.put("min", min.floatValue());
        return this;
    }

    public Number getMin() {
        if (this.options.containsKey("min")) {
            return this.options.getFloat("min");
        }
        return 0;
    }

    public Slider setOrientation(Orientation orientation) {
        this.options.putLiteral("orientation", orientation.toString().toLowerCase());
        return this;
    }

    public Orientation getOrientation() {
        String orientation = this.options.getLiteral("orientation");
        return orientation == null ? Orientation.HORIZONTAL : Orientation.valueOf(orientation.toUpperCase());
    }

    public Slider setRange(SliderRange range) {
        this.options.put("range", range);
        return this;
    }

    public SliderRange getRange() {
        IComplexOption range = this.options.getComplexOption("range");
        if (range != null && range instanceof SliderRange) {
            return (SliderRange)range;
        }
        return new SliderRange(false);
    }

    public Slider setStep(int step) {
        this.options.put("step", step);
        return this;
    }

    public int getStep() {
        if (this.options.containsKey("step")) {
            return this.options.getInt("step");
        }
        return 1;
    }

    public Slider setValue(int value) {
        this.options.put("value", value);
        return this;
    }

    public int getValue() {
        if (this.options.containsKey("value")) {
            return this.options.getInt("value");
        }
        return 0;
    }

    public Slider setValues(ArrayItemOptions<IntegerItemOptions> values) {
        this.options.put("values", values);
        return this;
    }

    public ICollectionItemOptions getValues() {
        return this.options.getListItemOptions("values");
    }

    public Slider setChangeEvent(JsScopeUiEvent change) {
        this.options.put("change", change);
        return this;
    }

    public Slider setStartEvent(JsScopeUiEvent start) {
        this.options.put("start", start);
        return this;
    }

    public Slider setSlideEvent(JsScopeUiEvent slide) {
        this.options.put("slide", slide);
        return this;
    }

    public Slider setStopEvent(JsScopeUiEvent stop) {
        this.options.put("stop", stop);
        return this;
    }

    public JsStatement destroy() {
        return new JsQuery((Component)this).$().chain("slider", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery((Component)this).$().chain("slider", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery((Component)this).$().chain("slider", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement value(int value) {
        return new JsQuery((Component)this).$().chain("slider", "'value'", Integer.toString(value));
    }

    public void value(AjaxRequestTarget ajaxRequestTarget, int value) {
        ajaxRequestTarget.appendJavascript(this.value(value).render().toString());
    }

    public JsStatement values() {
        return new JsQuery((Component)this).$().chain("slider", "'values'");
    }

    public void values(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.values().render().toString());
    }

    public JsStatement values(int index, int value) {
        return new JsQuery((Component)this).$().chain("slider", "'values'", Integer.toString(index), Integer.toString(value));
    }

    public void values(AjaxRequestTarget ajaxRequestTarget, int index, int value) {
        ajaxRequestTarget.appendJavascript(this.values(index, value).render().toString());
    }

    public JsStatement widget() {
        return new JsQuery((Component)this).$().chain("slider", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

