/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.sortable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsScopeContext;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.core.util.MarkupIdVisitor;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.sortable.SortableBehavior;
import org.odlabs.wiquery.ui.sortable.SortableContainment;
import org.odlabs.wiquery.ui.sortable.SortableHelper;
import org.odlabs.wiquery.ui.sortable.SortableRevert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SortableAjaxBehavior<E extends Component>
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String SORTED_ID = "sortedId";
    private static final String SORTED_INDEX = "sortedIndex";
    private static final String SORTED_PARENT_ID = "sortedParentId";
    private static final String SORTED_TYPE = "sortedType";
    private InnerSortableBehavior sortableBehavior = new InnerSortableBehavior();
    private Set<SortedEvent> callbacks;

    protected CharSequence getCallbackScriptReceive(boolean onlyTargetActivePage) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&" + SORTED_TYPE + "=" + SortedEvent.RECEIVE.toString().toLowerCase() + "&" + SORTED_INDEX + "='+$(this).find(':data(sortable-item)').index(" + "ui.item" + ")+'" + "&" + SORTED_ID + "='+ $(" + "ui.item" + ").attr('id')" + "+'&" + SORTED_PARENT_ID + "='+ $(" + "ui.sender" + ").attr('id')");
    }

    protected CharSequence getCallbackScriptRemove(boolean onlyTargetActivePage) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&" + SORTED_TYPE + "=" + SortedEvent.REMOVE.toString().toLowerCase() + "&" + SORTED_ID + "='+ $(" + "ui.item" + ").attr('id')");
    }

    protected CharSequence getCallbackScriptUpdate(boolean onlyTargetActivePage) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "&" + SORTED_TYPE + "=" + SortedEvent.UPDATE.toString().toLowerCase() + "&" + SORTED_INDEX + "='+$(this).find(':data(sortable-item)').index(" + "ui.item" + ")+'" + "&" + SORTED_ID + "='+ $(" + "ui.item" + ").attr('id')");
    }

    public SortableAjaxBehavior() {
        this(SortedEvent.values());
    }

    public SortableAjaxBehavior(SortedEvent ... callbacks) {
        this.callbacks = new HashSet<SortedEvent>(Arrays.asList(callbacks));
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
    }

    public SortableBehavior getSortableBehavior() {
        return this.sortableBehavior;
    }

    protected void onBind() {
        this.getComponent().add(new IBehavior[]{this.sortableBehavior});
    }

    public abstract void onReceive(E var1, int var2, Component var3, AjaxRequestTarget var4);

    public abstract void onRemove(E var1, AjaxRequestTarget var2);

    public final void onSort(AjaxRequestTarget target) {
        String input = this.getComponent().getRequest().getParameter(SORTED_ID);
        String indexStr = this.getComponent().getRequest().getParameter(SORTED_INDEX);
        int index = indexStr == null ? -1 : Integer.valueOf(indexStr);
        SortedEvent sortedEvent = SortedEvent.valueOf(this.getComponent().getRequest().getParameter(SORTED_TYPE).toUpperCase());
        MarkupIdVisitor visitor = new MarkupIdVisitor(input);
        this.getComponent().getPage().visitChildren((Component.IVisitor)visitor);
        Component sortedComponent = visitor.getFoundComponent();
        switch (sortedEvent) {
            case RECEIVE: {
                String parent = this.getComponent().getRequest().getParameter(SORTED_PARENT_ID);
                MarkupIdVisitor visitorParent = new MarkupIdVisitor(parent);
                this.getComponent().getPage().visitChildren((Component.IVisitor)visitorParent);
                this.onReceive(sortedComponent, index, visitorParent.getFoundComponent(), target);
                break;
            }
            case REMOVE: {
                this.onRemove(sortedComponent, target);
                break;
            }
            case UPDATE: {
                this.onUpdate(sortedComponent, index, target);
            }
        }
    }

    public abstract void onUpdate(E var1, int var2, AjaxRequestTarget var3);

    protected void respond(AjaxRequestTarget target) {
        this.onSort(target);
    }

    protected JsStatement statement() {
        return this.sortableBehavior.statement();
    }

    public String getAppendTo() {
        return this.sortableBehavior.getAppendTo();
    }

    public SortableBehavior.AxisEnum getAxis() {
        return this.sortableBehavior.getAxis();
    }

    public String getCancel() {
        return this.sortableBehavior.getCancel();
    }

    public String getConnectWith() {
        return this.sortableBehavior.getConnectWith();
    }

    public SortableContainment getContainmentComplex() {
        return this.sortableBehavior.getContainmentComplex();
    }

    public String getCursor() {
        return this.sortableBehavior.getCursor();
    }

    public SortableBehavior.CursorAtEnum getCursorAt() {
        return this.sortableBehavior.getCursorAt();
    }

    public int getDelay() {
        return this.sortableBehavior.getDelay();
    }

    public int getDistance() {
        return this.sortableBehavior.getDistance();
    }

    public ICollectionItemOptions getGrid() {
        return this.sortableBehavior.getGrid();
    }

    public String getHandle() {
        return this.sortableBehavior.getHandle();
    }

    public SortableHelper getHelperComplex() {
        return this.sortableBehavior.getHelperComplex();
    }

    public String getItems() {
        return this.sortableBehavior.getItems();
    }

    public float getOpacity() {
        return this.sortableBehavior.getOpacity();
    }

    public String getPlaceHolder() {
        return this.sortableBehavior.getPlaceHolder();
    }

    public SortableRevert getRevert() {
        return this.sortableBehavior.getRevert();
    }

    public int getScrollSensitivity() {
        return this.sortableBehavior.getScrollSensitivity();
    }

    public int getScrollSpeed() {
        return this.sortableBehavior.getScrollSpeed();
    }

    public SortableBehavior.ToleranceEnum getTolerance() {
        return this.sortableBehavior.getTolerance();
    }

    public int getZIndex() {
        return this.sortableBehavior.getZIndex();
    }

    public SortableAjaxBehavior<E> setDisabled(boolean disabled) {
        this.sortableBehavior.setDisabled(disabled);
        return this;
    }

    public boolean isDisabled() {
        return this.sortableBehavior.isDisabled();
    }

    public boolean isDropOnEmpty() {
        return this.sortableBehavior.isDropOnEmpty();
    }

    public boolean isForceHelperSize() {
        return this.sortableBehavior.isForceHelperSize();
    }

    public boolean isForcePlaceholderSize() {
        return this.sortableBehavior.isForcePlaceholderSize();
    }

    public boolean isScroll() {
        return this.sortableBehavior.isScroll();
    }

    public SortableAjaxBehavior<E> setAppendTo(String appendTo) {
        this.sortableBehavior.setAppendTo(appendTo);
        return this;
    }

    public SortableAjaxBehavior<E> setAxis(SortableBehavior.AxisEnum axis) {
        this.sortableBehavior.setAxis(axis);
        return this;
    }

    public SortableAjaxBehavior<E> setCancel(String cancel) {
        this.sortableBehavior.setCancel(cancel);
        return this;
    }

    public SortableAjaxBehavior<E> setConnectWith(String connectWith) {
        this.sortableBehavior.setConnectWith(connectWith);
        return this;
    }

    public SortableAjaxBehavior<E> setContainment(SortableContainment containment) {
        this.sortableBehavior.setContainment(containment);
        return this;
    }

    public SortableAjaxBehavior<E> setCursor(String cursor) {
        this.sortableBehavior.setCursor(cursor);
        return this;
    }

    public SortableAjaxBehavior<E> setCursorAt(SortableBehavior.CursorAtEnum cusorAt) {
        this.sortableBehavior.setCursorAt(cusorAt);
        return this;
    }

    public SortableAjaxBehavior<E> setDelay(int delay) {
        this.sortableBehavior.setDelay(delay);
        return this;
    }

    public SortableAjaxBehavior<E> setDistance(int distance) {
        this.sortableBehavior.setDistance(distance);
        return this;
    }

    public SortableAjaxBehavior<E> setDropOnEmpty(boolean dropOnEmpty) {
        this.sortableBehavior.setDropOnEmpty(dropOnEmpty);
        return this;
    }

    public SortableAjaxBehavior<E> setForceHelperSize(boolean forceHelperSize) {
        this.sortableBehavior.setForceHelperSize(forceHelperSize);
        return this;
    }

    public SortableAjaxBehavior<E> setForcePlaceholderSize(boolean forcePlaceholderSize) {
        this.sortableBehavior.setForcePlaceholderSize(forcePlaceholderSize);
        return this;
    }

    public SortableAjaxBehavior<E> setGrid(int x, int y) {
        this.sortableBehavior.setGrid(x, y);
        return this;
    }

    public SortableAjaxBehavior<E> setHandle(String handle) {
        this.sortableBehavior.setHandle(handle);
        return this;
    }

    public SortableAjaxBehavior<E> setHelper(SortableHelper helper) {
        this.sortableBehavior.setHelper(helper);
        return this;
    }

    public SortableAjaxBehavior<E> setItems(String items) {
        this.sortableBehavior.setItems(items);
        return this;
    }

    public SortableAjaxBehavior<E> setOpacity(float opacity) {
        this.sortableBehavior.setOpacity(opacity);
        return this;
    }

    public SortableAjaxBehavior<E> setPlaceholder(String placeholder) {
        this.sortableBehavior.setPlaceholder(placeholder);
        return this;
    }

    public SortableAjaxBehavior<E> setRevert(SortableRevert revert) {
        this.sortableBehavior.setRevert(revert);
        return this;
    }

    public SortableAjaxBehavior<E> setScroll(boolean scroll) {
        this.sortableBehavior.setScroll(scroll);
        return this;
    }

    public SortableAjaxBehavior<E> setScrollSensitivity(int scrollSensitivity) {
        this.sortableBehavior.setScrollSensitivity(scrollSensitivity);
        return this;
    }

    public SortableAjaxBehavior<E> setScrollSpeed(int scrollSpeed) {
        this.sortableBehavior.setScrollSpeed(scrollSpeed);
        return this;
    }

    public SortableAjaxBehavior<E> setTolerance(SortableBehavior.ToleranceEnum tolerance) {
        this.sortableBehavior.setTolerance(tolerance);
        return this;
    }

    public SortableAjaxBehavior<E> setZIndex(int zIndex) {
        this.sortableBehavior.setZIndex(zIndex);
        return this;
    }

    public JsStatement cancel() {
        return this.sortableBehavior.cancel();
    }

    public void cancel(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.cancel(ajaxRequestTarget);
    }

    public JsStatement destroy() {
        return this.sortableBehavior.destroy();
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.destroy(ajaxRequestTarget);
    }

    public JsStatement disable() {
        return this.sortableBehavior.disable();
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.disable(ajaxRequestTarget);
    }

    public JsStatement enable() {
        return this.sortableBehavior.enable();
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.enable(ajaxRequestTarget);
    }

    public JsStatement refresh() {
        return this.sortableBehavior.refresh();
    }

    public void refresh(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.refresh(ajaxRequestTarget);
    }

    public JsStatement refreshPositions() {
        return this.sortableBehavior.refreshPositions();
    }

    public void refreshPositions(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.refreshPositions();
    }

    public JsStatement serialize() {
        return this.sortableBehavior.serialize();
    }

    public void serialize(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.serialize(ajaxRequestTarget);
    }

    public JsStatement toArray() {
        return this.sortableBehavior.toArray();
    }

    public JsStatement widget() {
        return this.sortableBehavior.widget();
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        this.sortableBehavior.widget(ajaxRequestTarget);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortedEvent {
        RECEIVE,
        REMOVE,
        UPDATE;

    }

    private class InnerSortableBehavior
    extends SortableBehavior {
        private static final long serialVersionUID = 5587258236214715234L;

        private InnerSortableBehavior() {
        }

        public void contribute(WiQueryResourceManager wiQueryResourceManager) {
            super.contribute(wiQueryResourceManager);
            SortableAjaxBehavior.this.contribute(wiQueryResourceManager);
        }

        protected Options getOptions() {
            throw new UnsupportedOperationException("You can't call this method into the DroppableAjaxBehavior");
        }

        private void setInnerReceiveEvent(JsScopeUiEvent receive) {
            super.setReceiveEvent(receive);
        }

        private void setInnerRemoveEvent(JsScopeUiEvent remove) {
            super.setRemoveEvent(remove);
        }

        private void setInnerUpdateEvent(JsScopeUiEvent update) {
            super.setUpdateEvent(update);
        }

        public SortableBehavior setReceiveEvent(JsScopeUiEvent receive) {
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.RECEIVE)) {
                throw new UnsupportedOperationException("You can't call this method into the SortableAjaxBehavior");
            }
            return super.setReceiveEvent(receive);
        }

        public SortableBehavior setRemoveEvent(JsScopeUiEvent remove) {
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.REMOVE)) {
                throw new UnsupportedOperationException("You can't call this method into the SortableAjaxBehavior");
            }
            return super.setRemoveEvent(remove);
        }

        public SortableBehavior setUpdateEvent(JsScopeUiEvent update) {
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.UPDATE)) {
                throw new UnsupportedOperationException("You can't call this method into the SortableAjaxBehavior");
            }
            return super.setUpdateEvent(update);
        }

        public JsStatement statement() {
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.RECEIVE)) {
                SortableAjaxBehavior.this.sortableBehavior.setInnerReceiveEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        scopeContext.append(SortableAjaxBehavior.this.getCallbackScriptReceive(true));
                    }
                });
            }
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.REMOVE)) {
                SortableAjaxBehavior.this.sortableBehavior.setInnerRemoveEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        scopeContext.append(SortableAjaxBehavior.this.getCallbackScriptRemove(true));
                    }
                });
            }
            if (SortableAjaxBehavior.this.callbacks.contains((Object)SortedEvent.UPDATE)) {
                SortableAjaxBehavior.this.sortableBehavior.setInnerUpdateEvent(new JsScopeUiEvent(){
                    private static final long serialVersionUID = 1L;

                    protected void execute(JsScopeContext scopeContext) {
                        scopeContext.append(SortableAjaxBehavior.this.getCallbackScriptUpdate(true));
                    }
                });
            }
            return super.statement();
        }
    }
}

