/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.sortable;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.odlabs.wiquery.core.behavior.WiQueryAbstractBehavior;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.ArrayItemOptions;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.IntegerItemOptions;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.mouse.MouseJavascriptResourceReference;
import org.odlabs.wiquery.ui.sortable.SortableContainment;
import org.odlabs.wiquery.ui.sortable.SortableHelper;
import org.odlabs.wiquery.ui.sortable.SortableJavaScriptResourceReference;
import org.odlabs.wiquery.ui.sortable.SortableRevert;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class SortableBehavior
extends WiQueryAbstractBehavior {
    private static final long serialVersionUID = 2L;
    public static final String UI_HELPER = "ui.helper";
    public static final String UI_POSITION = "ui.position";
    public static final String UI_OFFSET = "ui.offset";
    public static final String UI_ITEM = "ui.item";
    public static final String UI_PLACEHOLDER = "ui.placeholder";
    public static final String UI_SENDER = "ui.sender";
    private Options options = new Options();

    public void bind(Component component) {
        this.options.setOwner(component);
        super.bind(component);
    }

    public void detach(Component component) {
        super.detach(component);
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)MouseJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)SortableJavaScriptResourceReference.get());
    }

    public JsStatement statement() {
        return new JsQuery(this.getComponent()).$().chain("sortable", this.options.getJavaScriptOptions());
    }

    public String getAppendTo() {
        String appendTo = this.options.getLiteral("appendTo");
        return appendTo == null ? "parent" : appendTo;
    }

    public AxisEnum getAxis() {
        String axis = this.options.getLiteral("axis");
        return axis == null ? null : AxisEnum.valueOf(axis.toUpperCase());
    }

    public String getCancel() {
        String cancel = this.options.getLiteral("cancel");
        return cancel == null ? "input,button" : cancel;
    }

    public String getConnectWith() {
        return this.options.getLiteral("connectWith");
    }

    @Deprecated
    public String getContainment() {
        return this.options.getLiteral("containment");
    }

    public SortableContainment getContainmentComplex() {
        if (this.options.getComplexOption("containment") instanceof SortableContainment) {
            return (SortableContainment)this.options.getComplexOption("containment");
        }
        return null;
    }

    public String getCursor() {
        String cursor = this.options.getLiteral("cursor");
        return cursor == null ? "auto" : cursor;
    }

    public CursorAtEnum getCursorAt() {
        String cursorAt = this.options.getLiteral("cursorAt");
        return cursorAt == null ? null : CursorAtEnum.valueOf(cursorAt.toUpperCase().replace(' ', '_'));
    }

    public int getDelay() {
        if (this.options.containsKey("delay")) {
            return this.options.getInt("delay");
        }
        return 0;
    }

    public int getDistance() {
        if (this.options.containsKey("distance")) {
            return this.options.getInt("distance");
        }
        return 1;
    }

    @Deprecated
    public boolean getDropOnEmpty() {
        return this.isDropOnEmpty();
    }

    @Deprecated
    public boolean getForceHelperSize() {
        return this.isForceHelperSize();
    }

    @Deprecated
    public boolean getForcePlaceholderSize() {
        return this.isForcePlaceholderSize();
    }

    public ICollectionItemOptions getGrid() {
        return this.options.getListItemOptions("grid");
    }

    public String getHandle() {
        return this.options.getLiteral("handle");
    }

    @Deprecated
    public String getHelper() {
        return this.options.getLiteral("helper");
    }

    public SortableHelper getHelperComplex() {
        if (this.options.getComplexOption("helper") instanceof SortableHelper) {
            return (SortableHelper)this.options.getComplexOption("helper");
        }
        return new SortableHelper(SortableHelper.HelperEnum.ORIGINAL);
    }

    public String getItems() {
        String items = this.options.getLiteral("items");
        return items == null ? "> *" : items;
    }

    public float getOpacity() {
        if (this.options.containsKey("opacity")) {
            return this.options.getFloat("opacity").floatValue();
        }
        return 0.0f;
    }

    protected Options getOptions() {
        return this.options;
    }

    public String getPlaceHolder() {
        return this.options.getLiteral("placeholder");
    }

    public SortableRevert getRevert() {
        if (this.options.getComplexOption("revert") instanceof SortableRevert) {
            return (SortableRevert)this.options.getComplexOption("revert");
        }
        return new SortableRevert(false);
    }

    public int getScrollSensitivity() {
        if (this.options.containsKey("scrollSensitivity")) {
            return this.options.getInt("scrollSensitivity");
        }
        return 20;
    }

    public int getScrollSpeed() {
        if (this.options.containsKey("scrollSpeed")) {
            return this.options.getInt("scrollSpeed");
        }
        return 20;
    }

    public ToleranceEnum getTolerance() {
        String tolerance = this.options.getLiteral("tolerance");
        return tolerance == null ? ToleranceEnum.INTERSECT : ToleranceEnum.valueOf(tolerance.toUpperCase());
    }

    public int getZIndex() {
        if (this.options.containsKey("zIndex")) {
            return this.options.getInt("zIndex");
        }
        return 1000;
    }

    public SortableBehavior setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public boolean isDropOnEmpty() {
        if (this.options.containsKey("dropOnEmpty")) {
            return this.options.getBoolean("dropOnEmpty");
        }
        return true;
    }

    public boolean isForceHelperSize() {
        if (this.options.containsKey("forceHelperSize")) {
            return this.options.getBoolean("forceHelperSize");
        }
        return false;
    }

    public boolean isForcePlaceholderSize() {
        if (this.options.containsKey("forcePlaceholderSize")) {
            return this.options.getBoolean("forcePlaceholderSize");
        }
        return false;
    }

    @Deprecated
    public boolean isRevert() {
        if (this.options.containsKey("revert")) {
            return this.options.getBoolean("revert");
        }
        return false;
    }

    public boolean isScroll() {
        if (this.options.containsKey("scroll")) {
            return this.options.getBoolean("scroll");
        }
        return true;
    }

    public SortableBehavior setAppendTo(String appendTo) {
        this.options.putLiteral("appendTo", appendTo);
        return this;
    }

    public SortableBehavior setAxis(AxisEnum axis) {
        this.options.putLiteral("axis", axis != null ? axis.toString().toLowerCase() : null);
        return this;
    }

    public SortableBehavior setCancel(String cancel) {
        this.options.putLiteral("cancel", cancel);
        return this;
    }

    public SortableBehavior setConnectWith(String connectWith) {
        this.options.putLiteral("connectWith", connectWith);
        return this;
    }

    @Deprecated
    public SortableBehavior setContainment(String containment) {
        this.options.putLiteral("containment", containment);
        return this;
    }

    public SortableBehavior setContainment(SortableContainment containment) {
        this.options.put("containment", containment);
        return this;
    }

    public SortableBehavior setCursor(String cursor) {
        this.options.putLiteral("cursor", cursor);
        return this;
    }

    public SortableBehavior setCursorAt(CursorAtEnum cusorAt) {
        this.options.putLiteral("cursorAt", cusorAt.toString().toLowerCase().replace('_', ' '));
        return this;
    }

    public SortableBehavior setDelay(int delay) {
        this.options.put("delay", delay);
        return this;
    }

    public SortableBehavior setDistance(int distance) {
        this.options.put("distance", distance);
        return this;
    }

    public SortableBehavior setDropOnEmpty(boolean dropOnEmpty) {
        this.options.put("dropOnEmpty", dropOnEmpty);
        return this;
    }

    public SortableBehavior setForceHelperSize(boolean forceHelperSize) {
        this.options.put("forceHelperSize", forceHelperSize);
        return this;
    }

    public SortableBehavior setForcePlaceholderSize(boolean forcePlaceholderSize) {
        this.options.put("forcePlaceholderSize", forcePlaceholderSize);
        return this;
    }

    public SortableBehavior setGrid(int x, int y) {
        ArrayItemOptions<IntegerItemOptions> grids = new ArrayItemOptions<IntegerItemOptions>();
        grids.add(new IntegerItemOptions(x));
        grids.add(new IntegerItemOptions(y));
        this.options.put("grid", grids);
        return this;
    }

    public SortableBehavior setHandle(String handle) {
        this.options.putLiteral("handle", handle);
        return this;
    }

    @Deprecated
    public SortableBehavior setHelper(String helper) {
        this.options.putLiteral("helper", helper);
        return this;
    }

    public SortableBehavior setHelper(SortableHelper helper) {
        this.options.put("helper", helper);
        return this;
    }

    public SortableBehavior setItems(String items) {
        this.options.putLiteral("items", items);
        return this;
    }

    public SortableBehavior setOpacity(float opacity) {
        this.options.put("opacity", opacity);
        return this;
    }

    public SortableBehavior setPlaceholder(String placeholder) {
        this.options.putLiteral("placeholder", placeholder);
        return this;
    }

    @Deprecated
    public SortableBehavior setRevert(boolean revert) {
        this.options.put("revert", revert);
        return this;
    }

    public SortableBehavior setRevert(SortableRevert revert) {
        this.options.put("revert", revert);
        return this;
    }

    public SortableBehavior setScroll(boolean scroll) {
        this.options.put("scroll", scroll);
        return this;
    }

    public SortableBehavior setScrollSensitivity(int scrollSensitivity) {
        this.options.put("scrollSensitivity", scrollSensitivity);
        return this;
    }

    public SortableBehavior setScrollSpeed(int scrollSpeed) {
        this.options.put("scrollSpeed", scrollSpeed);
        return this;
    }

    public SortableBehavior setTolerance(ToleranceEnum tolerance) {
        this.options.putLiteral("tolerance", tolerance.toString().toLowerCase());
        return this;
    }

    public SortableBehavior setZIndex(int zIndex) {
        this.options.put("zIndex", zIndex);
        return this;
    }

    public SortableBehavior setActivateEvent(JsScopeUiEvent activate) {
        this.options.put("activate", activate);
        return this;
    }

    public SortableBehavior setBeforeStopEvent(JsScopeUiEvent beforeStop) {
        this.options.put("beforeStop", beforeStop);
        return this;
    }

    public SortableBehavior setChangeEvent(JsScopeUiEvent change) {
        this.options.put("change", change);
        return this;
    }

    public SortableBehavior setDeactivateEvent(JsScopeUiEvent deactivate) {
        this.options.put("deactivate", deactivate);
        return this;
    }

    public SortableBehavior setOutEvent(JsScopeUiEvent out) {
        this.options.put("out", out);
        return this;
    }

    public SortableBehavior setOverEvent(JsScopeUiEvent over) {
        this.options.put("over", over);
        return this;
    }

    public SortableBehavior setReceiveEvent(JsScopeUiEvent receive) {
        this.options.put("receive", receive);
        return this;
    }

    public SortableBehavior setRemoveEvent(JsScopeUiEvent remove) {
        this.options.put("remove", remove);
        return this;
    }

    public SortableBehavior setSortEvent(JsScopeUiEvent sort) {
        this.options.put("sort", sort);
        return this;
    }

    public SortableBehavior setStartEvent(JsScopeUiEvent start) {
        this.options.put("start", start);
        return this;
    }

    public SortableBehavior setStopEvent(JsScopeUiEvent stop) {
        this.options.put("stop", stop);
        return this;
    }

    public SortableBehavior setUpdateEvent(JsScopeUiEvent update) {
        this.options.put("update", update);
        return this;
    }

    public JsStatement cancel() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'cancel'");
    }

    public void cancel(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.cancel().render().toString());
    }

    public JsStatement destroy() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement refresh() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'refresh'");
    }

    public void refresh(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.refresh().render().toString());
    }

    public JsStatement refreshPositions() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'refreshPositions'");
    }

    public void refreshPositions(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.refreshPositions().render().toString());
    }

    public JsStatement serialize() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'serialize'");
    }

    public void serialize(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.serialize().render().toString());
    }

    public JsStatement toArray() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'toArray'");
    }

    public JsStatement widget() {
        return new JsQuery(this.getComponent()).$().chain("sortable", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToleranceEnum {
        INTERSECT,
        POINTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CursorAtEnum {
        TOP,
        TOP_LEFT,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisEnum {
        X,
        Y;

    }
}

