/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.persistence.context.filebackend;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openengsb.core.api.model.ConfigItem;
import org.openengsb.core.api.model.ContextConfiguration;
import org.openengsb.core.api.model.ContextId;
import org.openengsb.core.api.persistence.ConfigPersistenceBackendService;
import org.openengsb.core.api.persistence.InvalidConfigurationException;
import org.openengsb.core.api.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFilePersistenceService
implements ConfigPersistenceBackendService<Map<String, String>> {
    public static final String CONTEXT_FILE_EXTENSION = "context";
    private File storageFolder;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextFilePersistenceService.class);

    public List<ConfigItem<Map<String, String>>> load(Map<String, String> metadata) throws PersistenceException, InvalidConfigurationException {
        LOGGER.debug("Loading Configuration");
        if (metadata == null || metadata.isEmpty()) {
            return this.loadAll();
        }
        return this.loadFiltered(metadata);
    }

    public void persist(ConfigItem<Map<String, String>> config) throws PersistenceException, InvalidConfigurationException {
        Preconditions.checkArgument((boolean)this.supports(config.getClass()), (Object)"Argument type not supported");
        Preconditions.checkNotNull((Object)config.getMetaData(), (Object)"Invalid metadata");
        String contextFileName = this.getFileNameForMetaData(config.getMetaData());
        File contextPersistenceFile = new File(this.storageFolder, contextFileName);
        try {
            FileUtils.touch((File)contextPersistenceFile);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Could not persist context configuration file %s", contextFileName), (Throwable)e);
        }
        LOGGER.info("Created context configuration file %s", (Object)contextFileName);
    }

    public void remove(Map<String, String> metadata) throws PersistenceException {
        String contextFileName = this.getFileNameForMetaData(metadata);
        File contextPersistenceFile = new File(this.storageFolder, contextFileName);
        Boolean fileSuccessFullyDeleted = FileUtils.deleteQuietly((File)contextPersistenceFile);
        if (!fileSuccessFullyDeleted.booleanValue()) {
            throw new PersistenceException(String.format("Could not delete context configuration file %s", contextFileName));
        }
        LOGGER.info("Deleted context configuration file %s", (Object)contextFileName);
    }

    public boolean supports(Class<? extends ConfigItem<?>> configItemType) {
        return ContextConfiguration.class.isAssignableFrom(configItemType);
    }

    private List<ConfigItem<Map<String, String>>> loadAll() {
        Collection contextFiles = FileUtils.listFiles((File)this.storageFolder, (String[])this.getContextExtensions(), (boolean)false);
        ArrayList<ConfigItem<Map<String, String>>> contexts = new ArrayList<ConfigItem<Map<String, String>>>();
        for (File contextFile : contextFiles) {
            contexts.add(this.loadContextConfigurationFromFile(contextFile));
        }
        return contexts;
    }

    private List<ConfigItem<Map<String, String>>> loadFiltered(Map<String, String> metaData) throws PersistenceException {
        ArrayList<ConfigItem<Map<String, String>>> configurations = new ArrayList<ConfigItem<Map<String, String>>>();
        File configurationFile = new File(this.storageFolder, this.getFileNameForMetaData(metaData));
        if (configurationFile.exists()) {
            configurations.add(this.loadContextConfigurationFromFile(configurationFile));
        }
        return configurations;
    }

    private String getFileNameForMetaData(Map<String, String> metaData) throws PersistenceException {
        ContextId contextId = ContextId.fromMetaData(metaData);
        return String.format("%s.%s", contextId.getId(), CONTEXT_FILE_EXTENSION);
    }

    private ConfigItem<Map<String, String>> loadContextConfigurationFromFile(File configurationFile) {
        String contextFileName = FilenameUtils.removeExtension((String)configurationFile.getName());
        ContextId contextId = new ContextId(contextFileName);
        ContextConfiguration contextConfig = new ContextConfiguration(contextId.toMetaData(), null);
        return contextConfig;
    }

    private String[] getContextExtensions() {
        String[] contextFileExtensions = new String[]{CONTEXT_FILE_EXTENSION};
        return contextFileExtensions;
    }

    public void setStorageFolderPath(String storageFolderPath) {
        this.storageFolder = new File(storageFolderPath);
        if (!this.storageFolder.exists()) {
            this.storageFolder.mkdirs();
        }
    }
}

