/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public abstract class CsvRecord {
    private final Map<Integer, String> values = new HashMap<Integer, String>();

    protected CsvRecord() {
    }

    public void dump(Writer writer) throws IOException {
        this.dump(writer, "<br>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Writer writer, String string) throws IOException {
        for (int i = 0; i < this.getRecordLenth(); ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            StringReader stringReader = null;
            try {
                stringReader = new StringReader(StringUtils.trimToEmpty((String)this.get(i)));
                for (String string2 : IOUtils.readLines((Reader)stringReader)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stringReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)stringReader);
            writer.write(i + ":" + stringBuilder.toString());
            writer.write(SystemUtils.LINE_SEPARATOR);
        }
    }

    protected final String get(int n) {
        return this.get(n, null);
    }

    protected final String get(int n, String string) {
        String string2 = StringUtils.trimToNull((String)this.values.get(n));
        return string2 != null ? string2 : string;
    }

    protected abstract int getRecordLenth();

    protected void parse(CSVRecord cSVRecord) {
        this.values.clear();
        for (int i = 0; i < cSVRecord.size(); ++i) {
            this.values.put(i, this.parse(cSVRecord.get(i)));
        }
    }

    protected String parse(String string) {
        return string;
    }

    protected Iterable<String> print() {
        int n = this.getRecordLenth();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.get(i));
        }
        return arrayList;
    }

    protected final void set(int n, String string) {
        if ((string = StringUtils.trimToNull((String)string)) != null) {
            this.values.put(n, string);
        } else if (this.values.containsKey(n)) {
            this.values.remove(n);
        }
    }
}

