/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import org.openestate.io.core.XmlDocument;
import org.openestate.io.core.XmlVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class XmlConvertableDocument<JavaType, VersionType extends XmlVersion>
extends XmlDocument<JavaType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConvertableDocument.class);

    public XmlConvertableDocument(Document document) {
        super(document);
    }

    public void downgrade(VersionType VersionType) {
        if (VersionType == null) {
            throw new NullPointerException("No target version was provided!");
        }
        VersionType VersionType2 = this.getDocumentVersion();
        if (VersionType2 == null) {
            VersionType2 = this.getLatestVersion();
            LOGGER.warn("Can't determine document version! Assuming latest version " + VersionType2.toReadableVersion() + ".");
        }
        if (VersionType2 == VersionType) {
            return;
        }
        if (VersionType2.isOlderThen((XmlVersion)VersionType)) {
            LOGGER.warn("The provided target version (" + VersionType.toReadableVersion() + ") is newer then the document version (" + VersionType2.toReadableVersion() + ").");
            return;
        }
        Object object = VersionType2;
        do {
            object.getConverter().downgradeToPreviousVersion(this);
        } while ((object = object.getPreviousVersion()) != VersionType);
    }

    public abstract VersionType getDocumentVersion();

    public abstract VersionType getLatestVersion();

    public abstract void setDocumentVersion(VersionType var1);

    public void upgrade(XmlVersion xmlVersion) {
        if (xmlVersion == null) {
            throw new NullPointerException("No target version was provided!");
        }
        VersionType VersionType = this.getDocumentVersion();
        if (VersionType == null) {
            VersionType = this.getLatestVersion();
            LOGGER.warn("Can't determine document version! Assuming latest version " + VersionType.toReadableVersion() + ".");
        }
        if (VersionType == xmlVersion) {
            return;
        }
        if (VersionType.isNewerThen(xmlVersion)) {
            LOGGER.warn("The provided target version (" + xmlVersion.toReadableVersion() + ") is older then the document version (" + VersionType.toReadableVersion() + ").");
            return;
        }
        Object object = VersionType;
        do {
            object = object.getNextVersion();
            object.getConverter().upgradeFromPreviousVersion(this);
        } while (object != xmlVersion);
    }

    public final void upgradeToLatestVersion() {
        this.upgrade((XmlVersion)this.getLatestVersion());
    }
}

