/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.openestate.io.core.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class XmlDocument<JavaType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlDocument.class);
    private final Document document;
    private boolean textWrittenAsCDATA = false;

    protected XmlDocument(Document document) {
        this.document = document;
    }

    public final Document getDocument() {
        return this.document;
    }

    public final boolean isTextWrittenAsCDATA() {
        return this.textWrittenAsCDATA;
    }

    protected void prepareDocumentBeforeWritingToXml(Document document) throws IOException {
    }

    public void setTextWrittenAsCDATA(boolean bl) {
        this.textWrittenAsCDATA = bl;
    }

    public abstract JavaType toObject() throws JAXBException;

    public final void toXml(File file) throws TransformerException, IOException {
        this.toXml(file, true);
    }

    public void toXml(File file, boolean bl) throws TransformerException, IOException {
        if (this.isTextWrittenAsCDATA()) {
            XmlUtils.replaceTextWithCData(this.getDocument());
        }
        this.prepareDocumentBeforeWritingToXml(this.getDocument());
        XmlUtils.write(this.getDocument(), file, bl);
    }

    public final void toXml(OutputStream outputStream) throws TransformerException, IOException {
        this.toXml(outputStream, true);
    }

    public void toXml(OutputStream outputStream, boolean bl) throws TransformerException, IOException {
        if (this.isTextWrittenAsCDATA()) {
            XmlUtils.replaceTextWithCData(this.getDocument());
        }
        this.prepareDocumentBeforeWritingToXml(this.getDocument());
        XmlUtils.write(this.getDocument(), outputStream, bl);
    }

    public final void toXml(Writer writer) throws TransformerException, IOException {
        this.toXml(writer, true);
    }

    public void toXml(Writer writer, boolean bl) throws TransformerException, IOException {
        if (this.isTextWrittenAsCDATA()) {
            XmlUtils.replaceTextWithCData(this.getDocument());
        }
        this.prepareDocumentBeforeWritingToXml(this.getDocument());
        XmlUtils.write(this.getDocument(), writer, bl);
    }

    public String toXmlString() throws TransformerException, IOException {
        return this.toXmlString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toXmlString(boolean bl) throws TransformerException, IOException {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            this.toXml(stringWriter, bl);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Writer)stringWriter);
        }
    }
}

