/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.casa_it.CasaItDocument;
import org.openestate.io.casa_it.CasaItUtils;
import org.openestate.io.casa_it.xml.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CasaItReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasaItReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)CasaItReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                CasaItReadingExample.read(CasaItReadingExample.class.getResourceAsStream("/org/openestate/io/examples/casa_it.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    CasaItReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        CasaItDocument casaItDocument = CasaItUtils.createDocument((File)file);
        if (casaItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            CasaItReadingExample.printToConsole(casaItDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        CasaItDocument casaItDocument = CasaItUtils.createDocument((InputStream)inputStream);
        if (casaItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            CasaItReadingExample.printToConsole(casaItDocument);
        }
    }

    protected static void printToConsole(CasaItDocument casaItDocument) throws JAXBException {
        Container container = casaItDocument.toObject();
        if (container.getRealestateitems() != null) {
            for (Container.Realestateitems.Realestate realestate : container.getRealestateitems().getRealestate()) {
                String string;
                String string2 = StringUtils.trimToNull((String)realestate.getReference());
                if (string2 == null) {
                    string2 = "???";
                }
                String string3 = string = realestate.getDescription() != null ? StringUtils.trimToNull((String)realestate.getDescription().getValue()) : null;
                if (string == null) {
                    string = "???";
                }
                LOGGER.info("> found object '" + string2 + "' " + "with title '" + string + "'");
            }
        }
    }
}

