/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.casa_it.CasaItDocument;
import org.openestate.io.casa_it.CasaItUtils;
import org.openestate.io.casa_it.xml.Container;
import org.openestate.io.casa_it.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasaItWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasaItWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = CasaItUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)CasaItWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Container container = FACTORY.createContainer();
        container.setRealestateitems(FACTORY.createContainerRealestateitems());
        container.getRealestateitems().getRealestate().add(CasaItWritingExample.createRealestate());
        container.getRealestateitems().getRealestate().add(CasaItWritingExample.createRealestate());
        container.getRealestateitems().getRealestate().add(CasaItWritingExample.createRealestate());
        CasaItDocument casaItDocument = null;
        try {
            casaItDocument = CasaItDocument.newDocument((Container)container);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            CasaItWritingExample.write(casaItDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        CasaItWritingExample.write(casaItDocument, (OutputStream)new NullOutputStream());
        CasaItWritingExample.write(casaItDocument, (Writer)new NullWriter());
        CasaItWritingExample.writeToConsole(casaItDocument);
    }

    protected static Container.Realestateitems.Realestate createRealestate() {
        Container.Realestateitems.Realestate realestate = FACTORY.createContainerRealestateitemsRealestate();
        realestate.setAction(BigInteger.ONE);
        realestate.setAgencycode(0);
        realestate.setBathrooms(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        realestate.setCondition(BigInteger.ONE);
        realestate.setContracttype(BigInteger.ONE);
        realestate.setFloor(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        realestate.setHasbalcony(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.setHasterrace(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.setHeatingtype(BigInteger.ONE);
        realestate.setHousetypology(BigInteger.ONE);
        realestate.setOccupationstate(BigInteger.ONE);
        realestate.setRealestatetype(BigInteger.ONE);
        realestate.setReference(RandomStringUtils.randomAlphanumeric((int)5));
        realestate.setReferenceID(Integer.valueOf(RandomUtils.nextInt((int)1, (int)1000)));
        realestate.setRooms(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)10L)));
        realestate.setSize(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)5000L)));
        realestate.setAddress(FACTORY.createContainerRealestateitemsRealestateAddress());
        realestate.getAddress().setCity("Berlin");
        realestate.getAddress().setNumber("123");
        realestate.getAddress().setStreet("example street");
        realestate.getAddress().setZip("12345");
        realestate.getAddress().setZone("Berlin");
        realestate.setBox(FACTORY.createContainerRealestateitemsRealestateBox());
        realestate.getBox().setSize(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)1000L)));
        realestate.getBox().setType(BigInteger.ONE);
        realestate.setBuilding(FACTORY.createContainerRealestateitemsRealestateBuilding());
        realestate.getBuilding().setAge(BigInteger.valueOf(RandomUtils.nextLong((long)5L, (long)50L)));
        realestate.getBuilding().setExpenses(BigDecimal.valueOf(RandomUtils.nextDouble((double)1000.0, (double)1000000.0)));
        realestate.getBuilding().setHaslift(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.getBuilding().setTotalfloors(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        realestate.getBuilding().setUnits(BigInteger.ONE);
        realestate.setConfiguration(FACTORY.createContainerRealestateitemsRealestateConfiguration());
        realestate.getConfiguration().setIsaddressvisibleonsite(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.getConfiguration().setIsmapvisible(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.getConfiguration().setIsrealestatevisibleonmap(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        realestate.setDescription(FACTORY.createContainerRealestateitemsRealestateDescription());
        realestate.getDescription().setValue("a nice little description for the object");
        realestate.setGarden(FACTORY.createContainerRealestateitemsRealestateGarden());
        realestate.getGarden().setSize(BigInteger.valueOf(RandomUtils.nextLong((long)10L, (long)100L)));
        realestate.getGarden().setType(BigInteger.ONE);
        realestate.setGooglemapcoordinate(FACTORY.createContainerRealestateitemsRealestateGooglemapcoordinate());
        realestate.getGooglemapcoordinate().setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        realestate.getGooglemapcoordinate().setLatitudemapcenter(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        realestate.getGooglemapcoordinate().setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        realestate.getGooglemapcoordinate().setLongitudemapcenter(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        realestate.getGooglemapcoordinate().setMapzoom(Integer.valueOf(10));
        realestate.setImages(FACTORY.createContainerRealestateitemsRealestateImages());
        realestate.getImages().getAdvertismentimage().add(CasaItWritingExample.createAdvertismentimage());
        realestate.getImages().getAdvertismentimage().add(CasaItWritingExample.createAdvertismentimage());
        realestate.getImages().getAdvertismentimage().add(CasaItWritingExample.createAdvertismentimage());
        realestate.setPrice(FACTORY.createContainerRealestateitemsRealestatePrice());
        realestate.getPrice().setMax(BigDecimal.valueOf(RandomUtils.nextDouble((double)1000.0, (double)1000000.0)));
        realestate.getPrice().setMin(BigDecimal.valueOf(RandomUtils.nextDouble((double)1000.0, (double)1000000.0)));
        realestate.getPrice().setValue(BigDecimal.valueOf(RandomUtils.nextDouble((double)1000.0, (double)1000000.0)));
        return realestate;
    }

    protected static Container.Realestateitems.Realestate.Images.Advertismentimage createAdvertismentimage() {
        Container.Realestateitems.Realestate.Images.Advertismentimage advertismentimage = FACTORY.createContainerRealestateitemsRealestateImagesAdvertismentimage();
        advertismentimage.setImagetype("image/jpeg");
        advertismentimage.setPath("image-" + RandomStringUtils.randomNumeric((int)3) + ".jpg");
        return advertismentimage;
    }

    protected static void write(CasaItDocument casaItDocument, File file) {
        LOGGER.info("writing document");
        try {
            casaItDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(CasaItDocument casaItDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            casaItDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(CasaItDocument casaItDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            casaItDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(CasaItDocument casaItDocument) {
        LOGGER.info("writing document");
        try {
            String string = casaItDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

