/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.daft_ie.DaftIeDocument;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.xml.CommercialType;
import org.openestate.io.daft_ie.xml.Daft;
import org.openestate.io.daft_ie.xml.HouseType;
import org.openestate.io.daft_ie.xml.ObjectFactory;
import org.openestate.io.daft_ie.xml.OverseasRentalAdType;
import org.openestate.io.daft_ie.xml.OverseasSaleAdType;
import org.openestate.io.daft_ie.xml.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaftIeWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = DaftIeUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)DaftIeWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Daft daft = FACTORY.createDaft();
        daft.setOverseasRental(FACTORY.createDaftOverseasRental());
        daft.getOverseasRental().getOverseasRentalAd().add(DaftIeWritingExample.createAdForRent());
        daft.getOverseasRental().getOverseasRentalAd().add(DaftIeWritingExample.createAdForRent());
        daft.setOverseasSales(FACTORY.createDaftOverseasSales());
        daft.getOverseasSales().getOverseasSaleAd().add(DaftIeWritingExample.createAdForSale());
        daft.getOverseasSales().getOverseasSaleAd().add(DaftIeWritingExample.createAdForSale());
        daft.getOverseasSales().getOverseasSaleAd().add(DaftIeWritingExample.createAdForSale());
        DaftIeDocument daftIeDocument = null;
        try {
            daftIeDocument = DaftIeDocument.newDocument((Daft)daft);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            DaftIeWritingExample.write(daftIeDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        DaftIeWritingExample.write(daftIeDocument, (OutputStream)new NullOutputStream());
        DaftIeWritingExample.write(daftIeDocument, (Writer)new NullWriter());
        DaftIeWritingExample.writeToConsole(daftIeDocument);
    }

    protected static OverseasRentalAdType createAdForRent() {
        OverseasRentalAdType overseasRentalAdType = FACTORY.createOverseasRentalAdType();
        overseasRentalAdType.setAddress("Beispielstra\u00dfe 123");
        overseasRentalAdType.setAgentId("123");
        overseasRentalAdType.setArea("Berlin");
        overseasRentalAdType.setAvailableFrom(Calendar.getInstance());
        overseasRentalAdType.setBathroomNumber(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setBedroomNumber(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setCableTelevision(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasRentalAdType.setCcEmail("test@openestate.org");
        overseasRentalAdType.setCommercialType(CommercialType.LAND);
        overseasRentalAdType.setContactName("Max Mustermann");
        overseasRentalAdType.setCountry("DE");
        overseasRentalAdType.setDescription("A description about the property.");
        overseasRentalAdType.setDishwasher(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasRentalAdType.setDoubleBeds(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setDryer(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasRentalAdType.setExternalId(String.valueOf(RandomUtils.nextInt((int)1, (int)1000)));
        overseasRentalAdType.setFurnished(OverseasRentalAdType.Furnished.FURNISHED);
        overseasRentalAdType.setHouseType(HouseType.TOWNHOUSE);
        overseasRentalAdType.setLease(BigInteger.valueOf(RandomUtils.nextInt((int)100, (int)1000)));
        overseasRentalAdType.setMainEmail("test@openstate.org");
        overseasRentalAdType.setMicrowave(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasRentalAdType.setNumberPeople(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setPhone1("030/123456");
        overseasRentalAdType.setPhone2("030/123457");
        overseasRentalAdType.setPhoneInfo("Some information about contacts via phone.");
        overseasRentalAdType.setPropertyType(PropertyType.HOUSE);
        overseasRentalAdType.setRegion("Berlin");
        overseasRentalAdType.setRent(BigInteger.valueOf(RandomUtils.nextInt((int)100, (int)1000)));
        overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
        overseasRentalAdType.setSingleBeds(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setTwinBeds(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasRentalAdType.setWashingMachine(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasRentalAdType.setFeatures(FACTORY.createFeaturesType());
        overseasRentalAdType.getFeatures().getFeature().add("another feature");
        overseasRentalAdType.getFeatures().getFeature().add("some more feature");
        overseasRentalAdType.setPhotos(FACTORY.createPhotosType());
        try {
            overseasRentalAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image1.jpg"));
            overseasRentalAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image2.jpg"));
            overseasRentalAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image3.jpg"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return overseasRentalAdType;
    }

    protected static OverseasSaleAdType createAdForSale() {
        OverseasSaleAdType overseasSaleAdType = FACTORY.createOverseasSaleAdType();
        overseasSaleAdType.setAcres(BigDecimal.valueOf(RandomUtils.nextDouble((double)10.0, (double)1000.0)));
        overseasSaleAdType.setAddress("Beispielstra\u00dfe 123");
        overseasSaleAdType.setAgentId("123");
        overseasSaleAdType.setArea("Berlin");
        overseasSaleAdType.setBathroomNumber(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasSaleAdType.setBedroomNumber(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        overseasSaleAdType.setCcEmail("test@openestate.org");
        overseasSaleAdType.setCo2Rating("some notes about CO2 rating");
        overseasSaleAdType.setCommercialType(CommercialType.SHOP);
        overseasSaleAdType.setContactName("Max Mustermann");
        overseasSaleAdType.setCountry("DE");
        overseasSaleAdType.setDescription("A description about the property.");
        overseasSaleAdType.setDirections("some notes about directions");
        overseasSaleAdType.setEnergyRating("some notes about energy rating");
        overseasSaleAdType.setExternalId(String.valueOf(RandomUtils.nextInt((int)1, (int)1000)));
        overseasSaleAdType.setHouseType(HouseType.DETACHED);
        overseasSaleAdType.setIsNewDevelopment(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        overseasSaleAdType.setMainEmail("test@openstate.org");
        overseasSaleAdType.setNewDevelopmentAvailability("some notes about development");
        overseasSaleAdType.setPhone1("030/123456");
        overseasSaleAdType.setPhone2("030/123457");
        overseasSaleAdType.setPhoneInfo("Some information about contacts via phone.");
        overseasSaleAdType.setPrice(BigInteger.valueOf(RandomUtils.nextInt((int)100, (int)1000000)));
        overseasSaleAdType.setPriceType(OverseasSaleAdType.PriceType.REGION);
        overseasSaleAdType.setPropertyStatus(OverseasSaleAdType.PropertyStatus.FOR_SALE);
        overseasSaleAdType.setPropertyType(PropertyType.HOUSE);
        overseasSaleAdType.setRegion("Berlin");
        overseasSaleAdType.setSquareMetres(BigDecimal.valueOf(RandomUtils.nextDouble((double)10.0, (double)1000.0)));
        overseasSaleAdType.setUnitsAvailable(BigInteger.valueOf(RandomUtils.nextInt((int)1, (int)50)));
        overseasSaleAdType.setViewingDetails("some notes about viewing details");
        overseasSaleAdType.setFeatures(FACTORY.createFeaturesType());
        overseasSaleAdType.getFeatures().getFeature().add("another feature");
        overseasSaleAdType.getFeatures().getFeature().add("some more feature");
        overseasSaleAdType.setPdfs(FACTORY.createPdfsType());
        try {
            overseasSaleAdType.getPdfs().getPdf().add(new URL("http://www.mywebsite.org/document1.pdf"));
            overseasSaleAdType.getPdfs().getPdf().add(new URL("http://www.mywebsite.org/document2.pdf"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        overseasSaleAdType.setPhotos(FACTORY.createPhotosType());
        try {
            overseasSaleAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image1.jpg"));
            overseasSaleAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image2.jpg"));
            overseasSaleAdType.getPhotos().getPhoto().add(new URL("http://www.mywebsite.org/image3.jpg"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return overseasSaleAdType;
    }

    protected static void write(DaftIeDocument daftIeDocument, File file) {
        LOGGER.info("writing document with version " + daftIeDocument.getDocumentVersion());
        try {
            daftIeDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(DaftIeDocument daftIeDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + daftIeDocument.getDocumentVersion());
        try {
            daftIeDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(DaftIeDocument daftIeDocument, Writer writer) {
        LOGGER.info("writing document with version " + daftIeDocument.getDocumentVersion());
        try {
            daftIeDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(DaftIeDocument daftIeDocument) {
        LOGGER.info("writing document with version " + daftIeDocument.getDocumentVersion());
        try {
            String string = daftIeDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

