/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.filemaker.FilemakerResultDocument;
import org.openestate.io.filemaker.FilemakerUtils;
import org.openestate.io.filemaker.xml.result.DatabaseType;
import org.openestate.io.filemaker.xml.result.FMPXMLRESULT;
import org.openestate.io.filemaker.xml.result.FieldType;
import org.openestate.io.filemaker.xml.result.MetaDataType;
import org.openestate.io.filemaker.xml.result.ObjectFactory;
import org.openestate.io.filemaker.xml.result.ProductType;
import org.openestate.io.filemaker.xml.result.ResultSetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilemakerWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilemakerWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = FilemakerUtils.getFactoryForResult();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)FilemakerWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        FMPXMLRESULT fMPXMLRESULT = FACTORY.createFMPXMLRESULT();
        fMPXMLRESULT.setERRORCODE("0");
        fMPXMLRESULT.setPRODUCT(FilemakerWritingExample.createProduct());
        fMPXMLRESULT.setDATABASE(FilemakerWritingExample.createDatabase());
        fMPXMLRESULT.setMETADATA(FilemakerWritingExample.createMetaData());
        fMPXMLRESULT.setRESULTSET(FilemakerWritingExample.createResultSet());
        FilemakerResultDocument filemakerResultDocument = null;
        try {
            filemakerResultDocument = FilemakerResultDocument.newDocument((FMPXMLRESULT)fMPXMLRESULT);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            FilemakerWritingExample.write(filemakerResultDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        FilemakerWritingExample.write(filemakerResultDocument, (OutputStream)new NullOutputStream());
        FilemakerWritingExample.write(filemakerResultDocument, (Writer)new NullWriter());
        FilemakerWritingExample.writeToConsole(filemakerResultDocument);
    }

    protected static DatabaseType createDatabase() {
        DatabaseType databaseType = FACTORY.createDatabaseType();
        databaseType.setNAME("example database");
        databaseType.setLAYOUT("fmmedia2universal");
        databaseType.setDATEFORMAT("D.m.yyyy");
        databaseType.setTIMEFORMAT("k:mm:ss");
        databaseType.setRECORDS(BigInteger.ZERO);
        return databaseType;
    }

    protected static MetaDataType createMetaData() {
        MetaDataType metaDataType = FACTORY.createMetaDataType();
        MetaDataType.FIELD fIELD = FACTORY.createMetaDataTypeFIELD();
        fIELD.setNAME("number of rooms");
        fIELD.setEMPTYOK(Boolean.valueOf(true));
        fIELD.setMAXREPEAT(BigInteger.ONE);
        fIELD.setTYPE(FieldType.NUMBER);
        metaDataType.getFIELD().add(fIELD);
        fIELD = FACTORY.createMetaDataTypeFIELD();
        fIELD.setNAME("price");
        fIELD.setEMPTYOK(Boolean.valueOf(false));
        fIELD.setMAXREPEAT(BigInteger.ONE);
        fIELD.setTYPE(FieldType.NUMBER);
        metaDataType.getFIELD().add(fIELD);
        fIELD = FACTORY.createMetaDataTypeFIELD();
        fIELD.setNAME("description");
        fIELD.setEMPTYOK(Boolean.valueOf(true));
        fIELD.setMAXREPEAT(BigInteger.ONE);
        fIELD.setTYPE(FieldType.TEXT);
        metaDataType.getFIELD().add(fIELD);
        return metaDataType;
    }

    protected static ProductType createProduct() {
        ProductType productType = FACTORY.createProductType();
        productType.setNAME("OpenEstate-IO");
        productType.setVERSION("1.1");
        productType.setBUILD("123");
        return productType;
    }

    protected static ResultSetType createResultSet() {
        ResultSetType resultSetType = FACTORY.createResultSetType();
        resultSetType.getROW().add(FilemakerWritingExample.createResultSetRow(1L, 3, 100, "a first example"));
        resultSetType.getROW().add(FilemakerWritingExample.createResultSetRow(2L, null, 200, "a second example"));
        resultSetType.getROW().add(FilemakerWritingExample.createResultSetRow(3L, 5, 300, null));
        resultSetType.setFOUND(BigInteger.valueOf(resultSetType.getROW().size()));
        return resultSetType;
    }

    protected static ResultSetType.ROW createResultSetRow(long l, Number number, Number number2, String string) {
        ResultSetType.ROW rOW = FACTORY.createResultSetTypeROW();
        rOW.setRECORDID(BigInteger.valueOf(l));
        rOW.setMODID(BigInteger.valueOf(l));
        ResultSetType.ROW.COL cOL = FACTORY.createResultSetTypeROWCOL();
        if (number != null) {
            cOL.getDATA().add("");
        } else {
            cOL.getDATA().add(String.valueOf(number));
        }
        rOW.getCOL().add(cOL);
        cOL = FACTORY.createResultSetTypeROWCOL();
        if (number2 != null) {
            cOL.getDATA().add("0");
        } else {
            cOL.getDATA().add(String.valueOf(number2));
        }
        rOW.getCOL().add(cOL);
        cOL = FACTORY.createResultSetTypeROWCOL();
        cOL.getDATA().add(StringUtils.trimToEmpty((String)string));
        rOW.getCOL().add(cOL);
        return rOW;
    }

    protected static void write(FilemakerResultDocument filemakerResultDocument, File file) {
        LOGGER.info("writing document");
        try {
            filemakerResultDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(FilemakerResultDocument filemakerResultDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            filemakerResultDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(FilemakerResultDocument filemakerResultDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            filemakerResultDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(FilemakerResultDocument filemakerResultDocument) {
        LOGGER.info("writing document");
        try {
            String string = filemakerResultDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

