/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImmoXmlReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)ImmoXmlReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                ImmoXmlReadingExample.read(ImmoXmlReadingExample.class.getResourceAsStream("/org/openestate/io/examples/immoxml.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    ImmoXmlReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        ImmoXmlDocument immoXmlDocument = ImmoXmlUtils.createDocument((File)file);
        if (immoXmlDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            ImmoXmlReadingExample.printToConsole(immoXmlDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        ImmoXmlDocument immoXmlDocument = ImmoXmlUtils.createDocument((InputStream)inputStream);
        if (immoXmlDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            ImmoXmlReadingExample.printToConsole(immoXmlDocument);
        }
    }

    protected static void printToConsole(ImmoXmlDocument immoXmlDocument) throws JAXBException {
        LOGGER.info("> process document in version " + immoXmlDocument.getDocumentVersion());
        Immoxml immoxml = immoXmlDocument.toObject();
        for (Anbieter anbieter : immoxml.getAnbieter()) {
            LOGGER.info(">> found agency '" + anbieter.getAnbieternr() + "'");
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                String string = immobilie.getVerwaltungTechn() != null ? immobilie.getVerwaltungTechn().getObjektnrIntern() : "???";
                String string2 = immobilie.getFreitexte() != null ? immobilie.getFreitexte().getObjekttitel() : "???";
                LOGGER.info(">>> found object '" + string + "' " + "with title '" + string2 + "'");
            }
        }
    }
}

