/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.openestate.io.is24_xml.xml.VirtuelleImmobilieBaseTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Is24XmlReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)Is24XmlReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                Is24XmlReadingExample.read(Is24XmlReadingExample.class.getResourceAsStream("/org/openestate/io/examples/is24.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    Is24XmlReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        Is24XmlDocument is24XmlDocument = Is24XmlUtils.createDocument((File)file);
        if (is24XmlDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            Is24XmlReadingExample.printToConsole(is24XmlDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        Is24XmlDocument is24XmlDocument = Is24XmlUtils.createDocument((InputStream)inputStream);
        if (is24XmlDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            Is24XmlReadingExample.printToConsole(is24XmlDocument);
        }
    }

    protected static void printToConsole(Is24XmlDocument is24XmlDocument) throws JAXBException {
        ImmobilienTransferTyp immobilienTransferTyp = is24XmlDocument.toObject();
        if (immobilienTransferTyp.getAnbieter() != null) {
            String string;
            String string2;
            ImmobilieBaseTyp immobilieBaseTyp;
            for (JAXBElement jAXBElement : immobilienTransferTyp.getAnbieter().getImmobilie()) {
                immobilieBaseTyp = (ImmobilieBaseTyp)jAXBElement.getValue();
                string2 = !StringUtils.isBlank((CharSequence)immobilieBaseTyp.getAnbieterObjektID()) ? immobilieBaseTyp.getAnbieterObjektID().trim() : "???";
                string = !StringUtils.isBlank((CharSequence)immobilieBaseTyp.getUeberschrift()) ? immobilieBaseTyp.getUeberschrift().trim() : "???";
                LOGGER.info("> found object '" + string2 + "' " + "with title '" + string + "'");
            }
            for (JAXBElement jAXBElement : immobilienTransferTyp.getAnbieter().getVirtuelleImmobilie()) {
                immobilieBaseTyp = (VirtuelleImmobilieBaseTyp)jAXBElement.getValue();
                string2 = !StringUtils.isBlank((CharSequence)immobilieBaseTyp.getAnbieterObjektID()) ? immobilieBaseTyp.getAnbieterObjektID().trim() : "???";
                string = !StringUtils.isBlank((CharSequence)immobilieBaseTyp.getUeberschrift()) ? immobilieBaseTyp.getUeberschrift().trim() : "???";
                LOGGER.info("> found virtual object '" + string2 + "' " + "with title '" + string + "'");
            }
        }
    }
}

