/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class KyeroReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)KyeroReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                KyeroReadingExample.read(KyeroReadingExample.class.getResourceAsStream("/org/openestate/io/examples/kyero.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    KyeroReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        KyeroDocument kyeroDocument = KyeroUtils.createDocument((File)file);
        if (kyeroDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            KyeroReadingExample.printToConsole(kyeroDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        KyeroDocument kyeroDocument = KyeroUtils.createDocument((InputStream)inputStream);
        if (kyeroDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            KyeroReadingExample.printToConsole(kyeroDocument);
        }
    }

    protected static void printToConsole(KyeroDocument kyeroDocument) throws JAXBException {
        Root root = kyeroDocument.toObject();
        for (PropertyType propertyType : root.getProperty()) {
            String string = propertyType.getId() != null ? propertyType.getId() : "???";
            String string2 = null;
            if (propertyType.getDesc() != null) {
                string2 = StringUtils.trimToNull((String)propertyType.getDesc().getEn());
                if (string2 == null) {
                    string2 = StringUtils.trimToNull((String)propertyType.getDesc().getDe());
                }
                if (string2 == null) {
                    string2 = StringUtils.trimToNull((String)propertyType.getDesc().getEs());
                }
            }
            LOGGER.info("> found object '" + string + "' " + "with title '" + string2 + "'");
        }
    }
}

