/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.CurrencyType;
import org.openestate.io.kyero.xml.EnergyRatingMarkType;
import org.openestate.io.kyero.xml.ImagesType;
import org.openestate.io.kyero.xml.KyeroType;
import org.openestate.io.kyero.xml.ObjectFactory;
import org.openestate.io.kyero.xml.PriceFreqType;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyeroWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = KyeroUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)KyeroWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Root root = FACTORY.createRoot();
        root.setKyero(KyeroWritingExample.createKyero());
        root.setAgent(KyeroWritingExample.createAgent());
        root.getProperty().add(KyeroWritingExample.createProperty());
        root.getProperty().add(KyeroWritingExample.createProperty());
        root.getProperty().add(KyeroWritingExample.createProperty());
        KyeroDocument kyeroDocument = null;
        try {
            kyeroDocument = KyeroDocument.newDocument((Root)root);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            KyeroWritingExample.write(kyeroDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        KyeroWritingExample.write(kyeroDocument, (OutputStream)new NullOutputStream());
        KyeroWritingExample.write(kyeroDocument, (Writer)new NullWriter());
        KyeroWritingExample.writeToConsole(kyeroDocument);
        kyeroDocument.downgrade((XmlVersion)KyeroVersion.V2_1);
        KyeroWritingExample.writeToConsole(kyeroDocument);
    }

    protected static Root.Agent createAgent() {
        Root.Agent agent = FACTORY.createRootAgent();
        agent.setAddr1("first address line");
        agent.setAddr2("second address line");
        agent.setCountry("Germany");
        agent.setEmail("test@test.org");
        agent.setFax("030/123456");
        agent.setId(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)10000L)));
        agent.setMob("030/123457");
        agent.setName("name of the company");
        agent.setPostcode("12345");
        agent.setRegion("Berlin");
        agent.setTel("030/123458");
        agent.setTown("Berlin");
        return agent;
    }

    protected static KyeroType createKyero() {
        KyeroType kyeroType = FACTORY.createKyeroType();
        kyeroType.setFeedGenerated(Calendar.getInstance());
        kyeroType.setFeedVersion(KyeroUtils.VERSION.toXmlVersion());
        return kyeroType;
    }

    protected static PropertyType createProperty() {
        String string = RandomStringUtils.randomAlphanumeric((int)5);
        int n = 0;
        PropertyType propertyType = FACTORY.createPropertyType();
        propertyType.setBaths(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)5L)));
        propertyType.setBeds(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)5L)));
        propertyType.setCurrency(CurrencyType.EUR);
        propertyType.setDate(Calendar.getInstance());
        propertyType.setId(string);
        propertyType.setLeasehold(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setLocationDetail("some details about the location");
        propertyType.setNewBuild(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setNotes("some notes about the property");
        propertyType.setPartOwnership(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setPool(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setPrice(Long.valueOf(RandomUtils.nextLong((long)10000L, (long)9999999L)));
        propertyType.setPriceFreq(PriceFreqType.SALE);
        propertyType.setProvince("Berlin");
        propertyType.setRef(RandomStringUtils.randomAlphanumeric((int)5));
        propertyType.setTown("Berlin");
        propertyType.setType("house");
        propertyType.setDesc(FACTORY.createLangType());
        propertyType.getDesc().setAr("Arabic property description");
        propertyType.getDesc().setBg("Bulgarian property description");
        propertyType.getDesc().setCa("Catalan property description");
        propertyType.getDesc().setCs("Czech property description");
        propertyType.getDesc().setDa("Danish property description");
        propertyType.getDesc().setDe("German property description");
        propertyType.getDesc().setEl("Greek property description");
        propertyType.getDesc().setEn("English property description");
        propertyType.getDesc().setEs("Spanish property description");
        propertyType.getDesc().setEt("Estonian property description");
        propertyType.getDesc().setFa("Farsi property description");
        propertyType.getDesc().setFi("Finnish property description");
        propertyType.getDesc().setFr("French property description");
        propertyType.getDesc().setHe("Hebrew property description");
        propertyType.getDesc().setHi("Hindi property description");
        propertyType.getDesc().setHu("Hungarian property description");
        propertyType.getDesc().setId("Indonesian property description");
        propertyType.getDesc().setIt("Italian property description");
        propertyType.getDesc().setJa("Japanese property description");
        propertyType.getDesc().setKo("Korean property description");
        propertyType.getDesc().setLt("Lithuanian property description");
        propertyType.getDesc().setLv("Latvian property description");
        propertyType.getDesc().setNl("Dutch property description");
        propertyType.getDesc().setNo("Norwegian property description");
        propertyType.getDesc().setPl("Polish property description");
        propertyType.getDesc().setPt("Portuguese property description");
        propertyType.getDesc().setRo("Romanian property description");
        propertyType.getDesc().setRu("Russian property description");
        propertyType.getDesc().setSk("Slovak property description");
        propertyType.getDesc().setSl("Slovenian property description");
        propertyType.getDesc().setSv("Swedish property description");
        propertyType.getDesc().setTh("Thai property description");
        propertyType.getDesc().setTr("Turkish property description");
        propertyType.getDesc().setUk("Ukranian property description");
        propertyType.getDesc().setVi("Vietnamese property description");
        propertyType.getDesc().setZh("Simplified Chinese property description");
        propertyType.setEnergyRating(FACTORY.createEnergyRatingType());
        propertyType.getEnergyRating().setConsumption(EnergyRatingMarkType.C);
        propertyType.getEnergyRating().setEmissions(EnergyRatingMarkType.E);
        propertyType.setFeatures(FACTORY.createFeaturesType());
        propertyType.getFeatures().getFeature().add("name of a feature");
        propertyType.getFeatures().getFeature().add("name of another feature");
        propertyType.setImages(FACTORY.createImagesType());
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.setLocation(FACTORY.createGpsLocationType());
        propertyType.getLocation().setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        propertyType.getLocation().setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        propertyType.setSurfaceArea(FACTORY.createSurfaceType());
        propertyType.getSurfaceArea().setBuilt(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)250L)));
        propertyType.getSurfaceArea().setPlot(BigInteger.valueOf(RandomUtils.nextLong((long)100L, (long)1500L)));
        propertyType.setUrl(FACTORY.createUrlType());
        try {
            propertyType.getUrl().setAr(new URL("http://arabic.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setBg(new URL("http://bulgarian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setCa(new URL("http://catalan.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setCs(new URL("http://czech.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setDa(new URL("http://danish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setDe(new URL("http://german.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEl(new URL("http://greek.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEn(new URL("http://english.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEs(new URL("http://spanish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEt(new URL("http://estonian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setFa(new URL("http://farsi.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setFi(new URL("http://finnish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setFr(new URL("http://french.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setHe(new URL("http://hebrew.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setHi(new URL("http://hindi.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setHu(new URL("http://hungarian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setId(new URL("http://indonesian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setIt(new URL("http://italian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setJa(new URL("http://japanese.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setKo(new URL("http://korean.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setLt(new URL("http://lithunain.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setLv(new URL("http://latvian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setNl(new URL("http://dutch.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setNo(new URL("http://norwegian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setPl(new URL("http://polish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setPt(new URL("http://portuguese.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setRo(new URL("http://romanian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setRu(new URL("http://russian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setSk(new URL("http://slovak.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setSl(new URL("http://slovenian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setSv(new URL("http://swedish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setTh(new URL("http://thai.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setTr(new URL("http://turkish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setUk(new URL("http://ukranian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setVi(new URL("http://vietnamese.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setZh(new URL("http://chinese_simplified.website.com/property/" + string + ".htm"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return propertyType;
    }

    protected static ImagesType.Image createPropertyImage(String string, int n) {
        ImagesType.Image image = FACTORY.createImagesTypeImage();
        image.setId(Integer.valueOf(n));
        try {
            image.setUrl(new URL("http://website.com/property/" + string + "/image_" + n + ".jpg"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        image.setTitle(FACTORY.createLangType());
        image.getTitle().setAr("Arabic image title");
        image.getTitle().setBg("Bulgarian image title");
        image.getTitle().setCa("Catalan image title");
        image.getTitle().setCs("Czech image title");
        image.getTitle().setDa("Danish image title");
        image.getTitle().setDe("German image title");
        image.getTitle().setEl("Greek image title");
        image.getTitle().setEn("English image title");
        image.getTitle().setEs("Spanish image title");
        image.getTitle().setEt("Estonian image title");
        image.getTitle().setFa("Farsi image title");
        image.getTitle().setFi("Finnish image title");
        image.getTitle().setFr("French image title");
        image.getTitle().setHe("Hebrew image title");
        image.getTitle().setHi("Hindi image title");
        image.getTitle().setHu("Hungarian image title");
        image.getTitle().setId("Indonesian image title");
        image.getTitle().setIt("Italian image title");
        image.getTitle().setJa("Japanese image title");
        image.getTitle().setKo("Korean image title");
        image.getTitle().setLt("Lithuanian image title");
        image.getTitle().setLv("Latvian image title");
        image.getTitle().setNl("Dutch image title");
        image.getTitle().setNo("Norwegian image title");
        image.getTitle().setPl("Polish image title");
        image.getTitle().setPt("Portuguese image title");
        image.getTitle().setRo("Romanian image title");
        image.getTitle().setRu("Russian image title");
        image.getTitle().setSk("Slovak image title");
        image.getTitle().setSl("Slovenian image title");
        image.getTitle().setSv("Swedish image title");
        image.getTitle().setTh("Thai image title");
        image.getTitle().setTr("Turkish image title");
        image.getTitle().setUk("Ukranian image title");
        image.getTitle().setVi("Vietnamese image title");
        image.getTitle().setZh("Simplified Chinese image title");
        return image;
    }

    protected static void write(KyeroDocument kyeroDocument, File file) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(KyeroDocument kyeroDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(KyeroDocument kyeroDocument, Writer writer) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(KyeroDocument kyeroDocument) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            String string = kyeroDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

