/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.Aktion;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Haus;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.ObjectFactory;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.Uebertragung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenImmoWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = OpenImmoUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)OpenImmoWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Openimmo openimmo = FACTORY.createOpenimmo();
        openimmo.setUebertragung(OpenImmoWritingExample.createUebertragung());
        openimmo.getAnbieter().add(OpenImmoWritingExample.createAnbieter());
        OpenImmoTransferDocument openImmoTransferDocument = null;
        try {
            openImmoTransferDocument = OpenImmoTransferDocument.newDocument((Openimmo)openimmo);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            OpenImmoWritingExample.write(openImmoTransferDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        OpenImmoWritingExample.write(openImmoTransferDocument, (OutputStream)new NullOutputStream());
        OpenImmoWritingExample.write(openImmoTransferDocument, (Writer)new NullWriter());
        OpenImmoWritingExample.writeToConsole(openImmoTransferDocument);
        openImmoTransferDocument.downgrade((XmlVersion)OpenImmoVersion.V1_2_3);
        OpenImmoWritingExample.writeToConsole(openImmoTransferDocument);
        openImmoTransferDocument.downgrade((XmlVersion)OpenImmoVersion.V1_1);
        OpenImmoWritingExample.writeToConsole(openImmoTransferDocument);
    }

    protected static Anbieter createAnbieter() {
        Anbieter anbieter = FACTORY.createAnbieter();
        anbieter.setAnbieternr("123456");
        anbieter.setFirma("Agency Name");
        anbieter.setOpenimmoAnid("123456");
        anbieter.getImmobilie().add(OpenImmoWritingExample.createImmobilie());
        anbieter.getImmobilie().add(OpenImmoWritingExample.createImmobilie());
        return anbieter;
    }

    protected static Immobilie createImmobilie() {
        Immobilie immobilie = FACTORY.createImmobilie();
        immobilie.setVerwaltungTechn(FACTORY.createVerwaltungTechn());
        immobilie.getVerwaltungTechn().setAktion(FACTORY.createAktion());
        immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
        immobilie.getVerwaltungTechn().setObjektnrIntern(RandomStringUtils.randomNumeric((int)10));
        immobilie.setObjektkategorie(FACTORY.createObjektkategorie());
        immobilie.getObjektkategorie().setNutzungsart(FACTORY.createNutzungsart());
        immobilie.getObjektkategorie().getNutzungsart().setANLAGE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().getNutzungsart().setGEWERBE(RandomUtils.nextInt((int)0, (int)2) == 1);
        immobilie.getObjektkategorie().getNutzungsart().setWAZ(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().getNutzungsart().setWOHNEN(RandomUtils.nextInt((int)0, (int)2) == 1);
        immobilie.getObjektkategorie().setVermarktungsart(FACTORY.createVermarktungsart());
        immobilie.getObjektkategorie().getVermarktungsart().setKAUF(true);
        immobilie.getObjektkategorie().setObjektart(FACTORY.createObjektart());
        Haus haus = FACTORY.createHaus();
        haus.setHaustyp(Haus.Haustyp.EINFAMILIENHAUS);
        immobilie.getObjektkategorie().getObjektart().getHaus().add(haus);
        immobilie.setGeo(FACTORY.createGeo());
        immobilie.getGeo().setPlz(RandomStringUtils.randomNumeric((int)5));
        immobilie.getGeo().setOrt("Berlin");
        immobilie.getGeo().setLand(FACTORY.createLand());
        immobilie.getGeo().getLand().setIsoLand(Locale.GERMANY.getISO3Country());
        immobilie.setPreise(FACTORY.createPreise());
        immobilie.getPreise().setHeizkosten(new BigDecimal("456.0"));
        immobilie.getPreise().setKaufpreis(FACTORY.createKaufpreis());
        immobilie.getPreise().getKaufpreis().setAufAnfrage(Boolean.valueOf(false));
        immobilie.getPreise().getKaufpreis().setValue(new BigDecimal("123456.79"));
        immobilie.setAusstattung(FACTORY.createAusstattung());
        immobilie.getAusstattung().setGaestewc(Boolean.valueOf(true));
        immobilie.getAusstattung().setGartennutzung(Boolean.valueOf(true));
        immobilie.getAusstattung().setHeizungsart(FACTORY.createHeizungsart());
        immobilie.getAusstattung().getHeizungsart().setZENTRAL(Boolean.valueOf(true));
        immobilie.getAusstattung().getHeizungsart().setFUSSBODEN(Boolean.valueOf(true));
        immobilie.setFreitexte(FACTORY.createFreitexte());
        immobilie.getFreitexte().setObjekttitel("A title for the property.");
        immobilie.getFreitexte().setObjektbeschreibung("Some longer descriptive text about the property.");
        immobilie.setKontaktperson(FACTORY.createKontaktperson());
        immobilie.getKontaktperson().setName("Max Mustermann");
        immobilie.getKontaktperson().setEmailFeedback("max@mustermann.org");
        immobilie.getKontaktperson().setTelDurchw("030/123456789");
        immobilie.getKontaktperson().setPlz(RandomStringUtils.randomNumeric((int)5));
        immobilie.getKontaktperson().setOrt("Berlin");
        immobilie.getKontaktperson().setLand(FACTORY.createLand());
        immobilie.getKontaktperson().getLand().setIsoLand(Locale.GERMANY.getISO3Country());
        return immobilie;
    }

    protected static Uebertragung createUebertragung() {
        Uebertragung uebertragung = FACTORY.createUebertragung();
        uebertragung.setArt(Uebertragung.Art.OFFLINE);
        uebertragung.setModus(Uebertragung.Modus.NEW);
        uebertragung.setSendersoftware("OpenEstate-IO");
        uebertragung.setSenderversion("1.1");
        uebertragung.setTechnEmail("test@test.org");
        uebertragung.setTimestamp(Calendar.getInstance());
        uebertragung.setUmfang(Uebertragung.Umfang.VOLL);
        return uebertragung;
    }

    protected static void write(OpenImmoTransferDocument openImmoTransferDocument, File file) {
        LOGGER.info("writing document with version " + openImmoTransferDocument.getDocumentVersion());
        try {
            openImmoTransferDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(OpenImmoTransferDocument openImmoTransferDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + openImmoTransferDocument.getDocumentVersion());
        try {
            openImmoTransferDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(OpenImmoTransferDocument openImmoTransferDocument, Writer writer) {
        LOGGER.info("writing document with version " + openImmoTransferDocument.getDocumentVersion());
        try {
            openImmoTransferDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(OpenImmoTransferDocument openImmoTransferDocument) {
        LOGGER.info("writing document with version " + openImmoTransferDocument.getDocumentVersion());
        try {
            String string = openImmoTransferDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

