/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.Ad;
import org.openestate.io.trovit.xml.ObjectFactory;
import org.openestate.io.trovit.xml.Picture;
import org.openestate.io.trovit.xml.Trovit;
import org.openestate.io.trovit.xml.TypeNew;
import org.openestate.io.trovit.xml.types.Action;
import org.openestate.io.trovit.xml.types.IntBool;
import org.openestate.io.trovit.xml.types.PriceInterval;
import org.openestate.io.trovit.xml.types.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrovitWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = TrovitUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)TrovitWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Trovit trovit = FACTORY.createTrovit();
        trovit.getAd().add(TrovitWritingExample.createAd());
        trovit.getAd().add(TrovitWritingExample.createAd());
        trovit.getAd().add(TrovitWritingExample.createAd());
        TrovitDocument trovitDocument = null;
        try {
            trovitDocument = TrovitDocument.newDocument((Trovit)trovit);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            TrovitWritingExample.write(trovitDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        TrovitWritingExample.write(trovitDocument, (OutputStream)new NullOutputStream());
        TrovitWritingExample.write(trovitDocument, (Writer)new NullWriter());
        TrovitWritingExample.writeToConsole(trovitDocument);
    }

    protected static Ad createAd() {
        Ad ad = FACTORY.createAd();
        ad.setAddress("object address");
        ad.setAgency("name of the agency");
        ad.setBathrooms(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)5.0)));
        ad.setCity("name of the city");
        ad.setCityArea("name of the district");
        ad.setCondition("some notes about the condition");
        ad.setContent("some more descriptions");
        ad.setDate(Calendar.getInstance());
        ad.setExpirationDate(Calendar.getInstance());
        ad.setFloorNumber("number of floors");
        ad.setForeclosure("notes about foreclosure");
        ad.setId(RandomStringUtils.randomAlphanumeric((int)5));
        ad.setIsFurnished(new IntBool(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1)));
        ad.setIsNew(TypeNew.NEW);
        ad.setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        ad.setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        ad.setMlsDatabase("notes about mls database");
        ad.setOrientation("notes about orientation");
        ad.setParking(new IntBool(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1)));
        ad.setPlotArea(BigInteger.valueOf(RandomUtils.nextInt((int)100, (int)5000)));
        ad.setPostcode("postcode");
        ad.setPropertyType("notes about the property type");
        ad.setRegion("notes about the region");
        ad.setRooms(BigDecimal.valueOf(RandomUtils.nextDouble((double)1.0, (double)10.0)));
        ad.setTime(Calendar.getInstance());
        ad.setTitle("title of the object");
        ad.setType(Action.FOR_RENT);
        ad.setUrl("http://mywebsite.org/");
        ad.setVirtualTour("notes about virtual tour");
        ad.setYear(Integer.valueOf(RandomUtils.nextInt((int)1990, (int)2010)));
        ad.setFloorArea(FACTORY.createFloorArea());
        ad.getFloorArea().setUnit(Unit.METERS);
        ad.getFloorArea().setValue(BigInteger.valueOf(RandomUtils.nextInt((int)10, (int)10000)));
        ad.setPictures(FACTORY.createPictures());
        ad.getPictures().getPicture().add(TrovitWritingExample.createPicture());
        ad.getPictures().getPicture().add(TrovitWritingExample.createPicture());
        ad.getPictures().getPicture().add(TrovitWritingExample.createPicture());
        ad.setPrice(FACTORY.createPrice());
        ad.getPrice().setPeriod(PriceInterval.MONTHLY);
        ad.getPrice().setValue(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)2000.0)));
        return ad;
    }

    protected static Picture createPicture() {
        Picture picture = FACTORY.createPicture();
        picture.setPictureTitle("some descriptive title");
        picture.setPictureUrl("http://mywebsite.org/image" + RandomStringUtils.randomNumeric((int)5) + ".jpg");
        return picture;
    }

    protected static void write(TrovitDocument trovitDocument, File file) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(TrovitDocument trovitDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(TrovitDocument trovitDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            trovitDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(TrovitDocument trovitDocument) {
        LOGGER.info("writing document");
        try {
            String string = trovitDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

