/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.wis_it.WisItDocument;
import org.openestate.io.wis_it.WisItUtils;
import org.openestate.io.wis_it.xml.ObjectType;
import org.openestate.io.wis_it.xml.WIS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class WisItReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisItReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)WisItReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                WisItReadingExample.read(WisItReadingExample.class.getResourceAsStream("/org/openestate/io/examples/wis_it.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    WisItReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        WisItDocument wisItDocument = WisItUtils.createDocument((File)file);
        if (wisItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            WisItReadingExample.printToConsole(wisItDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        WisItDocument wisItDocument = WisItUtils.createDocument((InputStream)inputStream);
        if (wisItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            WisItReadingExample.printToConsole(wisItDocument);
        }
    }

    protected static void printToConsole(WisItDocument wisItDocument) throws JAXBException {
        WIS wIS = wisItDocument.toObject();
        if (wIS.getOBJEKTE() != null) {
            for (ObjectType objectType : wIS.getOBJEKTE().getOBJEKT()) {
                String string;
                String string2 = StringUtils.trimToNull((String)objectType.getID());
                if (string2 == null) {
                    string2 = "???";
                }
                if ((string = StringUtils.trimToNull((String)objectType.getINFODE())) == null) {
                    string = objectType.getINFOIT();
                }
                if (string == null) {
                    string = "???";
                }
                LOGGER.info("> found object '" + string2 + "' " + "with title '" + string + "'");
            }
        }
    }
}

