/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.wis_it.WisItDocument;
import org.openestate.io.wis_it.WisItUtils;
import org.openestate.io.wis_it.xml.AreaType;
import org.openestate.io.wis_it.xml.ConditionType;
import org.openestate.io.wis_it.xml.EnergyStandard;
import org.openestate.io.wis_it.xml.HeatingType;
import org.openestate.io.wis_it.xml.MarketingType;
import org.openestate.io.wis_it.xml.ObjectFactory;
import org.openestate.io.wis_it.xml.ObjectType;
import org.openestate.io.wis_it.xml.PropertyType;
import org.openestate.io.wis_it.xml.WIS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WisItWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisItWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = WisItUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)WisItWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        WIS wIS = FACTORY.createWIS();
        wIS.setBENUTZER(FACTORY.createWISBENUTZER());
        wIS.setOBJEKTE(FACTORY.createWISOBJEKTE());
        wIS.getOBJEKTE().getOBJEKT().add(WisItWritingExample.createOBJEKT());
        wIS.getOBJEKTE().getOBJEKT().add(WisItWritingExample.createOBJEKT());
        wIS.getOBJEKTE().getOBJEKT().add(WisItWritingExample.createOBJEKT());
        wIS.getOBJEKTE().setANZAHL(BigInteger.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        WisItDocument wisItDocument = null;
        try {
            wisItDocument = WisItDocument.newDocument((WIS)wIS);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            WisItWritingExample.write(wisItDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        WisItWritingExample.write(wisItDocument, (OutputStream)new NullOutputStream());
        WisItWritingExample.write(wisItDocument, (Writer)new NullWriter());
        WisItWritingExample.writeToConsole(wisItDocument);
    }

    protected static ObjectType createOBJEKT() {
        ObjectType objectType = FACTORY.createObjectType();
        objectType.setABSTELLPLATZ(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setAUFANFRAGE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setAUFZUG(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setBALKON(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setBAUJAHR(String.valueOf(RandomUtils.nextInt((int)1900, (int)2015)));
        objectType.setDACHBODEN(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setFLAECHEART(AreaType.NETTO);
        objectType.setFOERDERBAR(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setFRAKTION("some notes about the fraction");
        objectType.setGARAGE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setGRUENFLAECHE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setGUELTIGBIS(Calendar.getInstance());
        objectType.setHEIZUNG(HeatingType.ZENTRAL);
        objectType.setID(RandomStringUtils.randomAlphanumeric((int)5));
        objectType.setIMMOBILIENART(PropertyType.EINFAMILIENHAUS);
        objectType.setINFODE("some description in german language");
        objectType.setINFOIT("some description in italian language");
        objectType.setKELLER(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setKLIMAHAUS(EnergyStandard.A);
        objectType.setKONVENTIONIERT(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setKUBATUR(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)1000.0)));
        objectType.setLOESCHEN(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setLOGGIA(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setMIETEKAUF(MarketingType.MIETE);
        objectType.setNUTZFLAECHE(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)1000.0)));
        objectType.setORT("Bozen");
        objectType.setPREIS(BigDecimal.valueOf(RandomUtils.nextDouble((double)300.0, (double)3000.0)));
        objectType.setSTOCKWERK(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)5)));
        objectType.setSTOCKWERKE(BigInteger.valueOf(RandomUtils.nextInt((int)0, (int)10)));
        objectType.setTERRASSE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        objectType.setUEBERGABEZEITPUNKT("some notes about the time of handover");
        objectType.setZIMMER(BigInteger.valueOf(RandomUtils.nextInt((int)1, (int)5)));
        objectType.setZUSTAND(ConditionType.GEBRAUCHT);
        objectType.setBILD1(objectType.getID() + "_1.jpg");
        objectType.setBILD2(objectType.getID() + "_2.jpg");
        objectType.setBILD3(objectType.getID() + "_3.jpg");
        objectType.setBILD4(objectType.getID() + "_4.jpg");
        objectType.setBILD5(objectType.getID() + "_5.jpg");
        objectType.setBILD6(objectType.getID() + "_6.jpg");
        objectType.setBILD7(objectType.getID() + "_7.jpg");
        objectType.setBILD8(objectType.getID() + "_8.jpg");
        objectType.setBILD9(objectType.getID() + "_9.jpg");
        objectType.setBILD10(objectType.getID() + "_10.jpg");
        objectType.setDOWNLOAD1(objectType.getID() + "_1.pdf");
        objectType.setDOWNLOAD2(objectType.getID() + "_2.pdf");
        objectType.setDOWNLOAD3(objectType.getID() + "_3.pdf");
        return objectType;
    }

    protected static void write(WisItDocument wisItDocument, File file) {
        LOGGER.info("writing document");
        try {
            wisItDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(WisItDocument wisItDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            wisItDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(WisItDocument wisItDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            wisItDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(WisItDocument wisItDocument) {
        LOGGER.info("writing document");
        try {
            String string = wisItDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

