/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.daft_ie.DaftIeDocument;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.xml.Daft;
import org.openestate.io.daft_ie.xml.OverseasRentalAdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DaftIeReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)DaftIeReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                DaftIeReadingExample.read(DaftIeReadingExample.class.getResourceAsStream("/org/openestate/io/examples/daft_ie.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    DaftIeReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        DaftIeDocument daftIeDocument = DaftIeUtils.createDocument((File)file);
        if (daftIeDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            DaftIeReadingExample.printToConsole(daftIeDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        DaftIeDocument daftIeDocument = DaftIeUtils.createDocument((InputStream)inputStream);
        if (daftIeDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            DaftIeReadingExample.printToConsole(daftIeDocument);
        }
    }

    protected static void printToConsole(DaftIeDocument daftIeDocument) throws JAXBException {
        String string;
        String string2;
        LOGGER.info("> process document in version " + daftIeDocument.getDocumentVersion());
        Daft daft = daftIeDocument.toObject();
        if (daft.getOverseasRental() != null) {
            for (OverseasRentalAdType overseasRentalAdType : daft.getOverseasRental().getOverseasRentalAd()) {
                string2 = StringUtils.trimToNull((String)overseasRentalAdType.getExternalId());
                if (string2 == null) {
                    string2 = "???";
                }
                if ((string = StringUtils.trimToNull((String)overseasRentalAdType.getDescription())) == null) {
                    string = "???";
                }
                LOGGER.info("> found object '" + string2 + "' for rent: " + string);
            }
        }
        if (daft.getOverseasSales() != null) {
            for (OverseasRentalAdType overseasRentalAdType : daft.getOverseasSales().getOverseasSaleAd()) {
                string2 = StringUtils.trimToNull((String)overseasRentalAdType.getExternalId());
                if (string2 == null) {
                    string2 = "???";
                }
                if ((string = StringUtils.trimToNull((String)overseasRentalAdType.getDescription())) == null) {
                    string = "???";
                }
                LOGGER.info("> found object '" + string2 + "' for sale: " + string);
            }
        }
    }
}

