/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.filemaker.FilemakerDocument;
import org.openestate.io.filemaker.FilemakerLayoutDocument;
import org.openestate.io.filemaker.FilemakerResultDocument;
import org.openestate.io.filemaker.FilemakerUtils;
import org.openestate.io.filemaker.xml.layout.FMPXMLLAYOUT;
import org.openestate.io.filemaker.xml.layout.ValueListsType;
import org.openestate.io.filemaker.xml.result.FMPXMLRESULT;
import org.openestate.io.filemaker.xml.result.MetaDataType;
import org.openestate.io.filemaker.xml.result.ResultSetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FilemakerReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilemakerReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)FilemakerReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                FilemakerReadingExample.read(FilemakerReadingExample.class.getResourceAsStream("/org/openestate/io/examples/filemaker-result.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example result file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
            try {
                FilemakerReadingExample.read(FilemakerReadingExample.class.getResourceAsStream("/org/openestate/io/examples/filemaker-layout.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example layout file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    FilemakerReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        FilemakerDocument filemakerDocument = FilemakerUtils.createDocument((File)file);
        if (filemakerDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else if (filemakerDocument.isResult()) {
            FilemakerReadingExample.printToConsole((FilemakerResultDocument)filemakerDocument);
        } else if (filemakerDocument.isLayout()) {
            FilemakerReadingExample.printToConsole((FilemakerLayoutDocument)filemakerDocument);
        } else {
            LOGGER.warn("> unsupported type of document: " + filemakerDocument.getClass().getName());
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        FilemakerDocument filemakerDocument = FilemakerUtils.createDocument((InputStream)inputStream);
        if (filemakerDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else if (filemakerDocument.isResult()) {
            FilemakerReadingExample.printToConsole((FilemakerResultDocument)filemakerDocument);
        } else if (filemakerDocument.isLayout()) {
            FilemakerReadingExample.printToConsole((FilemakerLayoutDocument)filemakerDocument);
        } else {
            LOGGER.warn("> unsupported type of document: " + filemakerDocument.getClass().getName());
        }
    }

    protected static void printToConsole(FilemakerLayoutDocument filemakerLayoutDocument) throws JAXBException {
        LOGGER.info("> process layout document");
        FMPXMLLAYOUT fMPXMLLAYOUT = filemakerLayoutDocument.toObject();
        LOGGER.info("> error code      : " + fMPXMLLAYOUT.getERRORCODE());
        if (fMPXMLLAYOUT.getPRODUCT() != null) {
            LOGGER.info("> product name    : " + fMPXMLLAYOUT.getPRODUCT().getNAME());
            LOGGER.info("> product version : " + fMPXMLLAYOUT.getPRODUCT().getVERSION());
            LOGGER.info("> product build   : " + fMPXMLLAYOUT.getPRODUCT().getBUILD());
        }
        if (fMPXMLLAYOUT.getLAYOUT() != null) {
            LOGGER.info("> database name   : " + fMPXMLLAYOUT.getLAYOUT().getDATABASE());
            LOGGER.info("> database layout : " + fMPXMLLAYOUT.getLAYOUT().getNAME());
            for (ValueListsType.VALUELIST vALUELIST : fMPXMLLAYOUT.getLAYOUT().getFIELD()) {
                LOGGER.info("> database field  : " + vALUELIST.getNAME() + " / " + vALUELIST.getSTYLE().getTYPE() + " / " + vALUELIST.getSTYLE().getVALUELIST());
            }
        }
        if (fMPXMLLAYOUT.getVALUELISTS() != null) {
            for (ValueListsType.VALUELIST vALUELIST : fMPXMLLAYOUT.getVALUELISTS().getVALUELIST()) {
                LOGGER.info("> database values : " + vALUELIST.getNAME());
                for (String string : vALUELIST.getVALUE()) {
                    LOGGER.info(">> " + string);
                }
            }
        }
    }

    protected static void printToConsole(FilemakerResultDocument filemakerResultDocument) throws JAXBException {
        LOGGER.info("> process result document");
        FMPXMLRESULT fMPXMLRESULT = filemakerResultDocument.toObject();
        LOGGER.info("> error code       : " + fMPXMLRESULT.getERRORCODE());
        if (fMPXMLRESULT.getPRODUCT() != null) {
            LOGGER.info("> product name     : " + fMPXMLRESULT.getPRODUCT().getNAME());
            LOGGER.info("> product version  : " + fMPXMLRESULT.getPRODUCT().getVERSION());
            LOGGER.info("> product build    : " + fMPXMLRESULT.getPRODUCT().getBUILD());
        }
        if (fMPXMLRESULT.getDATABASE() != null) {
            LOGGER.info("> database name    : " + fMPXMLRESULT.getDATABASE().getNAME());
            LOGGER.info("> database layout  : " + fMPXMLRESULT.getDATABASE().getLAYOUT());
            LOGGER.info("> database date    : " + fMPXMLRESULT.getDATABASE().getDATEFORMAT());
            LOGGER.info("> database time    : " + fMPXMLRESULT.getDATABASE().getTIMEFORMAT());
            LOGGER.info("> database records : " + fMPXMLRESULT.getDATABASE().getRECORDS());
        }
        if (fMPXMLRESULT.getMETADATA() != null) {
            for (MetaDataType.FIELD fIELD : fMPXMLRESULT.getMETADATA().getFIELD()) {
                LOGGER.info("> database field   : " + fIELD.getNAME());
                LOGGER.info(">> type : " + fIELD.getTYPE());
                LOGGER.info(">> max repeat : " + fIELD.getMAXREPEAT());
            }
        }
        if (fMPXMLRESULT.getRESULTSET() != null) {
            LOGGER.info("> resultset found  : " + fMPXMLRESULT.getRESULTSET().getFOUND());
            for (MetaDataType.FIELD fIELD : fMPXMLRESULT.getRESULTSET().getROW()) {
                LOGGER.info("> resultset row    : " + fIELD.getRECORDID() + " / " + fIELD.getMODID());
                for (ResultSetType.ROW.COL cOL : fIELD.getCOL()) {
                    for (String string : cOL.getDATA()) {
                        LOGGER.info(">> " + string);
                    }
                }
            }
        }
    }
}

