/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.idx.IdxParser;
import org.openestate.io.idx.IdxRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)IdxReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                IdxReadingExample.read(IdxReadingExample.class.getResourceAsStream("/org/openestate/io/examples/idx.csv"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    IdxReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws IOException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> The provided file is invalid!");
            return;
        }
        IdxParser idxParser = null;
        try {
            idxParser = IdxParser.create((File)file);
            if (idxParser == null) {
                LOGGER.warn("> Can't create parser!");
            } else {
                IdxReadingExample.printToConsole(idxParser);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)idxParser);
        }
    }

    protected static void read(InputStream inputStream) throws IOException {
        LOGGER.info("process example file");
        IdxParser idxParser = null;
        try {
            idxParser = IdxParser.create((InputStream)inputStream);
            if (idxParser == null) {
                LOGGER.warn("> Can't create parser!");
            } else {
                IdxReadingExample.printToConsole(idxParser);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)idxParser);
        }
    }

    protected static void printToConsole(IdxParser idxParser) {
        while (idxParser.hasNext()) {
            String string;
            IdxRecord idxRecord = (IdxRecord)idxParser.next();
            String string2 = idxRecord.getRefObject();
            if (string2 == null) {
                string2 = "???";
            }
            if ((string = idxRecord.getObjectTitle()) == null) {
                string = "???";
            }
            System.out.println("> found object '" + string2 + "' with title '" + string + "'");
        }
    }
}

