/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.Langtxt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImmobiliareItReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)ImmobiliareItReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                ImmobiliareItReadingExample.read(ImmobiliareItReadingExample.class.getResourceAsStream("/org/openestate/io/examples/immobiliare_it.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    ImmobiliareItReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        ImmobiliareItDocument immobiliareItDocument = ImmobiliareItUtils.createDocument((File)file);
        if (immobiliareItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            ImmobiliareItReadingExample.printToConsole(immobiliareItDocument);
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        ImmobiliareItDocument immobiliareItDocument = ImmobiliareItUtils.createDocument((InputStream)inputStream);
        if (immobiliareItDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else {
            ImmobiliareItReadingExample.printToConsole(immobiliareItDocument);
        }
    }

    protected static void printToConsole(ImmobiliareItDocument immobiliareItDocument) throws JAXBException {
        LOGGER.info("> process document in version " + immobiliareItDocument.getDocumentVersion());
        Feed feed = immobiliareItDocument.toObject();
        if (feed.getProperties() != null) {
            for (Feed.Properties.Property property : feed.getProperties().getProperty()) {
                String string;
                String string2 = StringUtils.trimToNull((String)property.getUniqueId());
                if (string2 == null) {
                    string2 = "???";
                }
                String string3 = string = property.getFeatures() != null && !property.getFeatures().getDescription().isEmpty() ? StringUtils.trimToNull((String)((Langtxt)property.getFeatures().getDescription().get(0)).getValue()) : null;
                if (string == null) {
                    string = "???";
                }
                LOGGER.info("> found object '" + string2 + "': " + string);
            }
        }
    }
}

