/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Box;
import org.openestate.io.immobiliare_it.xml.BusinessElement;
import org.openestate.io.immobiliare_it.xml.ClassEnergy;
import org.openestate.io.immobiliare_it.xml.Clazz;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.Floor;
import org.openestate.io.immobiliare_it.xml.Furniture;
import org.openestate.io.immobiliare_it.xml.Garden;
import org.openestate.io.immobiliare_it.xml.Heat;
import org.openestate.io.immobiliare_it.xml.Kitchen;
import org.openestate.io.immobiliare_it.xml.LocationStructure;
import org.openestate.io.immobiliare_it.xml.ObjectFactory;
import org.openestate.io.immobiliare_it.xml.Operation;
import org.openestate.io.immobiliare_it.xml.OwnershipType;
import org.openestate.io.immobiliare_it.xml.PictureExtended;
import org.openestate.io.immobiliare_it.xml.PictureProject;
import org.openestate.io.immobiliare_it.xml.PropertyType;
import org.openestate.io.immobiliare_it.xml.PropertyTypeBusiness;
import org.openestate.io.immobiliare_it.xml.PropertyTypeSimple;
import org.openestate.io.immobiliare_it.xml.Rental;
import org.openestate.io.immobiliare_it.xml.Status;
import org.openestate.io.immobiliare_it.xml.TerrainType;
import org.openestate.io.immobiliare_it.xml.VideoProject;
import org.openestate.io.immobiliare_it.xml.VideoType;
import org.openestate.io.immobiliare_it.xml.YesNoReady;
import org.openestate.io.immobiliare_it.xml.types.Category;
import org.openestate.io.immobiliare_it.xml.types.EnergyUnit;
import org.openestate.io.immobiliare_it.xml.types.LandSizeUnit;
import org.openestate.io.immobiliare_it.xml.types.SizeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmobiliareItWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = ImmobiliareItUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)ImmobiliareItWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Feed feed = FACTORY.createFeed();
        feed.setProperties(FACTORY.createFeedProperties());
        feed.getProperties().getProperty().add(ImmobiliareItWritingExample.createProperty());
        feed.getProperties().getProperty().add(ImmobiliareItWritingExample.createProperty());
        ImmobiliareItDocument immobiliareItDocument = null;
        try {
            immobiliareItDocument = ImmobiliareItDocument.newDocument((Feed)feed);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            ImmobiliareItWritingExample.write(immobiliareItDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        ImmobiliareItWritingExample.write(immobiliareItDocument, (OutputStream)new NullOutputStream());
        ImmobiliareItWritingExample.write(immobiliareItDocument, (Writer)new NullWriter());
        ImmobiliareItWritingExample.writeToConsole(immobiliareItDocument);
    }

    protected static Feed.Properties.Property createProperty() {
        Feed.Properties.Property property = FACTORY.createFeedPropertiesProperty();
        property.setBuildingStatus(Status.ABITABILE);
        property.setCategory(Category.COMMERCIALE);
        property.setDateExpiration(Calendar.getInstance());
        property.setDateUpdated(Calendar.getInstance());
        property.setOperation(Operation.WRITE);
        property.setUniqueId(RandomStringUtils.randomAlphanumeric((int)5));
        property.setAgent(FACTORY.createFeedPropertiesPropertyAgent());
        property.getAgent().setEmail("agency@test.org");
        property.getAgent().setOfficeName("agency name");
        property.setBlueprints(FACTORY.createFeedPropertiesPropertyBlueprints());
        property.getBlueprints().getBlueprint().add(ImmobiliareItWritingExample.createPictureExtended());
        property.getBlueprints().getBlueprint().add(ImmobiliareItWritingExample.createPictureExtended());
        property.getBlueprints().getBlueprint().add(ImmobiliareItWritingExample.createPictureExtended());
        property.setBuilding(FACTORY.createBuilding());
        property.getBuilding().setCategory(Category.COMMERCIALE);
        property.getBuilding().setClazz(Clazz.SIGNORILE);
        property.getBuilding().setDetail(PropertyTypeBusiness.ALBERGO);
        property.getBuilding().setStatus(Status.DISCRETO);
        property.getBuilding().setType(PropertyType.BUNGALOW);
        property.setExtraFeatures(FACTORY.createFeedPropertiesPropertyExtraFeatures());
        property.getExtraFeatures().setAirConditioning(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setBalcony(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setBathrooms(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        property.getExtraFeatures().setBeamHeight(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)10L)));
        property.getExtraFeatures().setBedrooms(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        property.getExtraFeatures().setBuildYear(Integer.valueOf(RandomUtils.nextInt((int)1900, (int)2000)));
        property.getExtraFeatures().setDocDescription("some descriptions");
        property.getExtraFeatures().setDocSpecification("some specifications");
        property.getExtraFeatures().setElevator(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setFloorplannerUrl("http://floorplanner-url.it/");
        property.getExtraFeatures().setFreeConditions("free conditions");
        property.getExtraFeatures().setFurniture(Furniture.PARZIALMENTE_ARREDATO);
        property.getExtraFeatures().setGarden(Garden.NESSUNO);
        property.getExtraFeatures().setHeating(Heat.AUTONOMO);
        property.getExtraFeatures().setKitchen(Kitchen.SEMI_ABITABILE);
        property.getExtraFeatures().setNet(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setNumFloors(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        property.getExtraFeatures().setOverheadCrane(YesNoReady.READY);
        property.getExtraFeatures().setReception(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setRentContract(Rental.LIBERO);
        property.getExtraFeatures().setSecurityAlarm(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setTerrace(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getExtraFeatures().setVirtualTour("virtual tour");
        property.getExtraFeatures().setAdditionalCosts(FACTORY.createAdditionalCostsType());
        property.getExtraFeatures().getAdditionalCosts().setCurrency(Currency.getInstance("EUR"));
        property.getExtraFeatures().getAdditionalCosts().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)5000L)));
        property.getExtraFeatures().setExternalArea(FACTORY.createLandSizeType());
        property.getExtraFeatures().getExternalArea().setUnit(LandSizeUnit.M2);
        property.getExtraFeatures().getExternalArea().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)5000L)));
        property.getExtraFeatures().setFloor(FACTORY.createFloor());
        property.getExtraFeatures().getFloor().setType(Floor.FloorType.INTERMEDIO);
        property.getExtraFeatures().getFloor().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)10L)));
        property.getExtraFeatures().setGarage(FACTORY.createBox());
        property.getExtraFeatures().getGarage().setType(Box.BoxType.POSTO_AUTO);
        property.getExtraFeatures().getGarage().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)10L)));
        property.getExtraFeatures().setOfficeSize(FACTORY.createSizeType());
        property.getExtraFeatures().getOfficeSize().setUnit(SizeUnit.M2);
        property.getExtraFeatures().getOfficeSize().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)5L, (long)50L)));
        property.setFeatures(FACTORY.createFeedPropertiesPropertyFeatures());
        property.getFeatures().setEnergyClass(ClassEnergy.D);
        property.getFeatures().setRooms(Integer.valueOf(RandomUtils.nextInt((int)1, (int)5)));
        property.getFeatures().setEnergyPerformance(FACTORY.createClassEnergyPerformance());
        property.getFeatures().getEnergyPerformance().setCertified(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getFeatures().getEnergyPerformance().setUnit(EnergyUnit.KWH_M2ANNO);
        property.getFeatures().getEnergyPerformance().setValue("energy performance");
        property.getFeatures().setPrice(FACTORY.createPriceType());
        property.getFeatures().getPrice().setCurrency(Currency.getInstance("EUR"));
        property.getFeatures().getPrice().setReserved(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getFeatures().getPrice().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)500L, (long)5000000L)));
        property.getFeatures().setSize(FACTORY.createSizeType());
        property.getFeatures().getSize().setUnit(SizeUnit.M2);
        property.getFeatures().getSize().setValue(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)5000L)));
        property.setLocation(FACTORY.createLocationStructure());
        property.getLocation().setAdministrativeArea("administrative area");
        property.getLocation().setCountryCode("DE");
        property.getLocation().setCity(FACTORY.createLocationStructureCity());
        property.getLocation().getCity().setCode(BigInteger.ZERO);
        property.getLocation().getCity().setValue("Berlin");
        property.getLocation().setLocality(FACTORY.createLocationStructureLocality());
        property.getLocation().getLocality().setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        property.getLocation().getLocality().setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        property.getLocation().getLocality().setPostalCode("13125");
        property.getLocation().getLocality().setNeighbourhood(FACTORY.createLocationStructureLocalityNeighbourhood());
        property.getLocation().getLocality().getNeighbourhood().setId(BigInteger.ZERO);
        property.getLocation().getLocality().getNeighbourhood().setType(LocationStructure.Locality.Neighbourhood.LocationNeighbourhoodType.DISTRICT);
        property.getLocation().getLocality().getNeighbourhood().setValue("about the neighbourhood");
        property.getLocation().getLocality().setThoroughfare(FACTORY.createLocationStructureLocalityThoroughfare());
        property.getLocation().getLocality().getThoroughfare().setDisplay(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getLocation().getLocality().getThoroughfare().setValue("about thoroughfare");
        property.getLocation().setSubAdministrativeArea(FACTORY.createLocationStructureSubAdministrativeArea());
        property.getLocation().getSubAdministrativeArea().setCode(RandomStringUtils.randomAlphanumeric((int)5));
        property.getLocation().getSubAdministrativeArea().setValue("Berlin");
        property.setPictures(FACTORY.createFeedPropertiesPropertyPictures());
        property.getPictures().getPictureUrlAndPicture().add(ImmobiliareItWritingExample.createPicture());
        property.getPictures().getPictureUrlAndPicture().add(ImmobiliareItWritingExample.createPicture());
        property.getPictures().getPictureUrlAndPicture().add(ImmobiliareItWritingExample.createPicture());
        property.setPropertyType(FACTORY.createProptype());
        property.getPropertyType().setBusinessType(FACTORY.createBusinessElement());
        property.getPropertyType().getBusinessType().setCategory(BusinessElement.BusinessElementCategory.IMMOBILE);
        property.getPropertyType().getBusinessType().setValue(PropertyTypeBusiness.ALTRO);
        property.getPropertyType().setTerrains(FACTORY.createTerrains());
        property.getPropertyType().getTerrains().getTerrain().add(TerrainType.SEMINATIVO);
        property.getPropertyType().setType(PropertyTypeSimple.CASA_INDIPENDENTE);
        property.setTransactionType(FACTORY.createTransactionType());
        property.getTransactionType().setAuction(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        property.getTransactionType().setOwnership(OwnershipType.PARZIALE);
        property.getTransactionType().setValue("notes about transaction");
        property.setVideos(FACTORY.createFeedPropertiesPropertyVideos());
        property.getVideos().getVideo().add(ImmobiliareItWritingExample.createVideo());
        property.getVideos().getVideo().add(ImmobiliareItWritingExample.createVideo());
        return property;
    }

    protected static PictureProject createPicture() {
        PictureProject pictureProject = FACTORY.createPictureProject();
        pictureProject.setPosition(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)100L)));
        pictureProject.setValue("image-" + RandomUtils.nextInt((int)0, (int)999) + ".jpg");
        return pictureProject;
    }

    protected static PictureExtended createPictureExtended() {
        PictureExtended pictureExtended = FACTORY.createPictureExtended();
        pictureExtended.setPosition(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)100L)));
        pictureExtended.setValue("image-" + RandomUtils.nextInt((int)0, (int)999) + ".jpg");
        pictureExtended.setUrl("http://mywebsite.org/" + pictureExtended.getValue());
        return pictureExtended;
    }

    protected static VideoProject createVideo() {
        VideoProject videoProject = FACTORY.createVideoProject();
        videoProject.setType(VideoType.LOCAL);
        videoProject.setValue("video-" + RandomUtils.nextInt((int)0, (int)999) + ".mp4");
        return videoProject;
    }

    protected static void write(ImmobiliareItDocument immobiliareItDocument, File file) {
        LOGGER.info("writing document with version " + immobiliareItDocument.getDocumentVersion());
        try {
            immobiliareItDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(ImmobiliareItDocument immobiliareItDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + immobiliareItDocument.getDocumentVersion());
        try {
            immobiliareItDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(ImmobiliareItDocument immobiliareItDocument, Writer writer) {
        LOGGER.info("writing document with version " + immobiliareItDocument.getDocumentVersion());
        try {
            immobiliareItDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(ImmobiliareItDocument immobiliareItDocument) {
        LOGGER.info("writing document with version " + immobiliareItDocument.getDocumentVersion());
        try {
            String string = immobiliareItDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

