/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.is24_csv.Is24CsvParser;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)Is24CsvReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                Is24CsvReadingExample.read(Is24CsvReadingExample.class.getResourceAsStream("/org/openestate/io/examples/is24.csv"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    Is24CsvReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws IOException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> The provided file is invalid!");
            return;
        }
        Is24CsvParser is24CsvParser = null;
        try {
            is24CsvParser = Is24CsvParser.create((File)file);
            if (is24CsvParser == null) {
                LOGGER.warn("> Can't create parser!");
            } else {
                Is24CsvReadingExample.printToConsole(is24CsvParser);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)is24CsvParser);
        }
    }

    protected static void read(InputStream inputStream) throws IOException {
        LOGGER.info("process example file");
        Is24CsvParser is24CsvParser = null;
        try {
            is24CsvParser = Is24CsvParser.create((InputStream)inputStream);
            if (is24CsvParser == null) {
                LOGGER.warn("> Can't create parser!");
            } else {
                Is24CsvReadingExample.printToConsole(is24CsvParser);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)is24CsvParser);
        }
    }

    protected static void printToConsole(Is24CsvParser is24CsvParser) {
        while (is24CsvParser.hasNext()) {
            String string;
            Is24CsvRecord is24CsvRecord = (Is24CsvRecord)is24CsvParser.next();
            String string2 = is24CsvRecord.getAnbieterObjektId();
            if (string2 == null) {
                string2 = "???";
            }
            if ((string = is24CsvRecord.getUeberschrift()) == null) {
                string = "???";
            }
            LOGGER.info("> found object '" + string2 + "' with title '" + string + "'");
        }
    }
}

