/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.AktionsTyp;
import org.openestate.io.is24_xml.xml.ApiSuchfelderTyp;
import org.openestate.io.is24_xml.xml.AusstattungsqualitaetsTyp;
import org.openestate.io.is24_xml.xml.BauphaseTyp;
import org.openestate.io.is24_xml.xml.EnergieausweistypTyp;
import org.openestate.io.is24_xml.xml.GenehmigungTyp;
import org.openestate.io.is24_xml.xml.HausKategorienTyp;
import org.openestate.io.is24_xml.xml.HausKauf;
import org.openestate.io.is24_xml.xml.HausMiete;
import org.openestate.io.is24_xml.xml.HeizungsartTyp;
import org.openestate.io.is24_xml.xml.ISOLaenderCodeTyp;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.openestate.io.is24_xml.xml.ObjectFactory;
import org.openestate.io.is24_xml.xml.ObjektZustandTyp;
import org.openestate.io.is24_xml.xml.StatusTyp;
import org.openestate.io.is24_xml.xml.StellplatzKategorieTyp;
import org.openestate.io.is24_xml.xml.WaehrungTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24XmlWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = Is24XmlUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)Is24XmlWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        ImmobilienTransferTyp immobilienTransferTyp = FACTORY.createImmobilienTransferTyp();
        immobilienTransferTyp.setEmailBeiFehler("test@test.org");
        immobilienTransferTyp.setErstellerSoftware("OpenEstate-IO");
        immobilienTransferTyp.setErstellerSoftwareVersion("1.2");
        immobilienTransferTyp.setAnbieter(Is24XmlWritingExample.createAnbieter());
        Is24XmlDocument is24XmlDocument = null;
        try {
            is24XmlDocument = Is24XmlDocument.newDocument((ImmobilienTransferTyp)immobilienTransferTyp);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            Is24XmlWritingExample.write(is24XmlDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        Is24XmlWritingExample.write(is24XmlDocument, (OutputStream)new NullOutputStream());
        Is24XmlWritingExample.write(is24XmlDocument, (Writer)new NullWriter());
        Is24XmlWritingExample.writeToConsole(is24XmlDocument);
    }

    protected static ImmobilienTransferTyp.Anbieter createAnbieter() {
        ImmobilienTransferTyp.Anbieter anbieter = FACTORY.createImmobilienTransferTypAnbieter();
        anbieter.setScoutKundenID("123456");
        anbieter.getImmobilie().add(Is24XmlWritingExample.createImmobilieHausKauf());
        anbieter.getImmobilie().add(Is24XmlWritingExample.createImmobilieHausKauf());
        anbieter.getImmobilie().add(Is24XmlWritingExample.createImmobilieHausMiete());
        anbieter.getImmobilie().add(Is24XmlWritingExample.createImmobilieHausMiete());
        return anbieter;
    }

    protected static HausKauf createImmobilieHausKauf() {
        HausKauf.Type type = FACTORY.createHausKaufType();
        Is24XmlWritingExample.initImmobilie((ImmobilieBaseTyp)type);
        type.setAlsFerienwohnungGeeignet(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setAnzahlBadezimmer(Long.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        type.setAnzahlGaragenStellplaetze(Long.valueOf(RandomUtils.nextLong((long)0L, (long)3L)));
        type.setAnzahlSchlafzimmer(Long.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        type.setAusstattungsqualitaet(AusstattungsqualitaetsTyp.LUXUS);
        type.setBarrierefrei(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setBaujahr(Long.valueOf(RandomUtils.nextLong((long)1900L, (long)2010L)));
        type.setBauphase(BauphaseTyp.HAUS_FERTIG_GESTELLT);
        type.setDenkmalschutzobjekt(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setEtagenzahl(Long.valueOf(RandomUtils.nextLong((long)1L, (long)10L)));
        type.setFreiAb("notes about availability");
        type.setGaesteWC(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setGrundstuecksFlaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)1500.0)));
        type.setHausKategorie(HausKategorienTyp.MEHRFAMILIENHAUS);
        type.setHeizungsart(HeizungsartTyp.ETAGENHEIZUNG);
        type.setJahrLetzteModernisierung(Long.valueOf(RandomUtils.nextLong((long)1980L, (long)2000L)));
        type.setKeller(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setMitEinliegerwohnung(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setNutzflaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)1000.0)));
        type.setObjektzustand(ObjektZustandTyp.NEUWERTIG);
        type.setParkplatz(StellplatzKategorieTyp.TIEFGARAGE);
        type.setRollstuhlgerecht(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setVermietet(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setWohnflaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)500.0)));
        type.setZimmer(BigDecimal.valueOf(RandomUtils.nextDouble((double)1.0, (double)10.0)));
        type.setBefeuerungsArt(FACTORY.createBefeuerungsArtTyp());
        type.getBefeuerungsArt().setOel(FACTORY.createBefeuerungsArtTypOel((Object)Boolean.TRUE));
        type.getBefeuerungsArt().setGas(FACTORY.createBefeuerungsArtTypGas((Object)Boolean.TRUE));
        type.setEnergieausweis(FACTORY.createEnergieausweisTyp());
        type.getEnergieausweis().setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
        type.getEnergieausweis().setEnergieverbrauchskennwert(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)500.0)));
        type.getEnergieausweis().setWarmwasserEnthalten(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setKaufpreise(FACTORY.createVermarktungWohnKaufTyp());
        type.getKaufpreise().setKaufpreis(BigDecimal.valueOf(RandomUtils.nextDouble((double)100000.0, (double)9999999.0)));
        type.getKaufpreise().setMieteinnahmenProMonat(BigDecimal.valueOf(RandomUtils.nextDouble((double)5000.0, (double)50000.0)));
        type.getKaufpreise().setStellplatzKaufpreis(BigDecimal.valueOf(RandomUtils.nextDouble((double)1000.0, (double)10000.0)));
        type.getKaufpreise().setWohngeld(BigDecimal.valueOf(RandomUtils.nextDouble((double)500.0, (double)5000.0)));
        return FACTORY.createHausKauf(type);
    }

    protected static HausMiete createImmobilieHausMiete() {
        HausMiete.Type type = FACTORY.createHausMieteType();
        Is24XmlWritingExample.initImmobilie((ImmobilieBaseTyp)type);
        type.setAnzahlBadezimmer(Long.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        type.setAnzahlGaragenStellplaetze(Long.valueOf(RandomUtils.nextLong((long)0L, (long)3L)));
        type.setAnzahlSchlafzimmer(Long.valueOf(RandomUtils.nextLong((long)1L, (long)5L)));
        type.setAusstattungsqualitaet(AusstattungsqualitaetsTyp.GEHOBEN);
        type.setBarrierefrei(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setBaujahr(Long.valueOf(RandomUtils.nextLong((long)1900L, (long)2010L)));
        type.setBetreutesWohnen(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setEinbaukueche(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setEtagenzahl(Long.valueOf(RandomUtils.nextLong((long)1L, (long)10L)));
        type.setFreiAb("notes about availability");
        type.setGaesteWC(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setGrundstuecksFlaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)1500.0)));
        type.setHausKategorie(HausKategorienTyp.EINFAMILIENHAUS);
        type.setHaustiere(GenehmigungTyp.NACH_VEREINBARUNG);
        type.setHeizungsart(HeizungsartTyp.ZENTRALHEIZUNG);
        type.setJahrLetzteModernisierung(Long.valueOf(RandomUtils.nextLong((long)1980L, (long)2000L)));
        type.setKeller(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setNutzflaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)150.0, (double)500.0)));
        type.setObjektzustand(ObjektZustandTyp.GEPFLEGT);
        type.setParkplatz(StellplatzKategorieTyp.CARPORT);
        type.setRollstuhlgerecht(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setWohnflaeche(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)300.0)));
        type.setZimmer(BigDecimal.valueOf(RandomUtils.nextDouble((double)1.0, (double)5.0)));
        type.setBefeuerungsArt(FACTORY.createBefeuerungsArtTyp());
        type.getBefeuerungsArt().setErdwaerme(FACTORY.createBefeuerungsArtTypErdwaerme((Object)Boolean.TRUE));
        type.getBefeuerungsArt().setPelletheizung(FACTORY.createBefeuerungsArtTypPelletheizung((Object)Boolean.TRUE));
        type.setEnergieausweis(FACTORY.createEnergieausweisTyp());
        type.getEnergieausweis().setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
        type.getEnergieausweis().setEnergieverbrauchskennwert(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)500.0)));
        type.getEnergieausweis().setWarmwasserEnthalten(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.setMietpreise(FACTORY.createVermarktungWohnMieteTyp());
        type.getMietpreise().setHeizkosten(BigDecimal.valueOf(RandomUtils.nextDouble((double)100.0, (double)500.0)));
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        type.getMietpreise().setKaltmiete(BigDecimal.valueOf(RandomUtils.nextDouble((double)150.0, (double)1500.0)));
        type.getMietpreise().setKaution("notes about deposit");
        type.getMietpreise().setNebenkosten(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)500.0)));
        type.getMietpreise().setStellplatzMiete(BigDecimal.valueOf(RandomUtils.nextDouble((double)50.0, (double)500.0)));
        type.getMietpreise().setWarmmiete(BigDecimal.valueOf(RandomUtils.nextDouble((double)250.0, (double)2500.0)));
        return FACTORY.createHausMiete(type);
    }

    protected static void initImmobilie(ImmobilieBaseTyp immobilieBaseTyp) {
        immobilieBaseTyp.setAdressdruck(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilieBaseTyp.setAktiveGruppen("active groups");
        immobilieBaseTyp.setAnbieterObjektID("123");
        immobilieBaseTyp.setAusstattung("notes about features");
        immobilieBaseTyp.setGruppierungsID(Long.valueOf(RandomUtils.nextLong((long)1L, (long)9999L)));
        immobilieBaseTyp.setImportmodus(AktionsTyp.AKTUALISIEREN);
        immobilieBaseTyp.setLage("notes about location");
        immobilieBaseTyp.setObjektbeschreibung("notes about the property");
        immobilieBaseTyp.setProvision("commission");
        immobilieBaseTyp.setProvisionshinweis("notes about commission");
        immobilieBaseTyp.setProvisionspflichtig(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilieBaseTyp.setScoutObjektID(BigInteger.valueOf(456L));
        immobilieBaseTyp.setSonstigeAngaben("further notes");
        immobilieBaseTyp.setStatusHP(StatusTyp.AKTIV);
        immobilieBaseTyp.setStatusIS24(StatusTyp.AKTIV);
        immobilieBaseTyp.setStatusVBM(StatusTyp.INAKTIV);
        immobilieBaseTyp.setUeberschrift("title of the property");
        immobilieBaseTyp.setWaehrung(WaehrungTyp.EUR);
        immobilieBaseTyp.setAdresse(FACTORY.createImmobilienAdresseTyp());
        immobilieBaseTyp.getAdresse().setHausnummer("1");
        immobilieBaseTyp.getAdresse().setInternationaleRegion("Berlin");
        immobilieBaseTyp.getAdresse().setLaenderkennzeichen(ISOLaenderCodeTyp.DEU);
        immobilieBaseTyp.getAdresse().setOrt("Berlin");
        immobilieBaseTyp.getAdresse().setPostleitzahl("12345");
        immobilieBaseTyp.getAdresse().setStrasse("name of the street");
        immobilieBaseTyp.setApiSuchfelder(FACTORY.createImmobilieBaseTypApiSuchfelder(FACTORY.createApiSuchfelderTyp()));
        ((ApiSuchfelderTyp)immobilieBaseTyp.getApiSuchfelder().getValue()).setApiSuchfeld1(FACTORY.createApiSuchfelderTypApiSuchfeld1("value1"));
        ((ApiSuchfelderTyp)immobilieBaseTyp.getApiSuchfelder().getValue()).setApiSuchfeld2(FACTORY.createApiSuchfelderTypApiSuchfeld2("value2"));
        ((ApiSuchfelderTyp)immobilieBaseTyp.getApiSuchfelder().getValue()).setApiSuchfeld3(FACTORY.createApiSuchfelderTypApiSuchfeld3("value3"));
        immobilieBaseTyp.setKontaktperson(FACTORY.createKontaktAdresseTyp());
        immobilieBaseTyp.getKontaktperson().setAnrede("addressing");
        immobilieBaseTyp.getKontaktperson().setEMail("tester@test.org");
        immobilieBaseTyp.getKontaktperson().setHausnummer("1");
        immobilieBaseTyp.getKontaktperson().setLaenderkennzeichen(ISOLaenderCodeTyp.DEU);
        immobilieBaseTyp.getKontaktperson().setMobiltelefon("030/123456");
        immobilieBaseTyp.getKontaktperson().setNachname("Mustermann");
        immobilieBaseTyp.getKontaktperson().setOrt("Berlin");
        immobilieBaseTyp.getKontaktperson().setPostleitzahl("13125");
        immobilieBaseTyp.getKontaktperson().setStrasse("name of the street");
        immobilieBaseTyp.getKontaktperson().setTelefax("030/123457");
        immobilieBaseTyp.getKontaktperson().setTelefon("030/123458");
        immobilieBaseTyp.getKontaktperson().setVorname("Max");
        try {
            immobilieBaseTyp.getKontaktperson().setHomepage(new URL("http://mywebsite.com"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        immobilieBaseTyp.setManuelleGeoCodierung(FACTORY.createManuellGeoCodingTyp());
        immobilieBaseTyp.getManuelleGeoCodierung().setTermsRegion("name of region");
        immobilieBaseTyp.getManuelleGeoCodierung().setTermsStadt("name of city");
        immobilieBaseTyp.getManuelleGeoCodierung().setTermsStadtTeil("name of district");
    }

    protected static void write(Is24XmlDocument is24XmlDocument, File file) {
        LOGGER.info("writing document");
        try {
            is24XmlDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(Is24XmlDocument is24XmlDocument, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            is24XmlDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(Is24XmlDocument is24XmlDocument, Writer writer) {
        LOGGER.info("writing document");
        try {
            is24XmlDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(Is24XmlDocument is24XmlDocument) {
        LOGGER.info("writing document");
        try {
            String string = is24XmlDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + SystemUtils.LINE_SEPARATOR + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

