/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.examples.FilemakerWritingExample;
import org.openestate.io.filemaker.FilemakerResultDocument;
import org.openestate.io.filemaker.FilemakerResultMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FilemakerResultMappingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilemakerResultMappingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)FilemakerWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        FilemakerResultMapping filemakerResultMapping = null;
        if (stringArray.length < 1) {
            try {
                filemakerResultMapping = new FilemakerResultDocument(FilemakerResultMappingExample.buildExampleDocument()).toMapping();
            }
            catch (Exception exception) {
                LOGGER.error("Can't create mapping!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(1);
            }
        } else {
            try {
                filemakerResultMapping = new FilemakerResultDocument(XmlUtils.newDocument((File)new File(stringArray[0]))).toMapping();
            }
            catch (Exception exception) {
                LOGGER.error("Can't create mapping from file '" + stringArray[0] + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(1);
            }
        }
        if (filemakerResultMapping == null) {
            LOGGER.error("No mapping was created!");
            System.exit(1);
        }
        for (int i = 0; i < filemakerResultMapping.getRowCount(); ++i) {
            FilemakerResultMapping.Row row = filemakerResultMapping.getRow(i);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50));
            LOGGER.info("record at row " + i);
            LOGGER.info("> recordId = " + row.getRecordId());
            LOGGER.info("> modId = " + row.getModId());
            for (String string : row.getFieldNames()) {
                LOGGER.info("> " + string + " = " + row.getValue(string));
            }
        }
    }

    private static Document buildExampleDocument() throws Exception {
        return XmlUtils.newDocument((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<FMPXMLRESULT xmlns=\"http://www.filemaker.com/fmpxmlresult\">\n  <ERRORCODE>0</ERRORCODE>\n  <PRODUCT BUILD=\"03-20-2006\" NAME=\"FileMaker Pro\" VERSION=\"8.0v3\"/>\n  <DATABASE DATEFORMAT=\"D.m.yyyy\" LAYOUT=\"fmmedia2universal\" NAME=\"AngGes\" RECORDS=\"13723\" TIMEFORMAT=\"k:mm:ss \"/>\n  <METADATA>\n    <FIELD EMPTYOK=\"YES\" MAXREPEAT=\"1\" NAME=\"aNumericField\" TYPE=\"NUMBER\"/>\n    <FIELD EMPTYOK=\"YES\" MAXREPEAT=\"1\" NAME=\"aTextField\" TYPE=\"TEXT\"/>\n  </METADATA>\n  <RESULTSET FOUND=\"2\">\n    <ROW MODID=\"1\" RECORDID=\"2\">\n      <COL>\n        <DATA>123</DATA>\n      </COL>\n      <COL>\n        <DATA>this is a text</DATA>\n      </COL>\n    </ROW>\n    <ROW MODID=\"3\" RECORDID=\"4\">\n      <COL>\n        <DATA>456</DATA>\n      </COL>\n      <COL>\n        <DATA>this is another text</DATA>\n      </COL>\n    </ROW>\n  </RESULTSET>\n</FMPXMLRESULT>");
    }
}

