/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.examples.utils.RandomStringUtils;
import org.openestate.io.idx.IdxPrinter;
import org.openestate.io.idx.IdxRecord;
import org.openestate.io.idx.types.GrossPremium;
import org.openestate.io.idx.types.Language;
import org.openestate.io.idx.types.Media;
import org.openestate.io.idx.types.ObjectType;
import org.openestate.io.idx.types.OfferType;
import org.openestate.io.idx.types.PriceUnit;
import org.openestate.io.idx.types.Salutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)IdxWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        ArrayList<IdxRecord> arrayList = new ArrayList<IdxRecord>();
        arrayList.add(IdxWritingExample.createRecord());
        arrayList.add(IdxWritingExample.createRecord());
        arrayList.add(IdxWritingExample.createRecord());
        arrayList.add(IdxWritingExample.createRecord());
        try {
            IdxWritingExample.write(arrayList, File.createTempFile("output-", ".csv"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        IdxWritingExample.write(arrayList, (OutputStream)new NullOutputStream());
        IdxWritingExample.write(arrayList, (Writer)new NullWriter());
        IdxWritingExample.writeToConsole(arrayList);
    }

    protected static IdxRecord createRecord() {
        IdxRecord idxRecord = new IdxRecord();
        idxRecord.setAdvertisementId(RandomStringUtils.random(5));
        idxRecord.setAgencyCity("Berlin");
        idxRecord.setAgencyCountry(Locale.GERMANY.getCountry());
        idxRecord.setAgencyEmail("tester@test.org");
        idxRecord.setAgencyFax("030/123456");
        idxRecord.setAgencyId(RandomStringUtils.random(5));
        idxRecord.setAgencyName("agency name");
        idxRecord.setAgencyName2("additional agency name");
        idxRecord.setAgencyPhone("030/123457");
        idxRecord.setAgencyReference(RandomStringUtils.random(5));
        idxRecord.setAgencyStreet("example street 123");
        idxRecord.setAgencyZip("12345");
        idxRecord.setAnimalAllowed(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setAvailableFrom(Calendar.getInstance());
        idxRecord.setBalcony(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setBillingCompany("agency name");
        idxRecord.setBillingCountry("Germany");
        idxRecord.setBillingFirstName("Max");
        idxRecord.setBillingLanguage(Language.GERMAN);
        idxRecord.setBillingMobile("030/132456");
        idxRecord.setBillingName("Mustermann");
        idxRecord.setBillingPhone("030/123457");
        idxRecord.setBillingPhone2("030/123458");
        idxRecord.setBillingPlaceName("Berlin");
        idxRecord.setBillingPostBox("additional address notes");
        idxRecord.setBillingSalutation(Salutation.MALE);
        idxRecord.setBillingStreet("example street 123");
        idxRecord.setBillingZip("12345");
        idxRecord.setBuildingLandConnected(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setCableTv(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setCarryingCapacityCrane((Number)RandomUtils.nextDouble((double)500.0, (double)5000.0));
        idxRecord.setCarryingCapacityElevator((Number)RandomUtils.nextDouble((double)500.0, (double)5000.0));
        idxRecord.setCeilingHeight((Number)RandomUtils.nextDouble((double)2.0, (double)10.0));
        idxRecord.setChildFriendly(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setCornerHouse(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setCurrency(Currency.getInstance("EUR"));
        idxRecord.setDistanceKindergarten((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setDistanceMotorway((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setDistancePublicTransport((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setDistanceSchool1((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setDistanceSchool2((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setDistanceShop((Number)RandomUtils.nextInt((int)50, (int)5000));
        idxRecord.setElevator(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setFireplace(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setFlatSharingCommunity(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setFloor((Number)RandomUtils.nextInt((int)0, (int)10));
        idxRecord.setGarage(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setGardenhouse(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setGasSupply(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setGrossPremium(GrossPremium.FROM_4_UNTIL_5);
        idxRecord.setHallHeight((Number)RandomUtils.nextDouble((double)3.0, (double)15.0));
        idxRecord.setIsdn(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setLastModified(Calendar.getInstance());
        idxRecord.setLiftingPlatform(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setMaximalFloorLoading((Number)RandomUtils.nextDouble((double)50.0, (double)5000.0));
        idxRecord.setMiddleHouse(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setMinEnergyCertified(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setMinEnergyGeneral(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setNewBuilding(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setNumberOfApartments((Number)RandomUtils.nextDouble((double)1.0, (double)10.0));
        idxRecord.setNumberOfFloors((Number)RandomUtils.nextInt((int)1, (int)10));
        idxRecord.setNumberOfRooms((Number)RandomUtils.nextDouble((double)1.0, (double)10.0));
        idxRecord.setObjectCity("Berlin");
        idxRecord.setObjectCountry(Locale.GERMANY.getCountry());
        idxRecord.setObjectDescription("some description" + System.lineSeparator() + " about the object");
        idxRecord.setObjectSituation("some description about the location");
        idxRecord.setObjectState("BE");
        idxRecord.setObjectStreet("example street 124");
        idxRecord.setObjectTitle("title of object");
        idxRecord.setObjectType(ObjectType.HOUSE_VILLA);
        idxRecord.setObjectZip("12345");
        idxRecord.setOfferType(OfferType.SALE);
        idxRecord.setOldBuilding(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setOwnObjectUrl("http://test.org/object/123");
        idxRecord.setParking(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setPowerSupply(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setPriceUnit(PriceUnit.MONTHLY);
        idxRecord.setRailwayTerminal(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setRaisedGroundFloor(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setRamp(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setRefHouse(RandomStringUtils.random(5));
        idxRecord.setRefObject(RandomStringUtils.random(5));
        idxRecord.setRefProperty(RandomStringUtils.random(5));
        idxRecord.setRentExtra((Number)RandomUtils.nextLong((long)100L, (long)1000L));
        idxRecord.setRentNet((Number)RandomUtils.nextLong((long)100L, (long)1000L));
        idxRecord.setRestrooms(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setSellingPrice((Number)RandomUtils.nextLong((long)100L, (long)1000L));
        idxRecord.setSenderId("OpenEstate.org");
        idxRecord.setSewageSupply(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setSparefield1("spare field 1");
        idxRecord.setSparefield2("spare field 2");
        idxRecord.setSparefield3("spare field 3");
        idxRecord.setSparefield4("spare field 4");
        idxRecord.setSurfaceLiving((Number)RandomUtils.nextLong((long)50L, (long)300L));
        idxRecord.setSurfaceProperty((Number)RandomUtils.nextLong((long)100L, (long)1000L));
        idxRecord.setSurfaceUsable((Number)RandomUtils.nextLong((long)100L, (long)1000L));
        idxRecord.setSwimmingpool(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setUnderBuildingLaws(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setUnderRoof(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setUrl("http://test.org/object/123");
        idxRecord.setView(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setVisitName("Max Mustermann");
        idxRecord.setVisitPhone("030/123456");
        idxRecord.setVisitRemark("notes about the contact person");
        idxRecord.setVolume((Number)RandomUtils.nextLong((long)50L, (long)500L));
        idxRecord.setWaterSupply(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setWheelcharAccessible(RandomUtils.nextInt((int)0, (int)2) == 1);
        idxRecord.setYearBuilt((Number)RandomUtils.nextInt((int)1900, (int)1995));
        idxRecord.setYearRenovated((Number)RandomUtils.nextInt((int)1995, (int)2010));
        idxRecord.setDocument(new Media("document.pdf", "a document about the object"));
        idxRecord.setMovie(new Media("document.mp4", "a document about the object"));
        idxRecord.setPicture1(new Media("image1.jpg", "title for image 1", "description for image 1"));
        idxRecord.setPicture2(new Media("image2.jpg", "title for image 2", "description for image 2"));
        idxRecord.setPicture3(new Media("image3.jpg", "title for image 3", "description for image 3"));
        idxRecord.setPicture4(new Media("image4.jpg", "title for image 4", "description for image 4"));
        idxRecord.setPicture5(new Media("image5.jpg", "title for image 5", "description for image 5"));
        idxRecord.setPicture6(new Media("image6.jpg", "title for image 6", "description for image 6"));
        idxRecord.setPicture7(new Media("image7.jpg", "title for image 7", "description for image 7"));
        idxRecord.setPicture8(new Media("image8.jpg", "title for image 8", "description for image 8"));
        idxRecord.setPicture9(new Media("image9.jpg", "title for image 9", "description for image 9"));
        idxRecord.setPicture10(new Media("image10.jpg", "title for image 10", "description for image 10"));
        idxRecord.setPicture11(new Media("image11.jpg", "title for image 11", "description for image 11"));
        idxRecord.setPicture12(new Media("image12.jpg", "title for image 12", "description for image 12"));
        idxRecord.setPicture13(new Media("image13.jpg", "title for image 13", "description for image 13"));
        return idxRecord;
    }

    protected static void write(List<IdxRecord> list, File file) {
        LOGGER.info("writing document");
        try (IdxPrinter idxPrinter = IdxPrinter.create((File)file);){
            idxPrinter.printRecords(list);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(List<IdxRecord> list, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            IdxPrinter idxPrinter = IdxPrinter.create((OutputStream)outputStream);
            idxPrinter.printRecords(list);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(List<IdxRecord> list, Writer writer) {
        LOGGER.info("writing document");
        try {
            IdxPrinter idxPrinter = IdxPrinter.create((Writer)writer);
            idxPrinter.printRecords(list);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(List<IdxRecord> list) {
        LOGGER.info("writing document");
        StringBuilder stringBuilder = new StringBuilder();
        try (IdxPrinter idxPrinter = IdxPrinter.create((StringBuilder)stringBuilder);){
            idxPrinter.printRecords(list);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + System.lineSeparator() + stringBuilder.toString());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

