/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.examples.utils.RandomStringUtils;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.xml.Aktion;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Haus;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.openestate.io.immoxml.xml.ObjectFactory;
import org.openestate.io.immoxml.xml.Uebertragung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmoXmlWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = ImmoXmlUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)ImmoXmlWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Immoxml immoxml = FACTORY.createImmoxml();
        immoxml.setUebertragung(ImmoXmlWritingExample.createUebertragung());
        immoxml.getAnbieter().add(ImmoXmlWritingExample.createAnbieter());
        ImmoXmlDocument immoXmlDocument = null;
        try {
            immoXmlDocument = ImmoXmlDocument.newDocument((Immoxml)immoxml);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            ImmoXmlWritingExample.write(immoXmlDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        ImmoXmlWritingExample.write(immoXmlDocument, (OutputStream)new NullOutputStream());
        ImmoXmlWritingExample.write(immoXmlDocument, (Writer)new NullWriter());
        ImmoXmlWritingExample.writeToConsole(immoXmlDocument);
    }

    protected static Anbieter createAnbieter() {
        Anbieter anbieter = FACTORY.createAnbieter();
        anbieter.setAnbieternr("123456");
        anbieter.setFirma("Agency Name");
        anbieter.setImmoxmlAnid("123456");
        anbieter.getImmobilie().add(ImmoXmlWritingExample.createImmobilie());
        anbieter.getImmobilie().add(ImmoXmlWritingExample.createImmobilie());
        return anbieter;
    }

    protected static Immobilie createImmobilie() {
        Immobilie immobilie = FACTORY.createImmobilie();
        immobilie.setVerwaltungTechn(FACTORY.createVerwaltungTechn());
        immobilie.getVerwaltungTechn().setAktion(FACTORY.createAktion());
        immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
        immobilie.getVerwaltungTechn().setObjektnrIntern(RandomStringUtils.randomNumeric(10));
        immobilie.setObjektkategorie(FACTORY.createObjektkategorie());
        immobilie.getObjektkategorie().setNutzungsart(FACTORY.createNutzungsart());
        immobilie.getObjektkategorie().getNutzungsart().setANLAGE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().getNutzungsart().setGEWERBE(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().getNutzungsart().setWAZ(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().getNutzungsart().setWOHNEN(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        immobilie.getObjektkategorie().setVermarktungsart(FACTORY.createVermarktungsart());
        immobilie.getObjektkategorie().getVermarktungsart().setKAUF(Boolean.valueOf(true));
        immobilie.getObjektkategorie().setObjektart(FACTORY.createObjektart());
        Haus haus = FACTORY.createHaus();
        haus.setHaustyp(Haus.Haustyp.EINFAMILIENHAUS);
        immobilie.getObjektkategorie().getObjektart().getHaus().add(haus);
        immobilie.setGeo(FACTORY.createGeo());
        immobilie.getGeo().setPlz(RandomStringUtils.randomNumeric(5));
        immobilie.getGeo().setOrt("Berlin");
        immobilie.getGeo().setLand(FACTORY.createLand());
        immobilie.getGeo().getLand().setIsoLand(Locale.GERMANY.getISO3Country());
        immobilie.setPreise(FACTORY.createPreise());
        immobilie.getPreise().setHeizkosten(new BigDecimal("456.0"));
        immobilie.getPreise().setKaufpreis(new BigDecimal("123456.79"));
        immobilie.setAusstattung(FACTORY.createAusstattung());
        immobilie.getAusstattung().setGartennutzung(Boolean.valueOf(true));
        immobilie.getAusstattung().setHeizungsart(FACTORY.createHeizungsart());
        immobilie.getAusstattung().getHeizungsart().setZENTRAL(Boolean.valueOf(true));
        immobilie.getAusstattung().getHeizungsart().setFUSSBODEN(Boolean.valueOf(true));
        immobilie.setFreitexte(FACTORY.createFreitexte());
        immobilie.getFreitexte().setObjekttitel("A title for the property.");
        immobilie.getFreitexte().setObjektbeschreibung("Some longer descriptive text about the property.");
        immobilie.setKontaktperson(FACTORY.createKontaktperson());
        immobilie.getKontaktperson().setName("Max Mustermann");
        immobilie.getKontaktperson().setEmailDirekt("max@mustermann.org");
        immobilie.getKontaktperson().setTelDurchw("030/123456789");
        immobilie.getKontaktperson().setPlz(RandomStringUtils.randomNumeric(5));
        immobilie.getKontaktperson().setOrt("Berlin");
        immobilie.getKontaktperson().setLand(FACTORY.createLand());
        immobilie.getKontaktperson().getLand().setIsoLand(Locale.GERMANY.getISO3Country());
        return immobilie;
    }

    protected static Uebertragung createUebertragung() {
        Uebertragung uebertragung = FACTORY.createUebertragung();
        uebertragung.setArt(Uebertragung.Art.OFFLINE);
        uebertragung.setSendersoftware("OpenEstate-IO");
        uebertragung.setTechnEmail("test@test.org");
        uebertragung.setUmfang(Uebertragung.Umfang.VOLL);
        return uebertragung;
    }

    protected static void write(ImmoXmlDocument immoXmlDocument, File file) {
        LOGGER.info("writing document with version " + immoXmlDocument.getDocumentVersion());
        try {
            immoXmlDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(ImmoXmlDocument immoXmlDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + immoXmlDocument.getDocumentVersion());
        try {
            immoXmlDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(ImmoXmlDocument immoXmlDocument, Writer writer) {
        LOGGER.info("writing document with version " + immoXmlDocument.getDocumentVersion());
        try {
            immoXmlDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(ImmoXmlDocument immoXmlDocument) {
        LOGGER.info("writing document with version " + immoXmlDocument.getDocumentVersion());
        try {
            String string = immoXmlDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + System.lineSeparator() + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

