/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.examples.utils.RandomStringUtils;
import org.openestate.io.is24_csv.Is24CsvPrinter;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.records.HausKauf;
import org.openestate.io.is24_csv.records.WohnungMiete;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Auswahl;
import org.openestate.io.is24_csv.types.Bauphase;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.Datei;
import org.openestate.io.is24_csv.types.DateiSuffix;
import org.openestate.io.is24_csv.types.DateiTyp;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.Importmodus;
import org.openestate.io.is24_csv.types.ObjektkategorieHaus;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnung;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.Stellplatz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)Is24CsvWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        ArrayList<Is24CsvRecord> arrayList = new ArrayList<Is24CsvRecord>();
        arrayList.add(Is24CsvWritingExample.createHausKaufRecord());
        arrayList.add(Is24CsvWritingExample.createHausKaufRecord());
        arrayList.add(Is24CsvWritingExample.createWohnungMieteRecord());
        arrayList.add(Is24CsvWritingExample.createWohnungMieteRecord());
        try {
            Is24CsvWritingExample.write(arrayList, File.createTempFile("output-", ".csv"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        Is24CsvWritingExample.write(arrayList, (OutputStream)new NullOutputStream());
        Is24CsvWritingExample.write(arrayList, (Writer)new NullWriter());
        Is24CsvWritingExample.writeToConsole(arrayList);
    }

    protected static Is24CsvRecord createHausKaufRecord() {
        HausKauf hausKauf = new HausKauf();
        Is24CsvWritingExample.init((Is24CsvRecord)hausKauf);
        hausKauf.setAnzahlBadezimmer((Number)RandomUtils.nextInt((int)1, (int)5));
        hausKauf.setAnzahlGarageStellplatz((Number)RandomUtils.nextInt((int)1, (int)5));
        hausKauf.setAnzahlSchlafzimmer((Number)RandomUtils.nextInt((int)1, (int)5));
        hausKauf.setAusstattung(Ausstattung.GEHOBEN);
        hausKauf.setBarrierefrei(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setBaujahr((Number)RandomUtils.nextInt((int)1900, (int)1990));
        hausKauf.setBauphase(Bauphase.FERTIG_GESTELLT);
        hausKauf.setBefeuerungsart(Befeuerungsart.KOHLE);
        hausKauf.setDenkmalschutz(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setEinliegerwohnung(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setEnergieausweisInklWarmwasser(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setEnergieausweisKennwert((Number)RandomUtils.nextDouble((double)50.0, (double)500.0));
        hausKauf.setEnergieausweisTyp(EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT);
        hausKauf.setFerienhaus(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setGaesteWc(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setGrundstuecksflaeche((Number)RandomUtils.nextDouble((double)200.0, (double)2000.0));
        hausKauf.setHeizungsart(Heizungsart.ZENTRALHEIZUNG);
        hausKauf.setKaufpreis((Number)RandomUtils.nextDouble((double)100000.0, (double)1000000.0));
        hausKauf.setKeller(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setMieteinnahmenProMonat((Number)RandomUtils.nextDouble((double)5000.0, (double)50000.0));
        hausKauf.setNutzflaeche((Number)RandomUtils.nextDouble((double)200.0, (double)1000.0));
        hausKauf.setObjektkategorie(ObjektkategorieHaus.MEHRFAMILIENHAUS);
        hausKauf.setObjektzustand(Objektzustand.GEPFLEGT);
        hausKauf.setSanierungsjahr((Number)RandomUtils.nextInt((int)1990, (int)2010));
        hausKauf.setStellplatz(Stellplatz.CARPORT);
        hausKauf.setStellplatzpreis((Number)RandomUtils.nextDouble((double)1000.0, (double)5000.0));
        hausKauf.setVerfuegbarAb("notes about availability");
        hausKauf.setVermietet(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        hausKauf.setWohnflaeche((Number)RandomUtils.nextDouble((double)100.0, (double)500.0));
        hausKauf.setZimmer((Number)RandomUtils.nextInt((int)1, (int)10));
        return hausKauf;
    }

    protected static Is24CsvRecord createWohnungMieteRecord() {
        WohnungMiete wohnungMiete = new WohnungMiete();
        Is24CsvWritingExample.init((Is24CsvRecord)wohnungMiete);
        wohnungMiete.setAnzahlBadezimmer((Number)RandomUtils.nextInt((int)1, (int)5));
        wohnungMiete.setAnzahlGarageStellplatz((Number)RandomUtils.nextInt((int)1, (int)5));
        wohnungMiete.setAnzahlSchlafzimmer((Number)RandomUtils.nextInt((int)1, (int)5));
        wohnungMiete.setAufzug(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setAusstattung(Ausstattung.GEHOBEN);
        wohnungMiete.setBalkonTerrasse(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setBarrierefrei(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setBaujahr((Number)RandomUtils.nextInt((int)1900, (int)1990));
        wohnungMiete.setBefeuerungsart(Befeuerungsart.OEL);
        wohnungMiete.setEinbaukueche(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setEnergieausweisInklWarmwasser(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setEnergieausweisKennwert((Number)RandomUtils.nextDouble((double)50.0, (double)500.0));
        wohnungMiete.setEnergieausweisTyp(EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT);
        wohnungMiete.setEtage((Number)RandomUtils.nextInt((int)0, (int)10));
        wohnungMiete.setEtagenzahl((Number)RandomUtils.nextInt((int)0, (int)10));
        wohnungMiete.setFoerderung(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setGaesteWc(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setGartennutzung(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setHaustiere(Auswahl.NACH_VEREINBARUNG);
        wohnungMiete.setHeizkosten((Number)RandomUtils.nextDouble((double)100.0, (double)500.0));
        wohnungMiete.setHeizungsart(Heizungsart.OFENHEIZUNG);
        wohnungMiete.setKaltmiete((Number)RandomUtils.nextDouble((double)500.0, (double)3000.0));
        wohnungMiete.setKaution("notes about deposit");
        wohnungMiete.setKeller(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setNebenkosten((Number)RandomUtils.nextDouble((double)100.0, (double)500.0));
        wohnungMiete.setNebenkostenInklHeizkosten(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setNutzflaeche((Number)RandomUtils.nextDouble((double)50.0, (double)500.0));
        wohnungMiete.setObjektkategorie(ObjektkategorieWohnung.PENTHOUSE);
        wohnungMiete.setObjektzustand(Objektzustand.MODERNISIERT);
        wohnungMiete.setSanierungsjahr((Number)RandomUtils.nextInt((int)1990, (int)2010));
        wohnungMiete.setSeniorengerecht(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        wohnungMiete.setStellplatz(Stellplatz.TIEFGARAGE);
        wohnungMiete.setStellplatzmiete((Number)RandomUtils.nextDouble((double)50.0, (double)500.0));
        wohnungMiete.setVerfuegbarAb("notes about availability");
        wohnungMiete.setWarmmiete((Number)RandomUtils.nextDouble((double)500.0, (double)2000.0));
        wohnungMiete.setWohnflaeche((Number)RandomUtils.nextDouble((double)50.0, (double)250.0));
        wohnungMiete.setZimmer((Number)RandomUtils.nextInt((int)1, (int)10));
        return wohnungMiete;
    }

    protected static void init(Is24CsvRecord is24CsvRecord) {
        is24CsvRecord.setAdressdruck(RandomUtils.nextInt((int)0, (int)2) == 1);
        is24CsvRecord.setAktiv(RandomUtils.nextInt((int)0, (int)2) == 1);
        is24CsvRecord.setAnbieterObjektId(RandomStringUtils.random(5));
        is24CsvRecord.setBeschreibungAusstattung("description about features");
        is24CsvRecord.setBeschreibungLage("description about location");
        is24CsvRecord.setBeschreibungObjekt("description about object");
        is24CsvRecord.setBeschreibungSonstiges("further descriptions");
        is24CsvRecord.setGruppierungId((Number)RandomUtils.nextInt((int)0, (int)1000));
        is24CsvRecord.setImportmodus(Importmodus.IMPORTIEREN);
        is24CsvRecord.setInternationaleRegion("name of international region");
        is24CsvRecord.setKontaktAnrede("Mr");
        is24CsvRecord.setKontaktEmail("tester@test.org");
        is24CsvRecord.setKontaktHausNr("123");
        is24CsvRecord.setKontaktLand("DEU");
        is24CsvRecord.setKontaktMobiltelefon("030/123456");
        is24CsvRecord.setKontaktNachname("Mustermann");
        is24CsvRecord.setKontaktOrt("Berlin");
        is24CsvRecord.setKontaktPlz("12345");
        is24CsvRecord.setKontaktStrasse("example street");
        is24CsvRecord.setKontaktTelefax("030/123457");
        is24CsvRecord.setKontaktTelefon("030/123458");
        is24CsvRecord.setKontaktVorname("Max");
        is24CsvRecord.setKontaktWebseite("http://www.test.org/");
        is24CsvRecord.setObjektHausNr("124");
        is24CsvRecord.setObjektLand("DEU");
        is24CsvRecord.setObjektOrt("Berlin");
        is24CsvRecord.setObjektPlz("12345");
        is24CsvRecord.setObjektStrasse("example street");
        is24CsvRecord.setProvision("commission");
        is24CsvRecord.setProvisionpflichtig(RandomUtils.nextInt((int)0, (int)2) == 1);
        is24CsvRecord.setProvisionshinweis("notes about commission");
        is24CsvRecord.setScoutKundenId(RandomStringUtils.random(5));
        is24CsvRecord.setScoutObjektId(RandomStringUtils.random(5));
        is24CsvRecord.setUeberschrift("a nice title for the object");
        is24CsvRecord.setWaehrung(Currency.getInstance("EUR"));
        is24CsvRecord.setDatei1(new Datei("test1.jpg", DateiTyp.BILD, DateiSuffix.JPG, "a nice image"));
        is24CsvRecord.setDatei2(new Datei("test2.png", DateiTyp.BILD, DateiSuffix.PNG, "another nice image"));
        is24CsvRecord.setDatei3(new Datei("test3.pdf", DateiTyp.GRUNDRISS_PDF, DateiSuffix.PDF, "a document with groundplan"));
        is24CsvRecord.setDatei4(new Datei("http://www.test.org/", DateiTyp.LINK, null, "agency website"));
    }

    protected static void write(List<Is24CsvRecord> list, File file) {
        LOGGER.info("writing document");
        try (Is24CsvPrinter is24CsvPrinter = Is24CsvPrinter.create((File)file);){
            is24CsvPrinter.printRecords(list);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(List<Is24CsvRecord> list, OutputStream outputStream) {
        LOGGER.info("writing document");
        try {
            Is24CsvPrinter is24CsvPrinter = Is24CsvPrinter.create((OutputStream)outputStream);
            is24CsvPrinter.printRecords(list);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(List<Is24CsvRecord> list, Writer writer) {
        LOGGER.info("writing document");
        try {
            Is24CsvPrinter is24CsvPrinter = Is24CsvPrinter.create((Writer)writer);
            is24CsvPrinter.printRecords(list);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(List<Is24CsvRecord> list) {
        LOGGER.info("writing document");
        StringBuilder stringBuilder = new StringBuilder();
        try (Is24CsvPrinter is24CsvPrinter = Is24CsvPrinter.create((StringBuilder)stringBuilder);){
            is24CsvPrinter.printRecords(list);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + System.lineSeparator() + stringBuilder.toString());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

