/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.examples.utils.RandomStringUtils;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.CurrencyType;
import org.openestate.io.kyero.xml.EnergyRatingMarkType;
import org.openestate.io.kyero.xml.ImagesType;
import org.openestate.io.kyero.xml.KyeroType;
import org.openestate.io.kyero.xml.ObjectFactory;
import org.openestate.io.kyero.xml.PriceFreqType;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyeroWritingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroWritingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";
    private static final ObjectFactory FACTORY = KyeroUtils.getFactory();
    private static final boolean PRETTY_PRINT = true;

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)KyeroWritingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        Root root = FACTORY.createRoot();
        root.setKyero(KyeroWritingExample.createKyero());
        root.setAgent(KyeroWritingExample.createAgent());
        root.getProperty().add(KyeroWritingExample.createProperty());
        root.getProperty().add(KyeroWritingExample.createProperty());
        root.getProperty().add(KyeroWritingExample.createProperty());
        KyeroDocument kyeroDocument = null;
        try {
            kyeroDocument = KyeroDocument.newDocument((Root)root);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create XML document!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
        try {
            KyeroWritingExample.write(kyeroDocument, File.createTempFile("output-", ".xml"));
        }
        catch (IOException iOException) {
            LOGGER.error("Can't create temporary file!");
            LOGGER.error("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            System.exit(1);
        }
        KyeroWritingExample.write(kyeroDocument, (OutputStream)new NullOutputStream());
        KyeroWritingExample.write(kyeroDocument, (Writer)new NullWriter());
        KyeroWritingExample.writeToConsole(kyeroDocument);
        kyeroDocument.downgrade((XmlVersion)KyeroVersion.V2_1);
        KyeroWritingExample.writeToConsole(kyeroDocument);
    }

    protected static Root.Agent createAgent() {
        Root.Agent agent = FACTORY.createRootAgent();
        agent.setAddr1("first address line");
        agent.setAddr2("second address line");
        agent.setCountry("Germany");
        agent.setEmail("test@test.org");
        agent.setFax("030/123456");
        agent.setId(BigInteger.valueOf(RandomUtils.nextLong((long)1L, (long)10000L)));
        agent.setMob("030/123457");
        agent.setName("name of the company");
        agent.setPostcode("12345");
        agent.setRegion("Berlin");
        agent.setTel("030/123458");
        agent.setTown("Berlin");
        return agent;
    }

    protected static KyeroType createKyero() {
        KyeroType kyeroType = FACTORY.createKyeroType();
        kyeroType.setFeedGenerated(Calendar.getInstance());
        kyeroType.setFeedVersion(KyeroUtils.VERSION.toXmlVersion());
        return kyeroType;
    }

    protected static PropertyType createProperty() {
        String string = RandomStringUtils.random(5);
        int n = 0;
        PropertyType propertyType = FACTORY.createPropertyType();
        propertyType.setBaths(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)5L)));
        propertyType.setBeds(BigInteger.valueOf(RandomUtils.nextLong((long)0L, (long)5L)));
        propertyType.setCountry("Germany");
        propertyType.setCurrency(CurrencyType.EUR);
        propertyType.setDate(Calendar.getInstance());
        propertyType.setId(string);
        propertyType.setLeasehold(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setLocationDetail("some details about the location");
        propertyType.setNewBuild(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setNotes("some notes about the property");
        propertyType.setPartOwnership(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setPool(Boolean.valueOf(RandomUtils.nextInt((int)0, (int)2) == 1));
        propertyType.setPrice(Long.valueOf(RandomUtils.nextLong((long)10000L, (long)9999999L)));
        propertyType.setPriceFreq(PriceFreqType.SALE);
        propertyType.setProvince("Berlin");
        propertyType.setRef(RandomStringUtils.random(5));
        propertyType.setTown("Berlin");
        propertyType.setType("house");
        propertyType.setDesc(FACTORY.createLangType());
        propertyType.getDesc().setCa("Catalan property description");
        propertyType.getDesc().setDa("Danish property description");
        propertyType.getDesc().setDe("German property description");
        propertyType.getDesc().setEn("English property description");
        propertyType.getDesc().setEs("Spanish property description");
        propertyType.getDesc().setFi("Finnish property description");
        propertyType.getDesc().setFr("French property description");
        propertyType.getDesc().setIt("Italian property description");
        propertyType.getDesc().setNl("Dutch property description");
        propertyType.getDesc().setNo("Norwegian property description");
        propertyType.getDesc().setPt("Portuguese property description");
        propertyType.getDesc().setRu("Russian property description");
        propertyType.getDesc().setSv("Swedish property description");
        propertyType.setEnergyRating(FACTORY.createEnergyRatingType());
        propertyType.getEnergyRating().setConsumption(EnergyRatingMarkType.C);
        propertyType.getEnergyRating().setEmissions(EnergyRatingMarkType.E);
        propertyType.setFeatures(FACTORY.createFeaturesType());
        propertyType.getFeatures().getFeature().add("name of a feature");
        propertyType.getFeatures().getFeature().add("name of another feature");
        propertyType.setImages(FACTORY.createImagesType());
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.getImages().getImage().add(KyeroWritingExample.createPropertyImage(string, ++n));
        propertyType.setLocation(FACTORY.createGpsLocationType());
        propertyType.getLocation().setLatitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        propertyType.getLocation().setLongitude(BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)90.0)));
        propertyType.setSurfaceArea(FACTORY.createSurfaceType());
        propertyType.getSurfaceArea().setBuilt(BigInteger.valueOf(RandomUtils.nextLong((long)50L, (long)250L)));
        propertyType.getSurfaceArea().setPlot(BigInteger.valueOf(RandomUtils.nextLong((long)100L, (long)1500L)));
        propertyType.setUrl(FACTORY.createUrlType());
        try {
            propertyType.getUrl().setCa(new URI("http://catalan.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setDa(new URI("http://danish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setDe(new URI("http://german.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEn(new URI("http://english.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setEs(new URI("http://spanish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setFi(new URI("http://finnish.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setFr(new URI("http://french.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setIt(new URI("http://italian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setNl(new URI("http://dutch.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setNo(new URI("http://norwegian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setPt(new URI("http://portuguese.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setRu(new URI("http://russian.website.com/property/" + string + ".htm"));
            propertyType.getUrl().setSv(new URI("http://swedish.website.com/property/" + string + ".htm"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return propertyType;
    }

    protected static ImagesType.Image createPropertyImage(String string, int n) {
        ImagesType.Image image = FACTORY.createImagesTypeImage();
        image.setId(Integer.valueOf(n));
        try {
            image.setUrl(new URI("http://website.com/property/" + string + "/image_" + n + ".jpg"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return image;
    }

    protected static void write(KyeroDocument kyeroDocument, File file) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(file, true);
            LOGGER.info("> written to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a file!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(KyeroDocument kyeroDocument, OutputStream outputStream) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(outputStream, true);
            LOGGER.info("> written to a java.io.OutputStream");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void write(KyeroDocument kyeroDocument, Writer writer) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            kyeroDocument.toXml(writer, true);
            LOGGER.info("> written to a java.io.Writer");
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into an OutputStream!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    protected static void writeToConsole(KyeroDocument kyeroDocument) {
        LOGGER.info("writing document with version " + kyeroDocument.getDocumentVersion());
        try {
            String string = kyeroDocument.toXmlString(true);
            LOGGER.info(StringUtils.repeat((String)"-", (int)50) + System.lineSeparator() + string);
        }
        catch (Exception exception) {
            LOGGER.error("Can't write document into a string!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
        }
    }
}

