/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoFeedbackDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Objekt;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.OpenimmoFeedback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OpenImmoReadingExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoReadingExample.class);
    private static final String PACKAGE = "/org/openestate/io/examples";

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((URL)OpenImmoReadingExample.class.getResource("/org/openestate/io/examples/log4j.properties"));
        if (stringArray.length < 1) {
            try {
                OpenImmoReadingExample.read(OpenImmoReadingExample.class.getResourceAsStream("/org/openestate/io/examples/openimmo.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example transfer file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
            try {
                OpenImmoReadingExample.read(OpenImmoReadingExample.class.getResourceAsStream("/org/openestate/io/examples/openimmo-feedback.xml"));
            }
            catch (Exception exception) {
                LOGGER.error("Can't read example feedback file!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(2);
            }
        } else {
            for (String string : stringArray) {
                try {
                    OpenImmoReadingExample.read(new File(string));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read file '" + string + "'!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    System.exit(2);
                }
            }
        }
    }

    protected static void read(File file) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process file: " + file.getAbsolutePath());
        if (!file.isFile()) {
            LOGGER.warn("> provided file is invalid");
            return;
        }
        OpenImmoDocument openImmoDocument = OpenImmoUtils.createDocument((File)file);
        if (openImmoDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else if (openImmoDocument.isFeedback()) {
            OpenImmoReadingExample.printToConsole((OpenImmoFeedbackDocument)openImmoDocument);
        } else if (openImmoDocument.isTransfer()) {
            OpenImmoReadingExample.printToConsole((OpenImmoTransferDocument)openImmoDocument);
        } else {
            LOGGER.warn("> unsupported type of document: " + openImmoDocument.getClass().getName());
        }
    }

    protected static void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, JAXBException {
        LOGGER.info("process example file");
        OpenImmoDocument openImmoDocument = OpenImmoUtils.createDocument((InputStream)inputStream);
        if (openImmoDocument == null) {
            LOGGER.warn("> provided XML is not supported");
        } else if (openImmoDocument.isFeedback()) {
            OpenImmoReadingExample.printToConsole((OpenImmoFeedbackDocument)openImmoDocument);
        } else if (openImmoDocument.isTransfer()) {
            OpenImmoReadingExample.printToConsole((OpenImmoTransferDocument)openImmoDocument);
        } else {
            LOGGER.warn("> unsupported type of document: " + openImmoDocument.getClass().getName());
        }
    }

    protected static void printToConsole(OpenImmoFeedbackDocument openImmoFeedbackDocument) throws JAXBException {
        LOGGER.info("> process feedback document in version " + openImmoFeedbackDocument.getDocumentVersion());
        OpenimmoFeedback openimmoFeedback = openImmoFeedbackDocument.toObject();
        for (Objekt objekt : openimmoFeedback.getObjekt()) {
            String string = !StringUtils.isBlank((CharSequence)objekt.getOobjId()) ? objekt.getOobjId().trim() : "???";
            String string2 = !StringUtils.isBlank((CharSequence)objekt.getBezeichnung()) ? objekt.getBezeichnung().trim() : "???";
            LOGGER.info(">> feedback for object '" + string + "' with title '" + string2 + "'");
        }
    }

    protected static void printToConsole(OpenImmoTransferDocument openImmoTransferDocument) throws JAXBException {
        LOGGER.info("> process transfer document in version " + openImmoTransferDocument.getDocumentVersion());
        Openimmo openimmo = openImmoTransferDocument.toObject();
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            LOGGER.info(">> found agency '" + anbieter.getAnbieternr() + "'");
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                String string = immobilie.getVerwaltungTechn() != null ? immobilie.getVerwaltungTechn().getObjektnrIntern() : "???";
                String string2 = immobilie.getFreitexte() != null ? immobilie.getFreitexte().getObjekttitel() : "???";
                LOGGER.info(">>> found object '" + string + "' with title '" + string2 + "'");
            }
        }
    }
}

